/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.MyTextArea;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FormTextArea
extends JScrollPane
implements ObjectPainter,
DocumentListener,
CaretListener,
Movable {
    private DocView docView;
    private DTextAreaElement text;
    private ObjectBox box;
    private JTextArea textArea;

    FormTextArea(DocView docView, DElement dElement) {
        this.docView = docView;
        this.text = (DTextAreaElement)dElement;
        int n = dElement.getAttributeAsInt("rows");
        int n2 = dElement.getAttributeAsInt("cols");
        if (n < 0) {
            n = 3;
        }
        if (n2 < 0) {
            n2 = 20;
        }
        this.textArea = new MyTextArea(n, n2, docView, this.text);
        this.setViewportView(this.textArea);
        this.checkAttributes();
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addCaretListener(this);
        this.textArea.setCaretPosition(0);
        this.doLayout();
        this.validateTree();
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            super.paintComponent(graphics);
        } else {
            graphics.setColor(Color.darkGray);
            graphics.translate(1, 1);
            graphics.drawRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.text.getValue();
            if (string != null) {
                int n;
                int n2 = 0;
                fontMetrics = this.getFontMetrics(this.getFont());
                Dimension dimension = this.getSize();
                Vector vector = this.breakIntoLines(string, dimension.width, fontMetrics);
                Enumeration enumeration = vector.elements();
                for (n2 = n = fontMetrics.getMaxAscent(); enumeration.hasMoreElements() && n2 <= dimension.height; n2 += fontMetrics.getHeight()) {
                    graphics.drawString((String)enumeration.nextElement(), 0, n2);
                }
                fontMetrics = null;
            }
            graphics.setClip(0, 0, this.getSize().width - 3, this.getSize().height - 3);
        }
    }

    private Vector breakIntoLines(String string, int n, FontMetrics fontMetrics) {
        String string2 = string;
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        while (n2 != -1) {
            int n4;
            int n5;
            while (n2 < string2.length() && string2.charAt(n2) == ' ' && ++n2 < string2.length()) {
            }
            int n6 = -1;
            String string3 = null;
            for (n3 = n2; n3 >= n2; ++n3) {
                n5 = 0;
                n4 = string2.indexOf(10, n3);
                int n7 = string2.indexOf(32, n3);
                if (n4 != -1 && (n7 == -1 || n7 != -1 && n4 < n7)) {
                    n3 = n4;
                    n5 = 1;
                } else {
                    n3 = n7;
                    n5 = 0;
                }
                string = n3 == -1 ? string2.substring(n2) : string2.substring(n2, n3);
                if (fontMetrics.stringWidth(string) >= n) break;
                string3 = string;
                n6 = n3;
                if (n5 != 0) {
                    ++n6;
                }
                if (n3 == -1 || n5 != 0) break;
            }
            if (string3 == null) {
                n5 = 0;
                n4 = 0;
                for (n3 = n2; n3 < string2.length() && n5 + (n4 = fontMetrics.charWidth(string2.charAt(n3))) < n; ++n3) {
                    n5 += n4;
                }
                vector.addElement(string2.substring(n2, n3));
                n2 = n3;
                continue;
            }
            vector.addElement(string3);
            n2 = n6;
        }
        return vector;
    }

    private void checkAttributes() {
        this.updateFont();
        this.textArea.setEditable(!this.text.getReadOnly());
        this.textArea.setEnabled(!this.text.getDisabled());
        String string = this.text.getValue();
        if (string != null && !string.equals(this.textArea.getText())) {
            this.textArea.setText(string);
            this.textArea.setCaretPosition(string.length());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.text.setValue(this.textArea.getText());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.text.setValue(this.textArea.getText());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.text.setValue(this.textArea.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n;
        int n2 = caretEvent.getDot();
        if (n2 != (n = caretEvent.getMark())) {
            int n3;
            int n4;
            if (n2 < n) {
                n4 = n2;
                n3 = n;
            } else {
                n3 = n2;
                n4 = n;
            }
            this.text.dispatchSelection(n4, n3);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
    }

    void updateFont() {
        CSSAttribs cSSAttribs;
        Font font;
        if (this.textArea == null) {
            return;
        }
        if (this.box != null && !(font = (cSSAttribs = this.box.getCSSAttribs()).getTestedFont(this.text.getValue())).equals(this.getFont())) {
            this.setFont(font);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.textArea != null) {
            this.textArea.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textArea != null) {
            this.textArea.setForeground(color);
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.updateFont();
    }
}

