/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.Vector;

public abstract class Pilot {
    StormBase base;
    Viewport viewport;

    public StormBase getStorm() {
        return this.base;
    }

    public void init(String string) {
        if (Debug.trace) {
            Debug.trace((String)(this.getClass().getName() + " (" + string + ") in " + this.getViewportId()));
        }
    }

    public void dispose() {
    }

    protected void setZoom(int n) {
    }

    public boolean isDetached() {
        return false;
    }

    public void clear(String string) {
    }

    public void parse(ContentLoader contentLoader) throws IOException {
    }

    public void gotoRef(String string) {
    }

    public boolean refExists(String string) {
        return false;
    }

    public void stopLoading() {
    }

    public void modifiedByScript() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void onLowMemory() {
    }

    public Component createComponent() {
        return null;
    }

    public StormPrinter createPrinter() {
        return null;
    }

    public Object getDynamicValueOnWindow(DynamicObject dynamicObject, String string, DynEnv dynEnv) {
        return DynamicObject.NOT_FOUND;
    }

    public int setDynamicValueOnWindow(DynamicObject dynamicObject, String string, Object object, DynEnv dynEnv) {
        return 0;
    }

    public Object execDynamicMethodOnWindow(DynamicObject dynamicObject, String string, Object[] objectArray, DynEnv dynEnv) {
        return DynamicObject.NOT_FOUND;
    }

    public DynamicObject getDocumentObject() {
        return null;
    }

    public void updateFrameList() {
    }

    public Object getSnapshot() {
        return null;
    }

    public void applySnapshot(Object object) {
    }

    public void parsingDone() {
    }

    public void onLoadingDone() {
    }

    public void beforeUnload() {
    }

    public void refresh() {
    }

    public final String getViewportId() {
        return this.viewport.getId();
    }

    public final Viewport getPilotViewport() {
        return this.viewport;
    }

    public DocPane getDocPane() {
        return null;
    }

    public final void getAllPilotInstances(Vector vector) {
        Class<?> clazz = this.getClass();
        this.base.getAllPilotInstances(clazz, vector);
    }

    public final Object getViewportProperty(String string) {
        return this.viewport.getProperty(string);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.base.sendViewportMessage(this.viewport, string, object, object2);
    }

    public final void renderContent(String string, String string2, String string3) {
        Scripter scripter = this.base.getScripterForCodeLocation(string);
        if (scripter != null) {
            Viewport viewport = this.viewport.findViewportInTreeByName(string3);
            if (viewport == null) {
                viewport = this.viewport;
            }
            scripter.evalCodeLocation(viewport, string);
        } else {
            Viewport viewport = this.findOrCreateViewport(string3);
            this.base.renderContent(string, string2, viewport.getId());
        }
    }

    public final Viewport findOrCreateViewport(String string) {
        Viewport viewport = this.viewport.findViewportInTreeByName(string);
        if (viewport == null && (viewport = this.base.newTopLevelViewport(string)) == null) {
            viewport = this.viewport;
        }
        return viewport;
    }

    public final boolean isStopRequested() {
        return this.viewport.isStopRequested();
    }

    public final void refreshViewport() {
        Container container = this.viewport.getContainer();
        if (container != null) {
            container.repaint();
        }
    }

    public final void viewportBecameActive() {
        this.base.setActiveViewport(this.viewport);
    }

    public final Container getViewportContainer() {
        return this.viewport.getContainer();
    }

    public final UrlMaster getUrlMaster() {
        return this.base.getUrlMaster();
    }
}

