/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.fonts.FontPicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class DesktopFontPicker
extends MJPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.resources.RES_DTFontPicker");
    private final MJRadioButton fDesktopRB;
    private final MJRadioButton fCustomRB;
    private final FontPicker fPicker;

    public DesktopFontPicker(boolean bl, Font font) {
        this.setLayout(new BorderLayout(0, 6));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fPicker = new FontPicker(font == null ? FontPrefs.DEFAULT_TEXT_FONT : font, FontPicker.Layout.WIDE_WITH_SAMPLE);
        this.fDesktopRB = new MJRadioButton(BUNDLE.getString("rb.UseDesktopFont"), bl);
        buttonGroup.add((AbstractButton)this.fDesktopRB);
        this.fDesktopRB.setName("DesktopFontRB");
        this.fCustomRB = new MJRadioButton(BUNDLE.getString("rb.UseCustomFont"), !bl);
        buttonGroup.add((AbstractButton)this.fCustomRB);
        this.fCustomRB.setName("CustomFontRB");
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 1, 0, 4, 65536));
        this.add(this.fPicker.getComponent(), "Center");
        mJPanel.add((Component)this.fDesktopRB);
        mJPanel.add((Component)this.fCustomRB);
        this.add((Component)mJPanel, "North");
        Handler handler = new Handler();
        this.fDesktopRB.addItemListener((ItemListener)handler);
        this.fCustomRB.addItemListener((ItemListener)handler);
        this.updateControls();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fDesktopRB.setEnabled(bl);
        this.fCustomRB.setEnabled(bl);
        if (bl) {
            this.updateControls();
        } else {
            this.fPicker.setEnabled(bl);
        }
    }

    public String getUseDesktopFontLabel() {
        return this.fDesktopRB.getText();
    }

    public void setUseDesktopFontLabel(String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        this.fDesktopRB.setText(string);
    }

    public boolean getUseDesktopFont() {
        return this.fDesktopRB.isSelected();
    }

    public Font getSelectedFont() {
        return this.fPicker.getSelectedFont();
    }

    private void updateControls() {
        this.fPicker.setEnabled(!this.fDesktopRB.isSelected());
    }

    private class Handler
    implements ItemListener {
        private Handler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            DesktopFontPicker.this.updateControls();
        }
    }
}

