/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.DesktopFontPicker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TextPrintPanel
extends MJPanel {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");
    public static final int SYNTAX_BW = 4096;
    public static final int SYNTAX_COLOR = 2048;
    public static final int SYNTAX_STYLE = 6144;
    public static final int SYNTAX_OPTIONS_MASK = 6144;
    public static final int SYNTAX_OPTIONS_CLEAR_MASK = 59391;
    public static final int TEXT_FONT = 32768;
    public static final int HEADER_FONT = 16384;
    public static final int FONT_OPTIONS_MASK = 57344;
    private MJCheckBox fPrintHeaderCheckbox;
    private MJCheckBox fPrintLineNumbersCheckbox;
    private MJCheckBox fWrapLinesCheckbox;
    private MJRadioButton[] fSyntaxItems;
    private MJComboBox fBorderChoice;
    private MJComboBox fPageChoice;
    private MJComboBox fLayoutChoice;
    private DesktopFontPicker fTextFontPicker;
    private DesktopFontPicker fHeaderFontPicker;

    public TextPrintPanel(int n, boolean bl, String string, Font[] fontArray, String string2) {
        MJTabbedPane mJTabbedPane = new MJTabbedPane();
        int n2 = 2;
        int n3 = mJTabbedPane.getInsets().top;
        int n4 = mJTabbedPane.getInsets().left;
        mJTabbedPane.setBorder(BorderFactory.createEmptyBorder(n2, n4, n3, n4));
        mJTabbedPane.setName("OptionsTab");
        final MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setName("LayoutPanel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), sRes.getString("sapp.print.groupbox")));
        mJPanel2.setName("PrintGroupbox");
        mJPanel2.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 196608, (Object)Float.valueOf(0.0f), null));
        final PagePreviewCanvas pagePreviewCanvas = new PagePreviewCanvas();
        pagePreviewCanvas.setName("PagePreviewCanvas");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                pagePreviewCanvas.repaint();
            }
        };
        this.fPrintHeaderCheckbox = new MJCheckBox(sRes.getString("sapp.print.header"), (n & 1) != 0);
        this.fPrintHeaderCheckbox.setName("PrintHeader");
        this.fPrintHeaderCheckbox.addActionListener(actionListener);
        mJPanel2.add((Component)this.fPrintHeaderCheckbox);
        this.fPrintLineNumbersCheckbox = new MJCheckBox(sRes.getString("sapp.print.linenumbers"), (n & 4) != 0);
        this.fPrintLineNumbersCheckbox.setName("PrintLineNumbers");
        this.fPrintLineNumbersCheckbox.addActionListener(actionListener);
        mJPanel2.add((Component)this.fPrintLineNumbersCheckbox);
        this.fWrapLinesCheckbox = new MJCheckBox(sRes.getString("sapp.print.wraplines"), (n & 8) != 0);
        this.fWrapLinesCheckbox.setName("WrapLines");
        this.fWrapLinesCheckbox.addActionListener(actionListener);
        mJPanel2.add((Component)this.fWrapLinesCheckbox);
        mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), sRes.getString("sapp.syntax.groupbox")));
        mJPanel3.setName("SyntaxGroupbox");
        mJPanel3.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 196608, (Object)Float.valueOf(0.0f), null));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fSyntaxItems = new MJRadioButton[3];
        int n5 = TextPrintPanel.mapSyntaxOptions(n, false);
        this.fSyntaxItems[0] = new MJRadioButton(sRes.getString("sapp.syntax.bw"), n5 == 0);
        buttonGroup.add((AbstractButton)this.fSyntaxItems[0]);
        this.fSyntaxItems[0].setName("SyntaxBW");
        this.fSyntaxItems[0].addActionListener(actionListener);
        mJPanel3.add((Component)this.fSyntaxItems[0]);
        this.fSyntaxItems[1] = new MJRadioButton(sRes.getString("sapp.syntax.color"), n5 == 1);
        buttonGroup.add((AbstractButton)this.fSyntaxItems[1]);
        this.fSyntaxItems[1].setName("SyntaxColor");
        this.fSyntaxItems[1].addActionListener(actionListener);
        mJPanel3.add((Component)this.fSyntaxItems[1]);
        this.fSyntaxItems[2] = new MJRadioButton(sRes.getString("sapp.syntax.style"), n5 == 2);
        buttonGroup.add((AbstractButton)this.fSyntaxItems[2]);
        this.fSyntaxItems[2].setName("SyntaxStyle");
        this.fSyntaxItems[2].addActionListener(actionListener);
        mJPanel3.add((Component)this.fSyntaxItems[2]);
        gridBagConstraints.gridy = 1;
        mJPanel.add((Component)mJPanel3, (Object)gridBagConstraints);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel4.setName("PagePreviewPanel");
        mJPanel4.setBorder((Border)new EmptyBorder(5, 6, 0, 0));
        mJPanel4.add((Component)((Object)pagePreviewCanvas), (Object)"Center");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        mJPanel.add((Component)mJPanel4, (Object)gridBagConstraints);
        mJTabbedPane.add(sRes.getString("sapp.options"), (Component)mJPanel);
        MJPanel mJPanel5 = new MJPanel();
        MGridLayout mGridLayout = new MGridLayout(0, 1, 4, 4, 131072);
        mJPanel5.setLayout((LayoutManager)mGridLayout);
        mJPanel5.setBorder((Border)new EmptyBorder(5, n4, 0, n4));
        mJPanel5.setName("HeaderPanel");
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new MGridLayout(0, 2, 4, 4, 196608));
        mJPanel6.setBorder((Border)new EmptyBorder(5, 6, 0, 6));
        mJPanel6.setName("HeaderOptionsPanel");
        MJLabel mJLabel = new MJLabel(sRes.getString("sapp.page.label"));
        mJLabel.setName("PageLabel");
        this.fPageChoice = new MJComboBox();
        this.fPageChoice.setName("PageChoice");
        this.fPageChoice.addItem((Object)sRes.getString("sapp.page.pagen"));
        this.fPageChoice.addItem((Object)sRes.getString("sapp.page.nofn"));
        this.fPageChoice.addItem((Object)sRes.getString("sapp.page.novern"));
        this.fPageChoice.setSelectedIndex(TextPrintPanel.mapPageNumberOptions(n, false));
        if (string2 == null) {
            string2 = sRes.getString("sapp.title");
        }
        final HeaderPreviewCanvas headerPreviewCanvas = new HeaderPreviewCanvas(n, string2);
        headerPreviewCanvas.setName("HeaderPreviewCanvas");
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                headerPreviewCanvas.setOptions(TextPrintPanel.this.getValue());
            }
        };
        this.fPageChoice.addActionListener(actionListener2);
        mJPanel6.add((Component)mJLabel);
        mJPanel6.add((Component)this.fPageChoice);
        MJLabel mJLabel2 = new MJLabel(sRes.getString("sapp.border.label"));
        mJLabel2.setName("BorderLabel");
        this.fBorderChoice = new MJComboBox();
        this.fBorderChoice.setName("BorderChoice");
        this.fBorderChoice.addItem((Object)sRes.getString("sapp.border.singleline"));
        this.fBorderChoice.addItem((Object)sRes.getString("sapp.border.doubleline"));
        this.fBorderChoice.addItem((Object)sRes.getString("sapp.border.box"));
        this.fBorderChoice.addItem((Object)sRes.getString("sapp.border.shadedbox"));
        this.fBorderChoice.addItem((Object)sRes.getString("sapp.border.none"));
        this.fBorderChoice.setSelectedIndex(TextPrintPanel.mapBorderOptions(n, false));
        this.fBorderChoice.addActionListener(actionListener2);
        mJPanel6.add((Component)mJLabel2);
        mJPanel6.add((Component)this.fBorderChoice);
        MJLabel mJLabel3 = new MJLabel(sRes.getString("sapp.layout.label"));
        mJLabel3.setName("LayoutLabel");
        this.fLayoutChoice = new MJComboBox();
        this.fLayoutChoice.setName("LayoutChoice");
        this.fLayoutChoice.addItem((Object)sRes.getString("sapp.layout.layout1"));
        this.fLayoutChoice.addItem((Object)sRes.getString("sapp.layout.layout2"));
        this.fLayoutChoice.addItem((Object)sRes.getString("sapp.layout.layout3"));
        if (bl) {
            this.fLayoutChoice.addItem((Object)sRes.getString("sapp.layout.layout4"));
        }
        this.fLayoutChoice.setSelectedIndex(TextPrintPanel.mapLayoutOptions(n, false));
        this.fLayoutChoice.addActionListener(actionListener2);
        mJPanel6.add((Component)mJLabel3);
        mJPanel6.add((Component)this.fLayoutChoice);
        mJPanel5.add((Component)mJPanel6);
        MJPanel mJPanel7 = new MJPanel();
        mJPanel7.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), sRes.getString("sapp.preview.groupbox")));
        mJPanel7.setName("PreviewGroupbox");
        mJPanel7.setLayout((LayoutManager)new BorderLayout());
        mJPanel7.add((Component)((Object)headerPreviewCanvas), (Object)"Center");
        mJPanel5.add((Component)mJPanel7);
        mJTabbedPane.add(sRes.getString("sapp.header"), (Component)mJPanel5);
        final CardLayout cardLayout = new CardLayout();
        final MJPanel mJPanel8 = new MJPanel((LayoutManager)cardLayout);
        mJPanel8.setBorder((Border)new EmptyBorder(0, 6, 5, 6));
        mJPanel8.setName("FontCardPanel");
        MJPanel mJPanel9 = new MJPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return mJPanel.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return mJPanel.getMinimumSize();
            }
        };
        mJPanel9.setName("TextFontPanel");
        mJPanel9.setBorder((Border)new EmptyBorder(n2, n4, 0, n4));
        Insets insets = new Insets(n2, n4, 0, n4);
        MJPanel mJPanel10 = new MJPanel((LayoutManager)new MGridLayout(0, 2, 4, 4, 196608));
        mJPanel10.setBorder((Border)new EmptyBorder(5, 6, 5, 6));
        mJPanel10.setName("FontChoicePanel");
        MJLabel mJLabel4 = new MJLabel(sRes.getString("sapp.chooseFont"));
        mJPanel10.setName("ChooseFontLabel");
        mJPanel10.add((Component)mJLabel4);
        final MJComboBox mJComboBox = new MJComboBox();
        mJComboBox.setName("FontChoice");
        mJComboBox.addItem((Object)sRes.getString("sapp.body"));
        mJComboBox.addItem((Object)sRes.getString("sapp.header"));
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (mJComboBox.getSelectedIndex() == 0) {
                    cardLayout.show((Container)mJPanel8, "TextFont");
                } else if (mJComboBox.getSelectedIndex() == 1) {
                    cardLayout.show((Container)mJPanel8, "HeaderFont");
                }
            }
        });
        mJPanel10.add((Component)mJComboBox);
        mJPanel9.add((Component)mJPanel10, (Object)"North");
        Font font = fontArray == null || fontArray.length < 1 ? null : fontArray[0];
        this.fTextFontPicker = new DesktopFontPicker((n & 0x8000) != 0, font);
        this.fTextFontPicker.setUseDesktopFontLabel(string);
        this.fTextFontPicker.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.fTextFontPicker.setName("TextFont");
        mJPanel8.add("TextFont", (Component)((Object)this.fTextFontPicker));
        cardLayout.show((Container)mJPanel8, "TextFont");
        Font font2 = fontArray == null || fontArray.length < 2 || fontArray[1] == null ? new Font("SansSerif", 1, 10) : fontArray[1];
        this.fHeaderFontPicker = new DesktopFontPicker((n & 0x4000) != 0, font2);
        this.fHeaderFontPicker.setUseDesktopFontLabel(sRes.getString("sapp.usetextfont"));
        this.fHeaderFontPicker.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.fHeaderFontPicker.setName("HeaderFont");
        mJPanel8.add("HeaderFont", (Component)((Object)this.fHeaderFontPicker));
        mJPanel9.add((Component)mJPanel8, (Object)"Center");
        mJTabbedPane.add(sRes.getString("sapp.fonts"), (Component)mJPanel9);
        this.setLayout(new BorderLayout());
        this.add((Component)mJTabbedPane, "Center");
    }

    public int getValue() {
        int n = 0;
        if (this.fPrintHeaderCheckbox.isSelected()) {
            n |= 1;
        }
        if (this.fPrintLineNumbersCheckbox.isSelected()) {
            n |= 4;
        }
        if (this.fWrapLinesCheckbox.isSelected()) {
            n |= 8;
        }
        n |= TextPrintPanel.mapBorderOptions(this.fBorderChoice.getSelectedIndex(), true);
        n |= TextPrintPanel.mapPageNumberOptions(this.fPageChoice.getSelectedIndex(), true);
        n |= TextPrintPanel.mapLayoutOptions(this.fLayoutChoice.getSelectedIndex(), true);
        int n2 = 0;
        while (!this.fSyntaxItems[n2].isSelected()) {
            ++n2;
        }
        n |= TextPrintPanel.mapSyntaxOptions(n2, true);
        n |= this.fTextFontPicker.getUseDesktopFont() ? 32768 : 0;
        return n |= this.fHeaderFontPicker.getUseDesktopFont() ? 16384 : 0;
    }

    public static boolean isStylized(int n) {
        return (n & 0x1800) == 6144;
    }

    public static boolean isColored(int n) {
        return (n & 0x1800) == 2048;
    }

    private static int setColored(int n, boolean bl) {
        int n2 = bl ? 2048 : 4096;
        n &= 0xE7FF;
        return n |= n2;
    }

    public static Chromaticity addChromaticityToPrintAttributeSet(int n, AttributeSet attributeSet) {
        Chromaticity chromaticity = TextPrintPanel.isColored(n) ? Chromaticity.COLOR : Chromaticity.MONOCHROME;
        attributeSet.add(chromaticity);
        return chromaticity;
    }

    public static void updateColorPrintOptionPrefIfNeccessary(String string, Chromaticity chromaticity, Chromaticity chromaticity2, int n) {
        if (!chromaticity.equals(chromaticity2)) {
            boolean bl = chromaticity2.equals(Chromaticity.COLOR);
            n = TextPrintPanel.setColored(n, bl);
            Prefs.setIntegerPref((String)string, (int)n);
        }
    }

    public Font[] getFonts() {
        Font[] fontArray = new Font[]{this.fTextFontPicker.getSelectedFont(), this.fHeaderFontPicker.getSelectedFont()};
        return fontArray;
    }

    private static int mapBorderOptions(int n, boolean bl) {
        int n2 = bl ? (n == 1 ? 0x2000000 : (n == 2 ? 0x3000000 : (n == 3 ? 0x4000000 : (n == 4 ? 0x5000000 : 0x1000000)))) : ((n &= 0xF000000) == 0x2000000 ? 1 : (n == 0x3000000 ? 2 : (n == 0x4000000 ? 3 : (n == 0x5000000 ? 4 : 0))));
        return n2;
    }

    private static int mapPageNumberOptions(int n, boolean bl) {
        int n2 = bl ? (n == 1 ? 0x20000000 : (n == 2 ? 0x30000000 : 0x10000000)) : ((n &= 0xF0000000) == 0x20000000 ? 1 : (n == 0x30000000 ? 2 : 0));
        return n2;
    }

    private static int mapLayoutOptions(int n, boolean bl) {
        int n2 = bl ? (n == 0 ? 0x100000 : (n == 2 ? 0x300000 : (n == 3 ? 0x400000 : 0x200000))) : ((n &= 0xF00000) == 0x100000 ? 0 : (n == 0x300000 ? 2 : (n == 0x400000 ? 3 : 1)));
        return n2;
    }

    private static int mapSyntaxOptions(int n, boolean bl) {
        int n2 = bl ? (n == 1 ? 2048 : (n == 2 ? 6144 : 4096)) : ((n &= 0x1800) == 2048 ? 1 : (n == 6144 ? 2 : 0));
        return n2;
    }

    private class PagePreviewCanvas
    extends MJPanel {
        private static final int PAPER_BORDER = 6;
        private static final int LINE_HEIGHT = 6;
        private int fLineNumber;
        private static final int PAPER_HEIGHT = 176;
        private static final int PAPER_WIDTH = 135;
        private Graphics fOffScreenGraphics;
        private Image fOffScreenImage;

        private PagePreviewCanvas() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.fOffScreenGraphics == null) {
                this.fOffScreenImage = this.createImage(dimension.width, dimension.height);
                if (this.fOffScreenImage == null) {
                    return;
                }
                this.fOffScreenGraphics = this.fOffScreenImage.getGraphics();
            }
            this.fOffScreenGraphics.setColor(this.getBackground());
            this.fOffScreenGraphics.fillRect(0, 0, dimension.width, dimension.height);
            this.imagePaint(this.fOffScreenGraphics);
            graphics.drawImage(this.fOffScreenImage, 0, 0, (ImageObserver)((Object)this));
        }

        private void imagePaint(Graphics graphics) {
            Object object;
            this.fLineNumber = 1;
            boolean bl = TextPrintPanel.this.fPrintHeaderCheckbox.isSelected();
            boolean bl2 = TextPrintPanel.this.fPrintLineNumbersCheckbox.isSelected();
            boolean bl3 = TextPrintPanel.this.fWrapLinesCheckbox.isSelected();
            boolean bl4 = TextPrintPanel.this.fSyntaxItems[1].isSelected();
            boolean bl5 = TextPrintPanel.this.fSyntaxItems[2].isSelected();
            graphics.setColor(Color.black);
            graphics.drawRect(6, 6, 135, 176);
            graphics.fillRect(10, 10, 134, 176);
            graphics.setColor(Color.white);
            graphics.fillRect(7, 7, 134, 175);
            Color color = Color.gray;
            graphics.setColor(color);
            String string = "SansSerif";
            int n = 4;
            graphics.setFont(new Font(string, 0, n));
            int n2 = 18;
            int n3 = 18;
            if (bl) {
                FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                this.writeLine(graphics, "C:/Folder1/Folder2/newfile.m", n3, n2);
                char[] cArray = this.stringToChar("Page 1 of 14");
                this.writeLine(graphics, String.valueOf(cArray), n3 + 135 - 24 - fontMetrics.charsWidth(cArray, 0, cArray.length), n2);
                this.writeLine(graphics, "December 6, 2001", n3, n2 += 6);
                object = this.stringToChar("12:43:36 PM");
                this.writeLine(graphics, String.valueOf((char[])object), n3 + 135 - 24 - fontMetrics.charsWidth((char[])object, 0, ((Object)object).length), n2);
                graphics.drawLine(n3, n2 += 3, n3 + 135 - 24, n2);
                n2 += 7;
            }
            int n4 = 3;
            int n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
            object = Color.blue;
            Color color2 = Color.black;
            if (bl5) {
                graphics.setColor(color2);
                graphics.setFont(new Font(string, 1, n));
            } else if (bl4) {
                graphics.setColor((Color)object);
            }
            n5 = this.writeLine(graphics, "function ", n5, n2);
            graphics.setFont(new Font(string, 0, n));
            graphics.setColor(color);
            this.writeLine(graphics, "x, y = xfunction(varargin)", n5 + 2, n2);
            n2 += 6;
            String[] stringArray = new String[]{"This is the first line of comments.", "There are no real variables, but if", "they would be described here."};
            Color color3 = new Color(0, 175, 0);
            for (int i = 0; i != 3; ++i) {
                n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
                if (bl5) {
                    graphics.setFont(new Font(string, 2, n));
                }
                if (bl4) {
                    graphics.setColor(color3);
                }
                this.writeLine(graphics, stringArray[i], n5, n2);
                n2 += 6;
                graphics.setColor(color);
                graphics.setFont(new Font(string, 0, n));
            }
            this.drawLineNumber(graphics, n4, n3, n2, bl2);
            n2 += 6;
            Color color4 = Color.red;
            while (n2 < 176) {
                n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
                if (bl5) {
                    graphics.setFont(new Font(string, 2, n));
                }
                if (bl4) {
                    graphics.setColor(color3);
                }
                this.writeLine(graphics, "This is some random text to display", n5, n2);
                graphics.setColor(color);
                graphics.setFont(new Font(string, 0, n));
                if ((n2 += 6) > 176) break;
                n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
                if (bl5) {
                    graphics.setColor(color2);
                    graphics.setFont(new Font(string, 1, n));
                } else if (bl4) {
                    graphics.setColor((Color)object);
                }
                n5 = this.writeLine(graphics, "keyw ", n5, n2);
                graphics.setColor(color);
                graphics.setFont(new Font(string, 0, n));
                this.writeLine(graphics, "x ~= 34", n5, n2);
                if ((n2 += 6) > 176) break;
                n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
                n5 += 8;
                n5 = this.writeLine(graphics, "error(", n5, n2);
                if (bl4) {
                    graphics.setColor(color4);
                }
                n5 = this.writeLine(graphics, "'A highlighted string of text'", n5, n2);
                graphics.setColor(color);
                this.writeLine(graphics, ");", n5, n2);
                if ((n2 += 6) > 176) break;
                int n6 = n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
                n5 += 8;
                String string2 = "Bl x ";
                char[] cArray = string2.toCharArray();
                FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                if (bl3) {
                    while (n5 < n3 + 135 - 24 - fontMetrics.charsWidth(cArray, 0, cArray.length)) {
                        n5 = this.writeLine(graphics, string2, n5, n2);
                    }
                    graphics.drawLine(n5 + 4, n2 - 2, n5 + 2, n2);
                    if ((n2 += 6) > 176) break;
                    n5 = this.writeLine(graphics, string2, n6, n2);
                    for (int i = 0; i != 4 && (i != 3 || bl2); ++i) {
                        n5 = this.writeLine(graphics, string2, n5, n2);
                    }
                    n2 += 6;
                } else {
                    while (n5 < n3 + 135 - 12 - fontMetrics.charsWidth(cArray, 0, cArray.length)) {
                        n5 = this.writeLine(graphics, string2, n5, n2);
                    }
                    n2 += 6;
                }
                if (n2 > 176) break;
                n5 = this.drawLineNumber(graphics, n4, n3, n2, bl2);
                if (bl5) {
                    graphics.setColor(color2);
                    graphics.setFont(new Font(string, 1, n));
                } else if (bl4) {
                    graphics.setColor((Color)object);
                }
                this.writeLine(graphics, "Keyword", n5, n2);
                graphics.setColor(color);
                graphics.setFont(new Font(string, 0, n));
                if ((n2 += 6) > 176) break;
                this.drawLineNumber(graphics, n4, n3, n2, bl2);
                n2 += 6;
            }
        }

        private int drawLineNumber(Graphics graphics, int n, int n2, int n3, boolean bl) {
            if (bl) {
                String string = String.valueOf(this.fLineNumber++);
                if (this.fLineNumber <= 10) {
                    string = "  " + string;
                }
                return this.writeLine(graphics, string, n2, n3) + n;
            }
            return n2;
        }

        private int writeLine(Graphics graphics, String string, int n, int n2) {
            char[] cArray = this.stringToChar(string);
            graphics.drawChars(this.stringToChar(string), 0, cArray.length, n, n2);
            return graphics.getFontMetrics(graphics.getFont()).charsWidth(cArray, 0, cArray.length) + n;
        }

        private char[] stringToChar(String string) {
            return string.toCharArray();
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(147, 188);
        }
    }

    private static class HeaderPreviewCanvas
    extends MJPanel {
        private static final int INSET = 1;
        private static final int MARGIN = 4;
        private static final int BOX_HMARGIN = 3;
        private static final int FONT_SIZE = 12;
        private int fOptions;
        private String fTitle;
        private String fDate;
        private String fShortDate;
        private String fTime;
        private String fShortTime;
        private String fPage;
        private String fLongPage;
        private String fPath;
        private String fFile;
        private int fBaseline;
        private int fHeight;
        private int fMaxTitle = 0;
        private int fRightWidth;
        private int fRightSecondLineWidth;
        private String fLeft;
        private String fRight;
        private String fLeftSecondLine;
        private String fRightSecondLine;
        private Color fBoxColor;

        HeaderPreviewCanvas(int n, String string) {
            if (string == null) {
                this.fPath = sRes.getString("sapp.path");
                this.fFile = sRes.getString("sapp.filename");
                this.fTitle = this.fPath + System.getProperty("file.separator") + this.fFile;
            } else {
                this.fTitle = string;
                int n2 = string.lastIndexOf("/");
                if (n2 == -1) {
                    n2 = string.lastIndexOf("\\");
                }
                if (n2 != -1) {
                    this.fPath = string.substring(0, n2 + 1);
                    this.fFile = string.substring(n2 + 1);
                } else {
                    this.fPath = sRes.getString("sapp.path");
                    this.fFile = sRes.getString("sapp.filename");
                }
            }
            this.setOptions(n);
            this.setFont(new Font("SansSerif", 1, 12));
        }

        public void setEnabled(boolean bl) {
            if (bl != this.isEnabled()) {
                super.setEnabled(bl);
                this.repaint();
            }
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.cacheDimensions();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        public Dimension getMaximumSize() {
            int n = this.fMaxTitle + 16;
            int n2 = this.fHeight * 2 + 10 + 4;
            return new Dimension(n, n2);
        }

        private void cacheDimensions() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.fBaseline = fontMetrics.getMaxAscent() + fontMetrics.getLeading();
            if (fontMetrics.getMaxAscent() < 12) {
                this.fBaseline += 12 - fontMetrics.getMaxAscent();
            }
            if (fontMetrics.getLeading() == 0) {
                ++this.fBaseline;
            }
            this.fHeight = this.fBaseline + fontMetrics.getMaxDescent();
            String string = this.fShortDate + " " + this.fShortTime + "  " + this.fTitle + "   " + this.fLongPage;
            this.fMaxTitle = fontMetrics.stringWidth(string);
            if (this.fRight != null) {
                this.fRightWidth = fontMetrics.stringWidth(this.fRight);
            }
            if (this.fRightSecondLine != null) {
                this.fRightSecondLineWidth = fontMetrics.stringWidth(this.fRightSecondLine);
            }
        }

        public void setOptions(int n) {
            DateFormat dateFormat;
            Date date = new Date();
            if ((n & 0xF00000) != 0x300000) {
                dateFormat = (n & 0xF00000) == 0x100000 ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(1);
                dateFormat.setTimeZone(TimeZone.getDefault());
                this.fDate = dateFormat.format(date);
            }
            this.fShortDate = DateFormat.getDateInstance(3).format(date);
            if ((n & 0xF00000) == 0x100000 || (n & 0xF00000) == 0x200000) {
                dateFormat = (n & 0xF00000) == 0x100000 ? DateFormat.getTimeInstance(3) : DateFormat.getTimeInstance(2);
                dateFormat.setTimeZone(TimeZone.getDefault());
                this.fTime = dateFormat.format(date);
            }
            this.fShortTime = DateFormat.getTimeInstance(3).format(date);
            if ((n & 0xF000000) == 0x4000000 && this.fBoxColor == null) {
                this.fBoxColor = new Color(226, 226, 226);
            }
            if ((n & 0xF0000000) != (this.fOptions & 0xF0000000)) {
                switch (n & 0xF0000000) {
                    case 0x10000000: {
                        this.fPage = sRes.getString("sapp.page.pagenActual");
                        break;
                    }
                    case 0x20000000: {
                        this.fPage = sRes.getString("sapp.page.nofnActual");
                        break;
                    }
                    case 0x30000000: {
                        this.fPage = sRes.getString("sapp.page.novernActual");
                    }
                }
            }
            if (this.fLongPage == null) {
                this.fLongPage = sRes.getString("sapp.page.pagenActual");
            }
            if (this.fPage == null) {
                this.fPage = sRes.getString("sapp.page.pagenActual");
            }
            this.fRight = this.fPage;
            switch (n & 0xF00000) {
                case 0x100000: {
                    this.fLeft = this.fDate + " " + this.fTime + "   " + this.fTitle;
                    this.fLeftSecondLine = null;
                    this.fRightSecondLine = null;
                    break;
                }
                case 0x200000: {
                    this.fLeft = this.fTitle;
                    this.fLeftSecondLine = this.fDate;
                    this.fRightSecondLine = this.fTime;
                    break;
                }
                case 0x300000: {
                    this.fLeft = this.fTitle;
                    this.fLeftSecondLine = null;
                    this.fRightSecondLine = null;
                    break;
                }
                case 0x400000: {
                    this.fLeft = this.fFile;
                    this.fLeftSecondLine = this.fPath;
                    this.fRightSecondLine = this.fDate;
                }
            }
            if (this.fHeight > 0) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                if (this.fRight != null) {
                    this.fRightWidth = fontMetrics.stringWidth(this.fRight);
                }
                if (this.fRightSecondLine != null) {
                    this.fRightSecondLineWidth = fontMetrics.stringWidth(this.fRightSecondLine);
                }
                this.repaint();
            }
            this.fOptions = n;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = this.fOptions & 0xF00000;
            int n2 = 1;
            int n3 = n2 + this.fHeight + 2;
            if (n == 0x200000 || n == 0x400000) {
                n3 += this.fHeight;
            }
            graphics.setColor(Color.white);
            graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            if (this.isEnabled()) {
                graphics.setColor(Color.black);
            }
            int n4 = this.fOptions & 0xF000000;
            int n5 = 5;
            if (n4 == 0x3000000 || n4 == 0x4000000) {
                graphics.drawRect(n5, n2 += 4, dimension.width - n5 - n5, n3);
                if (n4 == 0x4000000 && this.isEnabled()) {
                    graphics.setColor(this.fBoxColor);
                    graphics.fillRect(n5 + 1, n2 + 1, dimension.width - n5 - n5 - 1, n3 - 1);
                    graphics.setColor(Color.black);
                }
                n5 += 3;
            } else if (n4 == 0x2000000) {
                graphics.drawLine(n5, n3, dimension.width - n5, n3);
                graphics.drawLine(n5, n3 + 2, dimension.width - n5, n3 + 2);
            } else if (n4 == 0x1000000) {
                graphics.drawLine(n5, n3, dimension.width - n5, n3);
                graphics.drawLine(n5, n3 + 1, dimension.width - n5, n3 + 1);
            }
            if (this.fLeft != null) {
                graphics.drawString(this.fLeft, n5, this.fBaseline + n2);
            }
            if (this.fRight != null) {
                graphics.drawString(this.fRight, dimension.width - this.fRightWidth - n5, this.fBaseline + n2);
            }
            if (this.fLeftSecondLine != null) {
                graphics.drawString(this.fLeftSecondLine, n5, this.fBaseline + this.fHeight + n2);
            }
            if (this.fRightSecondLine != null) {
                graphics.drawString(this.fRightSecondLine, dimension.width - this.fRightSecondLineWidth - n5, this.fBaseline + this.fHeight + n2);
            }
        }
    }
}

