/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;

public class DTComponentMover
extends MouseInputAdapter
implements ActionListener {
    Component fComponentToMove;
    Point fInitialLocation;
    Point fDragStartPoint;
    Point fDragPoint;
    Point fSmoothedPoint;
    Timer fTimer;
    EventCoalesceTimer fEventCoalesceTimer;
    private boolean fConstrainToParentBounds = true;
    private long fMoveTime = 0L;
    private static int COALESCE_TIME = 30;

    DTComponentMover() {
    }

    public DTComponentMover(Component component) {
        this.fComponentToMove = component;
    }

    protected Component getComponentToMove() {
        return this.fComponentToMove;
    }

    public void setConstrainToParentBounds(boolean bl) {
        this.fConstrainToParentBounds = bl;
    }

    public boolean constrainToParentBounds() {
        return this.fConstrainToParentBounds;
    }

    protected boolean performSmoothing() {
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent)) {
            return;
        }
        this.fComponentToMove = this.getComponentToMove();
        this.fInitialLocation = this.fComponentToMove.getLocation();
        this.fDragStartPoint = mouseEvent.getPoint();
        Component component = this.getParent();
        this.convertToParentBounds(mouseEvent.getComponent(), this.fDragStartPoint, component);
        this.fDragPoint = new Point(this.fDragStartPoint);
        if (this.performSmoothing()) {
            this.fSmoothedPoint = new Point(this.fDragStartPoint);
            this.fTimer = new Timer(50, this);
            this.fTimer.start();
        } else {
            this.fEventCoalesceTimer = new EventCoalesceTimer();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupSuccesor((MouseEvent)mouseEvent)) {
            return;
        }
        this.fInitialLocation = null;
        this.fDragStartPoint = null;
        this.fDragPoint = null;
        if (this.fTimer != null) {
            this.fTimer.stop();
            this.fTimer = null;
            this.fSmoothedPoint = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fDragPoint == null) {
            return;
        }
        this.fDragPoint.x = mouseEvent.getX();
        this.fDragPoint.y = mouseEvent.getY();
        Component component = this.getParent();
        this.convertToParentBounds(mouseEvent.getComponent(), this.fDragPoint, component);
        if (this.fConstrainToParentBounds) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = component == null ? WindowUtils.getVirtualScreenBounds() : new Rectangle(0, 0, component.getWidth(), component.getHeight());
            if (this.fDragPoint.x < rectangle.x) {
                this.fDragPoint.x = rectangle.x;
            } else if (this.fDragPoint.x >= rectangle.x + rectangle.width) {
                this.fDragPoint.x = rectangle.x + rectangle.width - 1;
            }
            if (this.fDragPoint.y < rectangle.y) {
                this.fDragPoint.y = rectangle.y;
            } else if (this.fDragPoint.y >= rectangle.y + rectangle.height) {
                this.fDragPoint.y = rectangle.y + rectangle.height - 1;
            }
        }
        if (this.fSmoothedPoint == null) {
            if (this.fEventCoalesceTimer != null) {
                this.fEventCoalesceTimer.handleDrag(mouseEvent.getWhen());
            }
        } else {
            this.fSmoothedPoint.x = this.smooth(this.fSmoothedPoint.x, this.fDragPoint.x);
            this.fSmoothedPoint.y = this.smooth(this.fSmoothedPoint.y, this.fDragPoint.y);
            this.moveComponent(this.fSmoothedPoint);
            this.fTimer.restart();
        }
    }

    protected void dragComponent() {
        if (this.fDragPoint != null) {
            this.moveComponent(this.fDragPoint);
        }
    }

    protected void moveComponent(Point point) {
        int n = this.fInitialLocation.x + point.x - this.fDragStartPoint.x;
        int n2 = this.fInitialLocation.y + point.y - this.fDragStartPoint.y;
        this.fComponentToMove.setLocation(n, n2);
        this.fMoveTime = System.currentTimeMillis();
    }

    int smooth(int n, int n2) {
        return 3 * n + n2 >> 2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fDragPoint.x != this.fSmoothedPoint.x || this.fDragPoint.y != this.fSmoothedPoint.y) {
            this.fSmoothedPoint.x = this.fDragPoint.x;
            this.fSmoothedPoint.y = this.fDragPoint.y;
            this.moveComponent(this.fSmoothedPoint);
        }
    }

    private Component getParent() {
        return this.fComponentToMove instanceof Window ? null : this.fComponentToMove.getParent();
    }

    private void convertToParentBounds(Component component, Point point, Component component2) {
        if (component2 == null) {
            SwingUtilities.convertPointToScreen(point, component);
        } else {
            Point point2 = SwingUtilities.convertPoint(component, point, component2);
            point.x = point2.x;
            point.y = point2.y;
        }
    }

    private class EventCoalesceTimer
    extends Timer {
        EventCoalesceTimer() {
            super(COALESCE_TIME, null);
            this.setRepeats(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DTComponentMover.this.dragComponent();
                }
            });
        }

        public void handleDrag(long l) {
            if (l - DTComponentMover.this.fMoveTime < (long)COALESCE_TIME) {
                this.restart();
            } else {
                this.stop();
                DTComponentMover.this.dragComponent();
            }
        }
    }
}

