/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.desk.Desktop;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class DTLayoutLibrary {
    protected List<FactoryLayout> fFactoryLayouts;
    protected List<String> fUserLayouts;
    protected String fFilenameEnding;
    private List<Listener> fListeners = new ArrayList<Listener>();
    private FactoryLayout fTargetLayout = new FactoryLayout();

    DTLayoutLibrary(Desktop desktop) {
        String[] stringArray = null;
        this.fFilenameEnding = desktop.getDesktopName() + "Layout.xml";
        final int n = this.fFilenameEnding.length();
        String string = FileUtils.getPreferencesDirectory();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(DTLayoutLibrary.this.fFilenameEnding) && string.length() > n;
            }
        };
        if (string != null) {
            stringArray = new File(string).list(filenameFilter);
        }
        if (stringArray == null) {
            desktop.getErrorReportingStream().println(desktop.getString("error.FailureReadingLayouts"));
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - n);
                this.addUserLayout(stringArray[i]);
            }
        }
    }

    void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    final int layoutCount() {
        return this.factoryLayoutCount() + this.userLayoutCount();
    }

    final boolean isFactoryLayout(int n) {
        return n >= 0 && n < this.factoryLayoutCount();
    }

    final boolean isUserLayout(int n) {
        int n2 = this.factoryLayoutCount();
        return n >= n2 && n - n2 < this.userLayoutCount();
    }

    String getLayoutDisplayName(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = this.factoryLayoutCount();
        if (n < n2) {
            return this.fFactoryLayouts.get((int)n).fDisplayName;
        }
        if ((n -= n2) < this.userLayoutCount()) {
            return this.fUserLayouts.get(n);
        }
        return null;
    }

    String getLayoutReferenceName(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = this.factoryLayoutCount();
        if (n < n2) {
            return this.fFactoryLayouts.get((int)n).fReferenceName;
        }
        if ((n -= n2) < this.userLayoutCount()) {
            return this.fUserLayouts.get(n);
        }
        return null;
    }

    URL getLayoutURL(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = this.factoryLayoutCount();
        if (n < n2) {
            return this.fFactoryLayouts.get((int)n).fURL;
        }
        if ((n -= n2) < this.userLayoutCount()) {
            String string = this.fUserLayouts.get(n);
            File file = this.getUserFile(string);
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    int indexOf(String string) {
        int n = -1;
        int n2 = 0;
        if (this.fFactoryLayouts != null) {
            this.fTargetLayout.fDisplayName = string;
            n = this.fFactoryLayouts.indexOf(this.fTargetLayout);
            n2 = this.fFactoryLayouts.size();
        }
        if (n == -1 && this.fUserLayouts != null && (n = this.fUserLayouts.indexOf(string)) != -1) {
            n += n2;
        }
        return n;
    }

    public void addFactoryLayout(String string, String string2, URL uRL) {
        this.addFactoryLayout(string, string2, uRL, null);
    }

    public void addFactoryLayout(String string, String string2, URL uRL, Icon icon) {
        if (this.fFactoryLayouts == null) {
            this.fFactoryLayouts = new ArrayList<FactoryLayout>();
        }
        this.fFactoryLayouts.add(new FactoryLayout(string, string2, uRL, icon));
    }

    public void addFactoryLayout(String string, URL uRL) {
        this.addFactoryLayout(string, string, uRL);
    }

    final int factoryLayoutCount() {
        return this.fFactoryLayouts == null ? 0 : this.fFactoryLayouts.size();
    }

    String getFactoryLayoutDisplayName(int n) {
        if (n < 0 || n >= this.factoryLayoutCount()) {
            return null;
        }
        return this.fFactoryLayouts.get((int)n).fDisplayName;
    }

    String getFactoryLayoutReferenceName(int n) {
        if (n < 0 || n >= this.factoryLayoutCount()) {
            return null;
        }
        return this.fFactoryLayouts.get((int)n).fReferenceName;
    }

    URL getFactoryLayoutURL(int n) {
        if (n < 0 || n >= this.factoryLayoutCount()) {
            return null;
        }
        return this.fFactoryLayouts.get((int)n).fURL;
    }

    Icon getFactoryLayoutIcon(int n) {
        if (n < 0 || n >= this.factoryLayoutCount()) {
            return null;
        }
        return this.fFactoryLayouts.get((int)n).fIcon;
    }

    void addUserLayout(String string) {
        int n;
        if (this.fUserLayouts == null) {
            this.fUserLayouts = new ArrayList<String>();
        }
        if ((n = this.fUserLayouts.indexOf(string)) != -1) {
            this.fUserLayouts.remove(n);
        }
        this.fUserLayouts.add(string);
        for (Listener listener : this.fListeners) {
            listener.userLayoutAdded(string);
        }
    }

    void removeUserLayout(String string) {
        if (this.fUserLayouts != null) {
            this.fUserLayouts.remove(string);
            File file = this.getUserFile(string);
            if (file.exists()) {
                file.delete();
            }
            for (Listener listener : this.fListeners) {
                listener.userLayoutRemoved(string);
            }
        }
    }

    boolean renameUserLayout(int n, String string) {
        File file;
        String string2;
        File file2;
        boolean bl;
        if (this.fUserLayouts != null && (bl = (file2 = this.getUserFile(string2 = this.getUserLayoutName(n))).renameTo(file = this.getUserFile(string)))) {
            this.fUserLayouts.remove(n);
            this.fUserLayouts.add(n, string);
            for (Listener listener : this.fListeners) {
                listener.userLayoutRenamed(string2, string);
            }
            return true;
        }
        return false;
    }

    final int userLayoutCount() {
        return this.fUserLayouts == null ? 0 : this.fUserLayouts.size();
    }

    String getUserLayoutName(int n) {
        return n < 0 || n >= this.userLayoutCount() ? null : this.fUserLayouts.get(n);
    }

    boolean hasUserLayoutName(String string) {
        if (this.fUserLayouts == null) {
            return false;
        }
        boolean bl = false;
        int n = this.fUserLayouts.size();
        for (int i = 0; i < n && !bl; ++i) {
            bl = string.equalsIgnoreCase(this.fUserLayouts.get(i));
        }
        return bl;
    }

    File getUserFile(String string) {
        return new File(FileUtils.getPreferencesDirectory() + System.getProperty("file.separator") + string + this.fFilenameEnding);
    }

    class FactoryLayout {
        String fDisplayName;
        String fReferenceName;
        URL fURL;
        Icon fIcon;

        FactoryLayout(String string, String string2, URL uRL, Icon icon) {
            this.fDisplayName = string;
            this.fReferenceName = string2;
            this.fURL = uRL;
            this.fIcon = icon;
        }

        FactoryLayout() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof FactoryLayout)) {
                return false;
            }
            FactoryLayout factoryLayout = (FactoryLayout)object;
            if (factoryLayout.fDisplayName == this.fDisplayName) {
                return true;
            }
            if (this.fDisplayName == null || factoryLayout.fDisplayName == null) {
                return false;
            }
            return MJUtilities.exciseAmpersand((String)this.fDisplayName).equals(MJUtilities.exciseAmpersand((String)factoryLayout.fDisplayName));
        }

        public int hashCode() {
            return this.fDisplayName == null ? 0 : this.fDisplayName.hashCode();
        }
    }

    static interface Listener {
        public void userLayoutAdded(String var1);

        public void userLayoutRemoved(String var1);

        public void userLayoutRenamed(String var1, String var2);
    }
}

