/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLayoutMenu;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTNotifyingList;
import com.mathworks.widgets.desk.DTOpenMenu;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowRegistry;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.TargetedAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class DTWindowMenu
extends DTMenu {
    protected Desktop fDesktop;
    protected DTFrame fFrame;
    protected DTDocumentContainer fDocumentContainer;
    private boolean fShowMnemonics;
    private String fFilteringGroupName;
    protected Component fSingletonSeparator;
    protected Component fGroupSeparator;
    protected int fBaseItemCount;
    protected int fFirstSingletonIndex;
    protected int fSingletonCount;
    protected int fShowingSingletonCount;
    protected int fGroupCount;
    protected int fShowingGroupCount;
    protected Action fCloseAllDocumentsAction;
    private DTNotifyingList.Listener<DTClient> fSingletonListListener = new SingletonListListener();
    private DTNotifyingList.Listener<DTGroup> fGroupListListener = new GroupListListener();
    private static final int SINGLETON = 1;
    private static final int GROUP = 2;

    public DTWindowMenu(Desktop desktop, DTFrame dTFrame) {
        this(desktop, dTFrame, true, !PlatformInfo.isMacintosh(), null);
    }

    public DTWindowMenu(Desktop desktop, DTFrame dTFrame, boolean bl, boolean bl2, String string) {
        super(desktop.getString("menu.Window"), true);
        this.setName("DesktopWindowMenu");
        DTMenuMergeTag.WINDOW.setTag((JMenuItem)((Object)this));
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fShowMnemonics = bl2;
        this.fFilteringGroupName = string;
        if (desktop.canHaveMainFrame() && !desktop.useToolstrip()) {
            this.fCloseAllDocumentsAction = new CloseAllDocumentsAction();
            this.add(this.fCloseAllDocumentsAction);
            this.fBaseItemCount = 1;
            this.fFirstSingletonIndex = 1;
        }
        if (this.fDesktop.useToolstrip() && dTFrame.isMainFrame()) {
            this.add((JMenuItem)((Object)new DTLayoutMenu(desktop, dTFrame)));
            ++this.fBaseItemCount;
            ++this.fFirstSingletonIndex;
            if (bl) {
                this.add((JMenuItem)((Object)new DTOpenMenu(desktop)));
                ++this.fBaseItemCount;
                ++this.fFirstSingletonIndex;
            }
        }
        this.addNavigationActions();
        this.addSingletons();
        this.fDesktop.getSingletons().addListener(this.fSingletonListListener);
        this.addGroups();
        this.fDesktop.getNotifyingGroups().addListener(this.fGroupListListener);
    }

    private void addSingletons() {
        if (this.fBaseItemCount > 0) {
            this.addSeparator();
            this.fSingletonSeparator = this.getMenuComponent(this.getMenuComponentCount() - 1);
            ++this.fFirstSingletonIndex;
        }
        DTNotifyingList<DTClient> dTNotifyingList = this.fDesktop.getSingletons();
        Object object = null;
        int n = dTNotifyingList.size();
        for (int i = 0; i < n; ++i) {
            DTClient dTClient = (DTClient)dTNotifyingList.get(i);
            object = new VanishingMenuItem(1, (Action)dTClient.getSelectAction());
            ++this.fSingletonCount;
            if (((Component)object).isEnabled()) {
                ++this.fShowingSingletonCount;
            }
            this.add((JMenuItem)object);
        }
        if (object != null) {
            ((JComponent)object).putClientProperty("MenuMergeTagKey", DTMenuMergeTag.LAST_SINGLETON);
        }
        this.updateSingletonSeparator();
    }

    private void addGroups() {
        List<DTGroup> list = this.fDesktop.getGroups();
        this.addSeparator();
        this.fGroupSeparator = this.getMenuComponent(this.getMenuComponentCount() - 1);
        Object object = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DTGroup dTGroup = list.get(i);
            object = new VanishingMenuItem(2, (Action)dTGroup.getSelectAction());
            ++this.fGroupCount;
            if (((Component)object).isEnabled()) {
                ++this.fShowingGroupCount;
            }
            this.add((JMenuItem)object);
        }
        if (object != null) {
            ((JComponent)object).putClientProperty("MenuMergeTagKey", DTMenuMergeTag.LAST_GROUP);
        }
        this.updateGroupSeparator();
    }

    private void addNavigationActions() {
        if (this.fFrame instanceof DTMultipleClientFrame) {
            DTMultipleClientFrame dTMultipleClientFrame = (DTMultipleClientFrame)this.fFrame;
            if (this.fDesktop.useToolstrip() && dTMultipleClientFrame.isMainFrame()) {
                MJMenu mJMenu = new MJMenu("Navigation");
                mJMenu.add(dTMultipleClientFrame.getNextToolAction());
                mJMenu.add(dTMultipleClientFrame.getPrevToolAction());
                mJMenu.add(dTMultipleClientFrame.getNextTabAction());
                mJMenu.add(dTMultipleClientFrame.getPrevTabAction());
                this.add((JMenuItem)mJMenu);
                ++this.fFirstSingletonIndex;
                ++this.fBaseItemCount;
            } else if (this.fDesktop.isWindowNavigationMenuEnabled()) {
                this.addSeparator();
                this.add(dTMultipleClientFrame.getNextToolAction());
                this.add(dTMultipleClientFrame.getPrevToolAction());
                this.add(dTMultipleClientFrame.getNextTabAction());
                this.add(dTMultipleClientFrame.getPrevTabAction());
                this.fFirstSingletonIndex += 5;
                this.fBaseItemCount += 5;
            }
        }
    }

    void setDocumentContainer(DTDocumentContainer dTDocumentContainer) {
        Action action;
        Object object;
        if (this.fDocumentContainer == dTDocumentContainer) {
            return;
        }
        if (this.fDocumentContainer != null) {
            while (this.fFirstSingletonIndex > this.fBaseItemCount + 1) {
                object = this.getMenuComponent(0);
                this.remove(0);
                if (object instanceof JMenuItem) {
                    action = ((JMenuItem)object).getAction();
                    if (action instanceof ChildAction) {
                        ((ChildAction)action).setParent(null);
                    }
                    MJUtilities.dispose((AbstractButton)((AbstractButton)object));
                }
                --this.fFirstSingletonIndex;
            }
            if (this.fDocumentContainer.getGroup() == null && this.fFrame.isMainFrame()) {
                this.remove(this.fFirstSingletonIndex + this.fSingletonCount);
            }
        }
        this.fDocumentContainer = dTDocumentContainer;
        if (this.fDocumentContainer != null) {
            object = this.fDocumentContainer.getGroup();
            action = dTDocumentContainer.getCloseAllAction();
            if (!action.isEnabled() || !(action instanceof TargetedAction) || ((TargetedAction)((Object)action)).hasAnyTargets()) {
                this.insert(action, 0);
                ++this.fFirstSingletonIndex;
            }
            if (this.fFrame.isMainFrame() && this.fDesktop.getDocumentContainment() == 1) {
                this.insert((Action)((DTMultipleClientFrame)this.fFrame).getSharedDocuments().getUndockAction(), 0);
                ++this.fFirstSingletonIndex;
            }
            if (object == null || ((DTGroup)object).permitUserFloat()) {
                this.insert(dTDocumentContainer.getMinimizeAllAction(), 0);
                this.insert(dTDocumentContainer.getCascadeAction(), 0);
                this.fFirstSingletonIndex += 2;
            }
            this.fFirstSingletonIndex += this.populateDocumentArrangementSection();
            if (dTDocumentContainer.getGroup() == null && this.fFrame.isMainFrame()) {
                this.insert((Action)((DTMultipleClientFrame)this.fFrame).getSharedDocuments().getSelectAction(), this.fFirstSingletonIndex + this.fSingletonCount);
            }
        }
        this.updateSingletonSeparator();
    }

    int populateDocumentArrangementSection() {
        return DTWindowMenu.populateDocumentArrangementSection(this.fDocumentContainer, (JMenu)((Object)this));
    }

    static int populateDocumentArrangementSection(DTDocumentContainer dTDocumentContainer, JMenu jMenu) {
        int n = 0;
        DTGroup dTGroup = dTDocumentContainer.getGroup();
        if (dTGroup == null || dTGroup.permitUserTile() || dTGroup.permitUserFloat()) {
            jMenu.insertSeparator(0);
            jMenu.insert((JMenuItem)new MJCheckBoxMenuItem((Action)dTDocumentContainer.getMaximizeAction()), 0);
            n += 2;
        }
        if (dTGroup == null || dTGroup.permitUserFloat()) {
            jMenu.insert((JMenuItem)new MJCheckBoxMenuItem((Action)dTDocumentContainer.getFloatAction()), 0);
            ++n;
        }
        if (dTGroup == null || dTGroup.permitUserTile()) {
            jMenu.insert((JMenuItem)new MJCheckBoxMenuItem((Action)dTDocumentContainer.getSplitNorthSouthAction()), 0);
            jMenu.insert((JMenuItem)new MJCheckBoxMenuItem((Action)dTDocumentContainer.getSplitEastWestAction()), 0);
            ChildAction childAction = new ChildAction(dTDocumentContainer.getTileSelectAction()){

                public void actionPerformed(ActionEvent actionEvent) {
                    super.actionPerformed(actionEvent);
                    ((AbstractButton)actionEvent.getSource()).getModel().setSelected(false);
                }
            };
            jMenu.insert((JMenuItem)new MJCheckBoxMenuItem((Action)childAction), 0);
            n += 3;
            if (!DTUtilities.usingMacScreenMenus()) {
                jMenu.insert(dTDocumentContainer.createTileMenu(), 0);
                ++n;
            }
        }
        return n;
    }

    private void updateSingletonSeparator() {
        boolean bl;
        boolean bl2 = bl = this.fShowingSingletonCount > 0 || this.fDocumentContainer != null && this.fFrame.isMainFrame() && this.fDesktop.getDocumentContainment() == 1;
        if (!PlatformInfo.isMacintosh()) {
            if (this.fSingletonSeparator != null) {
                this.fSingletonSeparator.setVisible(bl);
            }
        } else if (bl && this.fSingletonSeparator == null) {
            int n = this.fFirstSingletonIndex++;
            this.insertSeparator(n);
            this.fSingletonSeparator = this.getMenuComponent(n);
        } else if (!bl && this.fSingletonSeparator != null) {
            this.remove(this.fSingletonSeparator);
            this.fSingletonSeparator = null;
            --this.fFirstSingletonIndex;
        }
    }

    private void updateGroupSeparator() {
        boolean bl;
        boolean bl2 = bl = this.fShowingGroupCount > 0;
        if (!PlatformInfo.isMacintosh()) {
            if (this.fGroupSeparator != null) {
                this.fGroupSeparator.setVisible(bl);
            }
        } else if (bl && this.fGroupSeparator == null) {
            int n = this.fFirstSingletonIndex + this.fSingletonCount;
            if (n > this.getMenuComponentCount()) {
                n = this.getMenuComponentCount();
            }
            this.insertSeparator(n);
            this.fGroupSeparator = this.getMenuComponent(n);
        } else if (!bl && this.fGroupSeparator != null) {
            this.remove(this.fGroupSeparator);
            this.fGroupSeparator = null;
        }
    }

    private void updateLastSingletonTag() {
        int n = this.fFirstSingletonIndex + this.fSingletonCount - 1;
        for (int i = this.fFirstSingletonIndex; i < n; ++i) {
            ((JComponent)this.getMenuComponent(i)).putClientProperty("MenuMergeTagKey", null);
        }
        if (this.fSingletonCount > 0) {
            ((JComponent)this.getMenuComponent(n)).putClientProperty("MenuMergeTagKey", DTMenuMergeTag.LAST_SINGLETON);
        }
    }

    private void updateLastGroupTag() {
        int n = this.getFirstGroupIndex();
        int n2 = n + this.fGroupCount - 1;
        for (int i = n; i < n2; ++i) {
            ((JComponent)this.getMenuComponent(i)).putClientProperty("MenuMergeTagKey", null);
        }
        if (this.fGroupCount > 0) {
            ((JComponent)this.getMenuComponent(n2)).putClientProperty("MenuMergeTagKey", DTMenuMergeTag.LAST_GROUP);
        }
    }

    private void updateLastDocumentTag() {
        boolean bl = false;
        for (int i = this.getMenuComponentCount() - 1; i >= 0; --i) {
            Action action;
            Component component = this.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || (action = ((JMenuItem)component).getAction()) == null) continue;
            if (!(action instanceof DTWindowRegistry.ActivationAction)) break;
            ((JMenuItem)component).putClientProperty("MenuMergeTagKey", bl ? null : DTMenuMergeTag.LAST_DOCUMENT);
            bl = true;
        }
    }

    private int getFirstGroupIndex() {
        int n = this.fFirstSingletonIndex + this.fSingletonCount + 1;
        if (PlatformInfo.isMacintosh() && this.fShowingGroupCount == 0) {
            --n;
        }
        return n;
    }

    @Override
    public void dispose() {
        this.fDesktop.getSingletons().removeListener(this.fSingletonListListener);
        this.fDesktop.getNotifyingGroups().removeListener(this.fGroupListListener);
        this.fDesktop.getWindowRegistry().depopulate((JMenu)((Object)this));
        this.setDocumentContainer(null);
        super.dispose();
    }

    @Override
    void merge(JMenu jMenu) {
        boolean bl = this.hasCloseAllItem();
        DTWindowMenu.merge((JMenu)((Object)this), jMenu);
        if (bl && !this.hasCloseAllItem()) {
            --this.fBaseItemCount;
            --this.fFirstSingletonIndex;
            if (this.fBaseItemCount == 0 && this.fSingletonSeparator != null) {
                this.fSingletonSeparator = null;
                --this.fFirstSingletonIndex;
            }
        }
        this.fHasBeenMerged = true;
    }

    private boolean hasCloseAllItem() {
        if (this.fCloseAllDocumentsAction == null) {
            return false;
        }
        for (Component component : this.getMenuComponents()) {
            if (!(component instanceof JMenuItem) || ((JMenuItem)component).getAction() != this.fCloseAllDocumentsAction) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void populate() {
        if (this.fCloseAllDocumentsAction != null) {
            this.fCloseAllDocumentsAction.setEnabled(this.fDesktop.getWindowRegistry().hasAnyVisible() || this.fShowingGroupCount > 0);
        }
        Predicate<DTWindowActivator> predicate = this.fFilteringGroupName == null ? null : new Predicate<DTWindowActivator>(){

            public boolean accept(DTWindowActivator dTWindowActivator) {
                return DTWindowMenu.this.fFilteringGroupName.equals(dTWindowActivator.getGroupName());
            }
        };
        this.fDesktop.getWindowRegistry().populate((JMenu)((Object)this), this.fShowMnemonics, predicate);
        this.updateLastDocumentTag();
    }

    @Override
    protected void populateIfNecessary() {
        this.populate();
    }

    class CloseAllDocumentsAction
    extends MJAbstractAction {
        CloseAllDocumentsAction() {
            super(DTWindowMenu.this.fDesktop.getString("action.CloseAllDocuments"));
            this.setComponentName("CloseAll");
            DTMenuMergeTag.CLOSE_ALL.setTag((Action)((Object)this));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTWindowMenu.this.fDesktop.getWindowRegistry().getCloseAllListedTransaction().start();
        }
    }

    class VanishingMenuItem
    extends MJMenuItem {
        int fType;
        boolean fSuperDone;

        VanishingMenuItem(int n, Action action) {
            super(action);
            this.fType = n;
            this.fSuperDone = true;
        }

        public void setEnabled(boolean bl) {
            if ("true".equals(this.getClientProperty("disposed_button"))) {
                return;
            }
            if (bl != this.isEnabled()) {
                super.setEnabled(bl);
                this.setVisible(bl);
                if (this.fSuperDone) {
                    if (this.fType == 1) {
                        DTWindowMenu.this.fShowingSingletonCount = bl ? ++DTWindowMenu.this.fShowingSingletonCount : --DTWindowMenu.this.fShowingSingletonCount;
                        DTWindowMenu.this.updateSingletonSeparator();
                    } else if (this.fType == 2) {
                        DTWindowMenu.this.fShowingGroupCount = bl ? ++DTWindowMenu.this.fShowingGroupCount : --DTWindowMenu.this.fShowingGroupCount;
                        DTWindowMenu.this.updateGroupSeparator();
                    }
                }
            }
        }
    }

    private class GroupListListener
    implements DTNotifyingList.Listener<DTGroup> {
        private GroupListListener() {
        }

        @Override
        public void objectAdded(DTNotifyingList dTNotifyingList, DTGroup dTGroup, int n) {
            VanishingMenuItem vanishingMenuItem = new VanishingMenuItem(2, (Action)dTGroup.getSelectAction());
            DTWindowMenu.this.add((Component)((Object)vanishingMenuItem), DTWindowMenu.this.getFirstGroupIndex() + n);
            ++DTWindowMenu.this.fGroupCount;
            if (((Component)((Object)vanishingMenuItem)).isEnabled()) {
                ++DTWindowMenu.this.fShowingGroupCount;
                DTWindowMenu.this.updateGroupSeparator();
            }
            DTWindowMenu.this.updateLastGroupTag();
        }

        @Override
        public void objectRemoved(DTNotifyingList dTNotifyingList, DTGroup dTGroup, int n) {
            int n2 = DTWindowMenu.this.getFirstGroupIndex() + n;
            JMenuItem jMenuItem = (JMenuItem)DTWindowMenu.this.getMenuComponent(n2);
            if (jMenuItem.isEnabled()) {
                --DTWindowMenu.this.fShowingGroupCount;
                DTWindowMenu.this.updateGroupSeparator();
            }
            DTWindowMenu.this.remove(n2);
            MJUtilities.dispose((AbstractButton)jMenuItem);
            --DTWindowMenu.this.fGroupCount;
            DTWindowMenu.this.updateLastGroupTag();
        }

        @Override
        public void objectMoved(DTNotifyingList dTNotifyingList, DTGroup dTGroup, int n, int n2) {
            Component component = DTWindowMenu.this.getMenuComponent(n += DTWindowMenu.this.getFirstGroupIndex());
            DTWindowMenu.this.remove(n);
            DTWindowMenu.this.add(component, n2 += DTWindowMenu.this.getFirstGroupIndex());
            DTWindowMenu.this.updateLastGroupTag();
        }

        @Override
        public void objectsReordered(DTNotifyingList dTNotifyingList) {
        }
    }

    private class SingletonListListener
    implements DTNotifyingList.Listener<DTClient> {
        private SingletonListListener() {
        }

        @Override
        public void objectAdded(DTNotifyingList dTNotifyingList, DTClient dTClient, int n) {
            VanishingMenuItem vanishingMenuItem = new VanishingMenuItem(1, (Action)dTClient.getSelectAction());
            DTWindowMenu.this.add((Component)((Object)vanishingMenuItem), DTWindowMenu.this.fFirstSingletonIndex + n);
            ++DTWindowMenu.this.fSingletonCount;
            DTWindowMenu.this.updateLastSingletonTag();
        }

        @Override
        public void objectRemoved(DTNotifyingList dTNotifyingList, DTClient dTClient, int n) {
            int n2 = DTWindowMenu.this.fFirstSingletonIndex + n;
            JMenuItem jMenuItem = (JMenuItem)DTWindowMenu.this.getMenuComponent(n2);
            if (jMenuItem.isEnabled()) {
                --DTWindowMenu.this.fShowingSingletonCount;
                DTWindowMenu.this.updateSingletonSeparator();
            }
            DTWindowMenu.this.remove(n2);
            MJUtilities.dispose((AbstractButton)jMenuItem);
            --DTWindowMenu.this.fSingletonCount;
            DTWindowMenu.this.updateLastSingletonTag();
        }

        @Override
        public void objectMoved(DTNotifyingList dTNotifyingList, DTClient dTClient, int n, int n2) {
            Component component = DTWindowMenu.this.getMenuComponent(n += DTWindowMenu.this.fFirstSingletonIndex);
            DTWindowMenu.this.remove(n);
            DTWindowMenu.this.add(component, n2 += DTWindowMenu.this.fFirstSingletonIndex);
            DTWindowMenu.this.updateLastSingletonTag();
        }

        @Override
        public void objectsReordered(DTNotifyingList dTNotifyingList) {
        }
    }
}

