/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.prefs;

import com.mathworks.widgets.prefs.PrefsEditorPanel;
import com.mathworks.widgets.prefs.PrefsEditorPanelFactory;
import com.mathworks.widgets.prefs.PrefsModel;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class PrefsNode {
    private final String fName;
    private final String fDescription;
    private final boolean fEditable;
    private final boolean fCanBeToggled;
    private final PrefsEditorPanelFactory fFactory;
    private final List<PrefsNode> fChildren;
    private PrefsNode fParent;
    private boolean fDisplayed;
    private boolean fOn;
    private PrefsModel fModel;
    private Boolean fToggleChange;
    private PrefsEditorPanel fPanel;

    public static PrefsNode createRootNode(Iterable<PrefsNode> iterable) {
        PrefsNode prefsNode = new PrefsNode(null, "_root", null, null);
        for (PrefsNode prefsNode2 : iterable) {
            prefsNode.addChild(prefsNode2);
        }
        return prefsNode;
    }

    void install(PrefsModel prefsModel) {
        this.fModel = prefsModel;
    }

    private void setParent(PrefsNode prefsNode) {
        this.fParent = prefsNode;
    }

    private PrefsModel getModel() {
        if (this.fModel != null) {
            return this.fModel;
        }
        if (this.fParent != null) {
            return this.fParent.getModel();
        }
        return null;
    }

    public PrefsNode(PrefsNode prefsNode, String string, String string2, PrefsEditorPanelFactory prefsEditorPanelFactory) {
        this.fParent = prefsNode;
        this.fName = string;
        this.fDescription = string2;
        this.fFactory = prefsEditorPanelFactory;
        this.fEditable = prefsEditorPanelFactory != null;
        this.fCanBeToggled = false;
        this.fOn = false;
        this.fChildren = new LinkedList<PrefsNode>();
    }

    public PrefsNode(PrefsNode prefsNode, String string, String string2) {
        this.fParent = prefsNode;
        this.fName = string;
        this.fDescription = string2;
        this.fFactory = null;
        this.fEditable = false;
        this.fCanBeToggled = false;
        this.fOn = false;
        this.fChildren = new LinkedList<PrefsNode>();
    }

    public PrefsNode(PrefsNode prefsNode, String string, String string2, PrefsEditorPanelFactory prefsEditorPanelFactory, boolean bl, boolean bl2) {
        this.fParent = prefsNode;
        this.fName = string;
        this.fDescription = string2;
        this.fFactory = prefsEditorPanelFactory;
        this.fEditable = prefsEditorPanelFactory != null;
        this.fCanBeToggled = bl;
        this.fOn = bl2;
        this.fChildren = new LinkedList<PrefsNode>();
    }

    public PrefsNode(PrefsNode prefsNode, String string, String string2, boolean bl, boolean bl2) {
        this.fParent = prefsNode;
        this.fName = string;
        this.fDescription = string2;
        this.fFactory = null;
        this.fEditable = false;
        this.fCanBeToggled = bl;
        this.fOn = bl2;
        this.fChildren = new LinkedList<PrefsNode>();
    }

    public String getName() {
        return this.fName;
    }

    public String getLongName() {
        if (this.fParent == null || this.fParent.getName().equals("_root")) {
            return this.getName().trim();
        }
        String string = this.fParent.getLongName().trim() + " " + this.getName().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2 == null || !string2.equals(string3)) {
                stringBuffer.append(string3);
                stringBuffer.append(" ");
            }
            string2 = string3;
        }
        return stringBuffer.toString().trim();
    }

    public String getDescription() {
        return this.fDescription;
    }

    public int getChildCount() {
        return this.fChildren.size();
    }

    public Iterable<PrefsNode> getChildren() {
        return new Vector<PrefsNode>(this.fChildren);
    }

    public PrefsNode getChild(int n) {
        return this.fChildren.get(n);
    }

    public PrefsNode getParent() {
        return this.fParent;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void resetEditorPanel() {
        if (this.fPanel != null) {
            this.fPanel.dispose();
        }
        this.fPanel = null;
    }

    public PrefsEditorPanel getEditorPanel() {
        if (this.fPanel == null) {
            this.fPanel = this.fFactory.createPanel();
        }
        return this.fPanel;
    }

    public void commitChanges() {
        if (this.fPanel != null) {
            this.fPanel.commitChanges(this);
            if (this.fToggleChange != null) {
                this.fOn = this.fToggleChange;
            }
        }
    }

    public boolean validateChanges() {
        if (this.fPanel != null) {
            return this.fPanel.validateChanges(this);
        }
        return true;
    }

    public void cancelChanges() {
        if (this.fPanel != null) {
            this.fPanel.cancelChanges(this);
        }
        this.fToggleChange = null;
        this.fDisplayed = false;
    }

    public boolean canBeToggled() {
        return this.fCanBeToggled;
    }

    public boolean isOn() {
        return this.fOn && this.fToggleChange == null || this.fOn && !this.fToggleChange.equals(Boolean.FALSE) || !this.fOn && this.fToggleChange != null && this.fToggleChange.equals(Boolean.TRUE);
    }

    public void turnOn() {
        this.fToggleChange = Boolean.TRUE;
        PrefsModel prefsModel = this.getModel();
        if (prefsModel != null) {
            prefsModel.fireNodeTurnedOn(this);
        }
    }

    public void turnOff() {
        this.fToggleChange = Boolean.FALSE;
        PrefsModel prefsModel = this.getModel();
        if (prefsModel != null) {
            prefsModel.fireNodeTurnedOff(this);
        }
    }

    public void notifyEditorDisplayed() {
        this.fDisplayed = true;
    }

    public void addChild(PrefsNode prefsNode) {
        if (prefsNode.getParent() != null && prefsNode.getParent() != this) {
            throw new IllegalStateException();
        }
        this.fChildren.add(prefsNode);
        prefsNode.setParent(this);
    }

    public void removeChild(PrefsNode prefsNode) {
        if (prefsNode.getParent() != this) {
            throw new IllegalStateException();
        }
        this.fChildren.remove(prefsNode);
        prefsNode.setParent(null);
    }

    public boolean hasToggleChange() {
        return this.canBeToggled() && this.fToggleChange != null && this.fOn ^ this.fToggleChange;
    }

    public boolean isDirty() {
        if (this.fPanel != null && this.fPanel.canDetectPendingEdits(this)) {
            return this.fPanel.hasPendingEdits(this) || this.fToggleChange != null;
        }
        return this.fDisplayed && this.isEditable() || this.fToggleChange != null;
    }
}

