/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.action.AbstractNewAction;
import com.mathworks.widgets.recordlist.InternalActionHelper;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;

class ActionUtils {
    static final String RECORDLIST_CONTEXT = "Recordlist";

    private ActionUtils() {
    }

    static void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction, ExtendedInputMap extendedInputMap, ActionMap actionMap) {
        if (MatlabKeyBindings.getManager().containsActionAndContext((Action)mJAbstractAction)) {
            MatlabKeyBindings.getManager().addKeyBindings((ExtendedAction)mJAbstractAction, extendedInputMap);
            MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)mJAbstractAction, actionMap);
        } else {
            extendedInputMap.put(mJAbstractAction.getAccelerator(), mJAbstractAction.getValue("Name"));
            actionMap.put(mJAbstractAction.getValue("Name"), (Action)mJAbstractAction);
        }
    }

    static MInputMap createMInputMap(JComponent jComponent) {
        return MInputMap.createMInputMap((JComponent)jComponent);
    }

    static abstract class BaseAction
    extends MJAbstractAction {
        protected InternalActionHelper fActionProvider;

        BaseAction(String string, String string2, InternalActionHelper internalActionHelper) {
            this(string, string2, internalActionHelper.getMInputMap(), internalActionHelper.getActionMap());
            this.fActionProvider = internalActionHelper;
        }

        BaseAction(String string, String string2, MInputMap mInputMap, ActionMap actionMap) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(ActionUtils.RECORDLIST_CONTEXT, string, (ExtendedAction)this);
            ActionUtils.registerWithInputAndActionMaps(this, (ExtendedInputMap)mInputMap, actionMap);
            this.setComponentName(string2);
        }
    }

    static class CopyingAction
    extends BaseAction {
        CopyingAction(InternalActionHelper internalActionHelper) {
            super("copy-to-clipboard", "RecordCopying", internalActionHelper);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fActionProvider.copySelection();
        }
    }

    static class DeletionAction
    extends BaseAction {
        DeletionAction(InternalActionHelper internalActionHelper) {
            super("delete-next", "RecordDeletion", internalActionHelper);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fActionProvider.deleteSelection();
        }
    }

    static class DuplicationAction
    extends BaseAction {
        DuplicationAction(InternalActionHelper internalActionHelper) {
            super("duplicate-record", "RecordDuplication", internalActionHelper);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fActionProvider.duplicateSelection();
        }
    }

    static class CreationAction
    extends AbstractNewAction {
        private final InternalActionHelper fActionProvider;

        CreationAction(InternalActionHelper internalActionHelper) {
            this.setComponentName("RecordCreation");
            ActionUtils.registerWithInputAndActionMaps(this, (ExtendedInputMap)internalActionHelper.getMInputMap(), internalActionHelper.getActionMap());
            this.fActionProvider = internalActionHelper;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fActionProvider.createRecord();
        }
    }

    static class OpeningAction
    extends BaseAction {
        OpeningAction(InternalActionHelper internalActionHelper) {
            super("open-selection", "RecordOpening", internalActionHelper);
            this.setButtonOnlyIcon(CommonIcon.OPEN.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fActionProvider.openSelection();
        }
    }

    static class SelectAllAction
    extends BaseAction {
        SelectAllAction(InternalActionHelper internalActionHelper) {
            super("select-all", "RecordSelectAll", internalActionHelper);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fActionProvider.selectAll();
        }
    }
}

