/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.widgets.spreadsheet.SpreadsheetCellBorder;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;

public class SpreadsheetCellEditor
extends DefaultCellEditor {
    private boolean fRequesterWasMouseEvent = false;
    private boolean fRequesterLocked = false;
    private SpreadsheetColor fSpreadsheetColor = null;
    private Formatter fFormat;
    public static final int APPEND = 1;
    public static final int OVERWRITE = 2;

    public SpreadsheetCellEditor(JCheckBox jCheckBox) {
        super(jCheckBox);
        this.fFormat = FormatIdentifier.getDefaultInstance().getFormatter();
    }

    public SpreadsheetCellEditor(JComboBox jComboBox) {
        super(jComboBox);
        this.fFormat = FormatIdentifier.getDefaultInstance().getFormatter();
    }

    public SpreadsheetCellEditor(JTextField jTextField, FormatIdentifier formatIdentifier) {
        super(jTextField);
        this.fFormat = formatIdentifier.getFormatter();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (!this.fRequesterLocked) {
            this.fRequesterWasMouseEvent = eventObject instanceof MouseEvent;
        }
        return super.isCellEditable(eventObject);
    }

    private void initSpreadsheetColor(JTable jTable) {
        if (this.fSpreadsheetColor == null) {
            this.fSpreadsheetColor = new SpreadsheetColor(jTable);
            this.fSpreadsheetColor.registerColorInterests();
        }
    }

    private void cleanupSpreadsheetColor() {
        if (this.fSpreadsheetColor != null) {
            this.fSpreadsheetColor.unregisterColorInterests();
        }
        this.fSpreadsheetColor = null;
    }

    public void cleanup() {
        this.cleanupSpreadsheetColor();
    }

    void lockNextEditMode(int n) {
        this.fRequesterLocked = true;
        this.fRequesterWasMouseEvent = n == 1;
    }

    private void releaseEditModeLock() {
        this.fRequesterLocked = false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.initSpreadsheetColor(jTable);
        Object object2 = this.fRequesterWasMouseEvent ? object : null;
        String string = this.fFormat.format(object2);
        JComponent jComponent = (JComponent)this.getComponent();
        if (bl) {
            Color color = this.fSpreadsheetColor.getSelectionBorder();
            jComponent.setBorder(new SpreadsheetCellBorder(SpreadsheetUtils.selectionEdgeIntAbutsCellEdge(jTable, n, n2, 1, bl) ? color : null, SpreadsheetUtils.selectionEdgeIntAbutsCellEdge(jTable, n, n2, 2, bl) ? color : null, SpreadsheetUtils.selectionEdgeIntAbutsCellEdge(jTable, n, n2, 3, bl) ? color : null, SpreadsheetUtils.selectionEdgeIntAbutsCellEdge(jTable, n, n2, 4, bl) ? color : null, null));
        } else {
            jComponent.setBorder(null);
        }
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setHorizontalAlignment(SpreadsheetUtils.getTextAlignment(object));
        }
        jComponent.setFont(jTable.getFont());
        this.releaseEditModeLock();
        return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
    }
}

