/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.widgets.spreadsheet.format.BooleanFormatter;

final class BooleanFormatterFactory {
    public static BooleanFormatter getInstance() {
        return BooleanFormatterFactory.getNumericInstance();
    }

    public static BooleanFormatter getNumericInstance() {
        return new BooleanFormatterImpl("1", "0");
    }

    public static BooleanFormatter getStringInstance() {
        return new BooleanFormatterImpl("true", "false");
    }

    public static BooleanFormatter getPlusInstance() {
        return new BooleanFormatterImpl("+", " ");
    }

    private BooleanFormatterFactory() {
    }

    private static class BooleanFormatterImpl
    implements BooleanFormatter {
        private String fTrueString;
        private String fFalseString;

        private BooleanFormatterImpl(String string, String string2) {
            this.fTrueString = string;
            this.fFalseString = string2;
        }

        @Override
        public String format(Boolean bl) {
            return bl != false ? this.fTrueString : this.fFalseString;
        }

        @Override
        public BooleanFormatter getEditingBooleanFormatter() {
            return this;
        }

        public String toString() {
            return "BooleanFormatter: " + this.fTrueString + '/' + this.fFalseString;
        }
    }
}

