/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.java;

import com.mathworks.widgets.STPPrefsManager;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.MWTokenColoringInitializer;
import com.mathworks.widgets.text.java.JavaLanguage;
import com.mathworks.widgets.text.java.JavaSyntaxHighlighting;
import java.util.Map;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class MWJavaSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "java-settings-initializer";
    private final Class<?> fJavaKitClass;

    public MWJavaSettingsInitializer(Class<?> clazz) {
        super(NAME);
        this.fJavaKitClass = clazz;
    }

    public void updateSettingsMap(Class clazz, Map map) {
        if (clazz == this.fJavaKitClass) {
            new MWJavaTokenColoringInitializer().updateSettingsMap(clazz, map);
            new MWJavaLayerTokenColoringInitializer().updateSettingsMap(clazz, map);
            SettingsUtil.updateListSetting((Map)map, (String)"token-context-list", (Object[])new TokenContext[]{JavaTokenContext.context, JavaLayerTokenContext.context});
            map.put("highlight-match-brace", Boolean.FALSE);
            map.put("indent-hot-chars-acceptor", JavaSettingsDefaults.defaultIndentHotCharsAcceptor);
            map.put("indenting-type", EditorPreferences.getIndentingStyle(JavaLanguage.INSTANCE).getInternalName());
            map.put("identifier-acceptor", JavaSettingsDefaults.defaultIdentifierAcceptor);
            map.put("pair-characters-completion", Boolean.FALSE);
            map.put("java-format-statement-continuation-indent", 0);
        }
    }

    private static class MWJavaLayerTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        private MWJavaLayerTokenColoringInitializer() {
            super((TokenContext)JavaLayerTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenCategory, boolean bl) {
            if (!bl) {
                if (tokenCategory.getNumericID() == 1) {
                    return JavaSyntaxHighlighting.getJavaMethodStyle().getColoring();
                }
            } else {
                return STPPrefsManager.getPrintColoringEvaluator();
            }
            return null;
        }
    }

    private static class MWJavaTokenColoringInitializer
    extends MWTokenColoringInitializer {
        private MWJavaTokenColoringInitializer() {
            super(JavaSyntaxHighlighting.INSTANCE);
        }

        @Override
        public Coloring doGetTokenColoring(TokenCategory tokenCategory) {
            switch (tokenCategory.getNumericID()) {
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    return SettingsDefaults.emptyColoring;
                }
                case 4: {
                    return new Coloring(null, JavaSyntaxHighlighting.ERROR.getCurrentColor(), null);
                }
                case 1: {
                    return new Coloring(null, JavaSyntaxHighlighting.KEYWORD.getCurrentColor(), null);
                }
                case 7: 
                case 8: {
                    return new Coloring(null, JavaSyntaxHighlighting.COMMENT.getCurrentColor(), null);
                }
                case 9: {
                    return new Coloring(null, JavaSyntaxHighlighting.CHAR.getCurrentColor(), null);
                }
                case 10: {
                    return new Coloring(null, JavaSyntaxHighlighting.STRING.getCurrentColor(), null);
                }
            }
            return null;
        }
    }
}

