/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class MatlabState {
    private static final int STATE_SIZE = 12;
    private final byte[] fRawState;
    private final boolean fImplicitEOL;
    private final boolean fIsExecutable;
    private static Map<Long, List<MatlabState>> sStateBuckets = new HashMap<Long, List<MatlabState>>();
    private static final int MAX_LENGTH_BUCKET = 10;
    private static final int MAX_NUM_BUCKETS = 100;

    public static MatlabState getMatlabStateInstance(byte[] byArray, boolean bl, boolean bl2) {
        if (byArray == null || byArray.length != 12) {
            throw new IllegalArgumentException("State must be of length 12");
        }
        long l = (long)byArray[7] << 56 | (long)byArray[6] << 48 | (long)byArray[5] << 40 | (long)byArray[4] << 32 | (long)byArray[3] << 24 | (long)byArray[2] << 16 | (long)byArray[1] << 8 | (long)byArray[0] << 0;
        List<MatlabState> list = sStateBuckets.get(l);
        if (list != null) {
            for (MatlabState matlabState : list) {
                if (!matlabState.isEquivalent(byArray, bl, bl2)) continue;
                return matlabState;
            }
        }
        if (list == null) {
            list = new LinkedList<MatlabState>();
            if (sStateBuckets.size() >= 100) {
                sStateBuckets.clear();
            }
            sStateBuckets.put(l, list);
        } else if (list.size() >= 10) {
            list.clear();
        }
        MatlabState matlabState = new MatlabState(byArray, bl, bl2);
        list.add(matlabState);
        return matlabState;
    }

    private MatlabState(byte[] byArray, boolean bl, boolean bl2) {
        assert (byArray.length == 12) : "length of raw state passed in (" + byArray.length + ") doesn't match expected " + "fixed length of state (" + 12 + ")";
        this.fRawState = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fRawState, 0, byArray.length);
        this.fIsExecutable = bl;
        this.fImplicitEOL = bl2;
    }

    public byte[] getState() {
        byte[] byArray = new byte[this.fRawState.length];
        System.arraycopy(this.fRawState, 0, byArray, 0, this.fRawState.length);
        return byArray;
    }

    public boolean isImplicitEOL() {
        return this.fImplicitEOL;
    }

    public boolean isExecutable() {
        return this.fIsExecutable;
    }

    public boolean isEqual(MatlabState matlabState) {
        return this.isEquivalent(matlabState.getState(), matlabState.isExecutable(), matlabState.isImplicitEOL());
    }

    private boolean isEquivalent(byte[] byArray, boolean bl, boolean bl2) {
        return this.isImplicitEOL() == bl2 && this.isExecutable() == bl && Arrays.equals(this.fRawState, byArray);
    }
}

