/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.services.Prefs;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;

public class VariableHighlightPrefs {
    public static final String HIGHLIGHT_COLOR_PREF_KEY = "Editor.VariableHighlighting.Color";
    public static final Color DEFAULT_VAR_HIGHLIGHT_COLOR = new Color(202, 232, 232);
    public static final String VARIABLE_HIGHLIGHT_ENABLED_PREF_KEY = "Editor.VariableHighlighting";
    public static final boolean VARIABLE_HIGHLIGHT_ENABLED_DEFAULT = true;
    public static final String AUTO_HIGHLIGHT_PREF_KEY = "Editor.VariableHighlighting.Automatic";
    public static final boolean AUTO_HIGHLIGHT_DEFAULT = true;
    public static final String VARIABLE_QUICK_RENAME_PREF_KEY = "Editor.VariableHighlighting.VariableQuickRename";
    public static final boolean VARIABLE_QUICK_RENAME_DEFAULT = true;
    public static final String NONLOCAL_TEXT_COLOR_PREF_KEY = "Editor.NonlocalVariableHighlighting.TextColor";
    public static final Color NONLOCAL_VAR_TEXT_COLOR_DEFAULT = new Color(0, 163, 163);
    public static final boolean NONLOCAL_VAR_HIGHLIGHT_ENABLE_DEFAULT = true;
    public static final String NONLOCAL_VAR_HIGHLIGHT_ENABLED_PREF_KEY = "Editor.NonlocalVariableHighlighting";
    private static final Collection<ActionListener> SETTINGS_LISTENERS = new Vector<ActionListener>();

    private VariableHighlightPrefs() {
    }

    public static boolean isVariableHighlightingEnabled() {
        return Prefs.getBooleanPref((String)VARIABLE_HIGHLIGHT_ENABLED_PREF_KEY, (boolean)true);
    }

    public static void setVariableHighlightingEnabled(boolean bl) {
        Prefs.setBooleanPref((String)VARIABLE_HIGHLIGHT_ENABLED_PREF_KEY, (boolean)bl);
        VariableHighlightPrefs.fireAllSettingChangeListeners();
    }

    public static boolean isAutoHighlighting() {
        return Prefs.getBooleanPref((String)AUTO_HIGHLIGHT_PREF_KEY, (boolean)true);
    }

    public static void setAutoHighlighting(boolean bl) {
        Prefs.setBooleanPref((String)AUTO_HIGHLIGHT_PREF_KEY, (boolean)bl);
        VariableHighlightPrefs.fireAllSettingChangeListeners();
    }

    public static void addSettingChangeListener(ActionListener actionListener) {
        SETTINGS_LISTENERS.add(actionListener);
    }

    public static void removeSettingChangeListener(ActionListener actionListener) {
        SETTINGS_LISTENERS.remove(actionListener);
    }

    private static void fireAllSettingChangeListeners() {
        for (ActionListener actionListener : SETTINGS_LISTENERS) {
            actionListener.actionPerformed(null);
        }
    }

    public static boolean isVariableQuickRename() {
        return Prefs.getBooleanPref((String)VARIABLE_QUICK_RENAME_PREF_KEY, (boolean)true);
    }

    public static void setVariableQuickRename(boolean bl) {
        Prefs.setBooleanPref((String)VARIABLE_QUICK_RENAME_PREF_KEY, (boolean)bl);
        VariableHighlightPrefs.fireAllSettingChangeListeners();
    }

    public static Color getPreferredHighlightColor() {
        return Prefs.getColorPref((String)HIGHLIGHT_COLOR_PREF_KEY, (Color)DEFAULT_VAR_HIGHLIGHT_COLOR);
    }

    public static void setNonlocalVariableHighlightingEnabled(boolean bl) {
        Prefs.setBooleanPref((String)NONLOCAL_VAR_HIGHLIGHT_ENABLED_PREF_KEY, (boolean)bl);
    }

    public static boolean isNonlocalVariableHighlightingEnabled() {
        return Prefs.getBooleanPref((String)NONLOCAL_VAR_HIGHLIGHT_ENABLED_PREF_KEY, (boolean)true);
    }

    public static Color getPreferredNonlocalVariableTextColor() {
        return Prefs.getColorPref((String)NONLOCAL_TEXT_COLOR_PREF_KEY, (Color)NONLOCAL_VAR_TEXT_COLOR_DEFAULT);
    }
}

