/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.widgets.text.mcode.variables.VariableHighlightActions;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;

public class VariableStatusBarUtils {
    private static VariableHighlightingLayerStatusInfoProvider sStatusInfoProvider;

    private VariableStatusBarUtils() {
    }

    static boolean statusCanBeChanged(String string, String string2) {
        boolean bl = string == null || string.isEmpty();
        boolean bl2 = sStatusInfoProvider != null && sStatusInfoProvider.matchesMatlabStatusText(string);
        return bl || bl2 || VariableStatusBarUtils.statusIsLastVariableHighlightingMessage(string, string2);
    }

    public static void setStatusInfoProvider(VariableHighlightingLayerStatusInfoProvider variableHighlightingLayerStatusInfoProvider) {
        sStatusInfoProvider = variableHighlightingLayerStatusInfoProvider;
    }

    static boolean statusIsLastVariableHighlightingMessage(String string, String string2) {
        return string2 != null && string2.equals(string);
    }

    public static String getStatusBarKeyBindingMessage() {
        String string = VariableHighlightActions.getHighlightKeystroke();
        if (string.isEmpty()) {
            return "";
        }
        String string2 = MessageFormat.format(VariableHighlightUtils.getBundle().getString("statusBar.toHighlight"), string);
        return " " + string2;
    }

    protected static void setStatusBarMessage(final JTextComponent jTextComponent, final String string) {
        Utilities.setStatusText((JTextComponent)jTextComponent, (String)string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Utilities.setStatusText((JTextComponent)jTextComponent, (String)string);
            }
        });
    }

    public static String getStatusBarMessage(String string, int n) {
        if (n == 1) {
            return MessageFormat.format(VariableHighlightUtils.getBundle().getString("statusBar.oneVariableFound"), string);
        }
        return MessageFormat.format(VariableHighlightUtils.getBundle().getString("statusBar.variableFound"), n, string);
    }

    public static interface VariableHighlightingLayerStatusInfoProvider {
        public boolean matchesMatlabStatusText(String var1);
    }
}

