/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.tooltip;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class ToolTipAndComponentAWTListener
implements AWTEventListener {
    private static final long AWT_EVENT_MASK = 131120L;
    private TipState fState = TipState.TIP_NOT_SHOWING;
    private boolean fPersistentInsideSource;
    private Component fComponent;
    private final Timer fHideTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipAndComponentAWTListener.this.hideTip();
        }
    });
    private final Timer fShowTimer;
    private final int fShowDelay;
    private MouseEvent fLastMouseEvent;
    private boolean fMovedOutsideSource;

    public ToolTipAndComponentAWTListener(Component component, int n) {
        this.fComponent = component;
        this.fShowDelay = n;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 131120L);
        this.fHideTimer.setRepeats(false);
        this.fShowTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolTipAndComponentAWTListener.this.movedInsideSource(ToolTipAndComponentAWTListener.this.fLastMouseEvent);
            }
        });
        this.fShowTimer.setRepeats(false);
    }

    public void uninstall() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ToolTipAndComponentAWTListener.this.isTipShowing()) {
                    ToolTipAndComponentAWTListener.this.hideTip();
                }
                ToolTipAndComponentAWTListener.this.fShowTimer.stop();
                ToolTipAndComponentAWTListener.this.fHideTimer.stop();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.removeAWTEventListener(ToolTipAndComponentAWTListener.this);
                ToolTipAndComponentAWTListener.this.fComponent = null;
            }
        });
    }

    public void setPersistentInsideSource(boolean bl) {
        this.fPersistentInsideSource = bl;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        assert (this.fComponent != null);
        boolean bl = aWTEvent.getSource() == this.fComponent;
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        switch (aWTEvent.getID()) {
            case 503: {
                if (bl) {
                    this.mouseMovedInsideSourceComponent(mouseEvent);
                    this.fMovedOutsideSource = false;
                    break;
                }
                this.fShowTimer.stop();
                this.fMovedOutsideSource = true;
                if (!this.isTipShowing()) break;
                this.mouseMovedOutsideSourceComponent(mouseEvent);
                break;
            }
            case 501: 
            case 506: {
                if (!this.mouseInTipComponent(mouseEvent)) break;
                this.mouseClickedInsideTip(mouseEvent);
                break;
            }
            case 505: {
                this.fShowTimer.stop();
                this.startHideTimer();
            }
        }
        if (aWTEvent instanceof MouseWheelEvent) {
            this.mouseWheeled((MouseWheelEvent)mouseEvent);
        }
    }

    private void mouseMovedInsideSourceComponent(MouseEvent mouseEvent) {
        switch (this.fState) {
            case TIP_NOT_SHOWING: {
                if (!this.isTipShowing()) break;
                this.fState = TipState.TIP_SHOWN_MOUSE_NOT_MOVED;
                break;
            }
            case TIP_SHOWN_MOUSE_NOT_MOVED: {
                this.fState = TipState.TIP_SHOWN_MOUSE_MOVED;
                this.startHideTimer();
                break;
            }
            case TIP_SHOWN_MOUSE_MOVED: {
                this.movedInsideSource(mouseEvent);
                if (this.fPersistentInsideSource) break;
                this.startHideTimer();
            }
        }
        this.fShowTimer.restart();
        this.fLastMouseEvent = mouseEvent;
        if (!this.isTipShowing()) {
            this.fState = TipState.TIP_NOT_SHOWING;
        }
    }

    private void mouseMovedOutsideSourceComponent(MouseEvent mouseEvent) {
        if (!this.mouseInTipComponent(mouseEvent)) {
            this.startHideTimer();
        } else {
            this.stopHideTimer();
        }
    }

    private boolean mouseInTipComponent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
        return this.doesTipContainScreenCoordinates(point);
    }

    private void mouseWheeled(MouseWheelEvent mouseWheelEvent) {
        if (this.mouseInTipComponent(mouseWheelEvent)) {
            this.mouseWheeledInsideTip(mouseWheelEvent);
            mouseWheelEvent.consume();
        } else {
            this.fShowTimer.stop();
            this.fMovedOutsideSource = true;
            if (this.isTipShowing()) {
                this.mouseMovedOutsideSourceComponent(mouseWheelEvent);
            }
        }
    }

    protected boolean movedOutsideSource() {
        return this.fMovedOutsideSource;
    }

    protected abstract void hideTip();

    protected abstract void movedInsideSource(MouseEvent var1);

    protected abstract boolean isTipShowing();

    protected abstract boolean shouldStartHideTimer();

    protected abstract boolean doesTipContainScreenCoordinates(Point var1);

    protected abstract void mouseWheeledInsideTip(MouseWheelEvent var1);

    protected abstract void mouseClickedInsideTip(MouseEvent var1);

    public void stopHideTimer() {
        this.fHideTimer.stop();
    }

    protected void restartShowTimer(boolean bl) {
        this.fShowTimer.setInitialDelay(bl ? (int)((double)this.fShowDelay * 0.82) : this.fShowDelay);
        this.fShowTimer.restart();
    }

    private void startHideTimer() {
        if (!this.fHideTimer.isRunning() && this.shouldStartHideTimer()) {
            this.fHideTimer.start();
        }
    }

    private static enum TipState {
        TIP_NOT_SHOWING,
        TIP_SHOWN_MOUSE_NOT_MOVED,
        TIP_SHOWN_MOUSE_MOVED;

    }
}

