/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public final class LazilyLoadedCtor {
    private static Method NOT_FOUND;
    private static Method OEAB;
    private String defineClass;
    private String defineProperty;
    private boolean delete;
    private boolean findMethods;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl) {
        this.defineProperty = string2;
        this.defineClass = string;
        this.delete = bl;
        if (NOT_FOUND == null) {
            Method[] methodArray = FunctionObject.getMethodList(this.getClass());
            NOT_FOUND = FunctionObject.findMethods(methodArray, "getProperty")[0];
            OEAB = FunctionObject.findMethods(methodArray, "setProperty")[0];
        }
        try {
            scriptableObject.defineProperty(string, this, NOT_FOUND, OEAB, 2);
        }
        catch (PropertyException propertyException) {
            throw WrappedException.wrapException(propertyException);
        }
    }

    public Object getProperty(ScriptableObject scriptableObject) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            if (!this.findMethods) {
                boolean bl = false;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(this.defineProperty);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
                if (clazz != null) {
                    try {
                        ScriptableObject.defineClass(scriptableObject, clazz, this.delete);
                        this.findMethods = true;
                    }
                    catch (InstantiationException instantiationException) {
                        throw WrappedException.wrapException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw WrappedException.wrapException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw WrappedException.wrapException(invocationTargetException);
                    }
                    catch (ClassDefinitionException classDefinitionException) {
                        throw WrappedException.wrapException(classDefinitionException);
                    }
                    catch (PropertyException propertyException) {
                        throw WrappedException.wrapException(propertyException);
                    }
                    catch (SecurityException securityException) {
                        bl = true;
                    }
                }
                if (bl) {
                    scriptableObject.delete(this.defineClass);
                    Object object = Scriptable.NOT_FOUND;
                    return object;
                }
            }
        }
        return scriptableObject.get(this.defineClass, (Scriptable)scriptableObject);
    }

    public Object setProperty(ScriptableObject scriptableObject, Object object) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            this.findMethods = true;
            Object object2 = object;
            return object2;
        }
    }
}

