/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.components.gallery.GalleryButton;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryContentPanel;
import com.mathworks.toolstrip.components.gallery.popupview.FavoriteButton;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

class CategoryIconPanel
extends CategoryContentPanel {
    private final int fPreferredWidth;
    private final Dimension fItemSize;
    private final List<GalleryButton> fButtons = new ArrayList<GalleryButton>();
    private Dimension fGridSize = new Dimension(1, 1);
    private Dragger fDragger;
    private ChangeListener fChangeListener;
    private static final int BUTTON_TOP_MARGIN = 8;
    private static final int DRAG_THRESHOLD = 6;

    CategoryIconPanel(Category category, GalleryModel galleryModel, GallerySelectionModel gallerySelectionModel, PopupMenuCustomizer popupMenuCustomizer, Runnable runnable, int n, Dimension dimension, int n2) {
        super(category, galleryModel, gallerySelectionModel, popupMenuCustomizer, runnable);
        this.fPreferredWidth = n;
        this.fItemSize = dimension;
        this.init(n2, galleryModel);
    }

    void init(int n, GalleryModel galleryModel) {
        this.setLayout(null);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolstripTheme.getInstance().getGalleryViewOutlineColor()));
        List<Item> list = this.fModel.getItems(this.fCategory);
        for (Item item : list) {
            FavoriteButton favoriteButton = new FavoriteButton(item, galleryModel, this.fFavoritesAnimation);
            final GalleryButton galleryButton = new GalleryButton(item.getAction());
            galleryButton.setLabelLineCount(n);
            Insets insets = galleryButton.getMargin();
            insets.top = 8;
            galleryButton.setMargin(insets);
            galleryButton.putClientProperty("item", item);
            galleryButton.setName(item.getName());
            this.fButtons.add(galleryButton);
            galleryButton.setFavoriteButton((JButton)((Object)favoriteButton), !galleryModel.isFavorite(item) || this.fCategory.equals(Category.FAVORITES));
            galleryButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    CategoryIconPanel.this.fSelectionModel.deselect();
                    Item item = (Item)galleryButton.getClientProperty("item");
                    if (item != null && item.isEnabled()) {
                        CategoryIconPanel.this.fSelectionModel.setSelectedItem(CategoryIconPanel.this.fCategory, item, true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            this.add((Component)((Object)galleryButton));
        }
        if (this.fChangeListener == null) {
            this.fChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() instanceof GallerySelectionModel) {
                        GallerySelectionModel gallerySelectionModel = (GallerySelectionModel)changeEvent.getSource();
                        if (gallerySelectionModel.getSelectedCategory() != null && !gallerySelectionModel.getSelectedCategory().equals(CategoryIconPanel.this.fCategory)) {
                            return;
                        }
                        if (gallerySelectionModel.getSelectedItem() == null) {
                            for (GalleryButton galleryButton : CategoryIconPanel.this.fButtons) {
                                galleryButton.putClientProperty("BUTTON_SELECTED_BY_KEY", Boolean.FALSE);
                            }
                        } else {
                            Component component = CategoryIconPanel.this.getComponentForItem(gallerySelectionModel.getSelectedItem());
                            if (component != null) {
                                ((JComponent)component).putClientProperty("BUTTON_SELECTED_BY_KEY", Boolean.TRUE);
                            }
                        }
                    }
                }
            };
            this.fSelectionModel.addChangeListener(this.fChangeListener);
        }
    }

    @Override
    public Item getNextItem(Item item) {
        Object object;
        if (item == null) {
            for (GalleryButton galleryButton : this.fButtons) {
                object = (Item)galleryButton.getClientProperty("item");
                if (object == null || !((Item)object).isEnabled()) continue;
                return object;
            }
        }
        Object object2 = null;
        for (int i = 0; i < this.fButtons.size(); ++i) {
            object = this.fButtons.get(i);
            if (!object.getClientProperty((Object)"item").equals(item) || i + 1 >= this.fButtons.size()) continue;
            object2 = (Item)this.fButtons.get(i + 1).getClientProperty("item");
            if (((Item)object2).isEnabled()) break;
            int n = 2;
            boolean bl = false;
            while (!bl && i + n <= this.fButtons.size() - 1) {
                Item item2 = (Item)this.fButtons.get(i + n).getClientProperty("item");
                if (item2.isEnabled()) {
                    object2 = item2;
                    bl = true;
                    continue;
                }
                object2 = null;
                ++n;
            }
        }
        if (object2 != null && !((Item)object2).isEnabled()) {
            object2 = null;
        }
        return object2;
    }

    @Override
    public Item getPreviousItem(Item item) {
        if (item == null) {
            for (int i = this.fButtons.size() - 1; i >= 0; --i) {
                Item item2 = (Item)this.fButtons.get(i).getClientProperty("item");
                if (item2 == null || !item2.isEnabled()) continue;
                return item2;
            }
        }
        Item item3 = null;
        for (int i = 0; i < this.fButtons.size(); ++i) {
            GalleryButton galleryButton = this.fButtons.get(i);
            if (!galleryButton.getClientProperty("item").equals(item) || i - 1 < 0) continue;
            item3 = (Item)this.fButtons.get(i - 1).getClientProperty("item");
            if (item3.isEnabled()) break;
            int n = 2;
            boolean bl = false;
            while (!bl && i - n >= 0) {
                Item item4 = (Item)this.fButtons.get(i - n).getClientProperty("item");
                if (item4.isEnabled()) {
                    item3 = item4;
                    bl = true;
                    continue;
                }
                item3 = null;
                ++n;
            }
        }
        if (item3 != null && !item3.isEnabled()) {
            item3 = null;
        }
        return item3;
    }

    @Override
    void setDragEnabled(boolean bl) {
        if (bl) {
            if (this.fDragger == null) {
                this.fDragger = new Dragger();
                for (GalleryButton galleryButton : this.fButtons) {
                    galleryButton.addMouseListener(this.fDragger);
                    galleryButton.addMouseMotionListener(this.fDragger);
                }
            }
        } else if (this.fDragger != null) {
            for (GalleryButton galleryButton : this.fButtons) {
                galleryButton.removeMouseListener(this.fDragger);
                galleryButton.removeMouseMotionListener(this.fDragger);
            }
            this.fDragger = null;
        }
    }

    @Override
    void setActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        for (GalleryButton galleryButton : this.fButtons) {
            ((AbstractButton)((Object)galleryButton)).addActionListener(actionListener);
        }
    }

    @Override
    void setCloseListener(final ActionListener actionListener) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    actionListener.actionPerformed(null);
                }
            }
        };
        for (GalleryButton galleryButton : this.fButtons) {
            ((Component)((Object)galleryButton)).addMouseListener(mouseAdapter);
        }
    }

    @Override
    Item getItemAtPoint(Point point) {
        Component component = SwingUtilities.getDeepestComponentAt((Component)((Object)this), point.x, point.y);
        if (component instanceof GalleryButton) {
            return (Item)((JComponent)component).getClientProperty("item");
        }
        return null;
    }

    @Override
    public Component getComponentForItem(Item item) {
        for (GalleryButton galleryButton : this.fButtons) {
            if (!galleryButton.getName().equals(item.getName())) continue;
            return galleryButton;
        }
        return null;
    }

    @Override
    public void dispose() {
        for (GalleryButton galleryButton : this.fButtons) {
            MJUtilities.dispose((AbstractButton)((Object)galleryButton));
        }
        this.fButtons.clear();
        this.fSelectionModel.removeChangeListener(this.fChangeListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.computeGridSize(this.fPreferredWidth);
        return new Dimension(this.fPreferredWidth, dimension.height * (this.fItemSize.height + 8 + 1) - 1 + 2 + 8);
    }

    public void doLayout() {
        this.fGridSize = this.computeGridSize(this.getWidth());
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        for (GalleryButton galleryButton : this.fButtons) {
            ((Component)((Object)galleryButton)).setBounds(n, n2, this.fItemSize.width, this.fItemSize.height + 8);
            if (++n3 < this.fGridSize.width) {
                n += this.fItemSize.width + 5;
                continue;
            }
            n = 8;
            n2 += this.fItemSize.height + 1 + 8;
            n3 = 0;
        }
        if (this.fDragger != null && this.fDragger.iDragLayer != null) {
            this.fDragger.iDragLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private Dimension computeGridSize(int n) {
        int n2 = (n - 16 + 5) / (this.fItemSize.width + 5);
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = (this.fButtons.size() + n2 - 1) / n2;
        return new Dimension(n2, n3);
    }

    private int indexFromRowColumn(int n, int n2) {
        return Math.min(n2 * this.fGridSize.width + n, this.fButtons.size());
    }

    private Point rowColumnFromIndex(int n) {
        return new Point(n % this.fGridSize.width, n / this.fGridSize.width);
    }

    private int getColumnAt(int n) {
        int n2 = (n - 8 + 2) / (this.fItemSize.width + 5);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.fGridSize.width) {
            n2 = this.fGridSize.width - 1;
        }
        return n2;
    }

    private int getRowAt(int n) {
        int n2 = (n - 2 + 0) / (this.fItemSize.height + 5);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.fGridSize.height) {
            n2 = this.fGridSize.height - 1;
        }
        return n2;
    }

    private class DragLayer
    extends JComponent {
        private DragLayer() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.33f));
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite(composite);
            Point point = CategoryIconPanel.this.rowColumnFromIndex(CategoryIconPanel.this.fDragger.iDropIndex);
            int n = 8 + point.x * (((CategoryIconPanel)CategoryIconPanel.this).fItemSize.width + 5);
            int n2 = 2 + point.y * (((CategoryIconPanel)CategoryIconPanel.this).fItemSize.height + 1 + 8) + 0;
            graphics2D.setColor(Color.darkGray);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawLine(n, n2, n, n2 + ((CategoryIconPanel)CategoryIconPanel.this).fItemSize.height + 1 + 1);
            graphics2D.drawImage((Image)CategoryIconPanel.this.fDragger.iDragImage, ((Dragger)((CategoryIconPanel)CategoryIconPanel.this).fDragger).iDragImageRect.x, ((Dragger)((CategoryIconPanel)CategoryIconPanel.this).fDragger).iDragImageRect.y, null);
        }
    }

    private class Dragger
    extends MouseInputAdapter {
        private Point iPressedPoint;
        private GalleryButton iPressedButton;
        private boolean iIsDragging;
        private Point iInitialCenter;
        private int iInitialIndex;
        private int iDropIndex;
        private JComponent iDragLayer;
        private Rectangle iDragImageRect;
        private BufferedImage iDragImage;

        private Dragger() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent() instanceof GalleryButton) {
                this.iPressedButton = (GalleryButton)((Object)mouseEvent.getComponent());
                this.iPressedPoint = SwingUtilities.convertPoint((Component)((Object)this.iPressedButton), mouseEvent.getPoint(), (Component)((Object)CategoryIconPanel.this));
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iPressedPoint != null) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)CategoryIconPanel.this));
                int n = point.x - this.iPressedPoint.x;
                int n2 = point.y - this.iPressedPoint.y;
                if (!this.iIsDragging) {
                    if (Math.abs(n) >= 6 || Math.abs(n2) >= 6) {
                        this.startDrag(n, n2);
                    }
                } else {
                    this.iDragImageRect = this.computeDragRect(n, n2);
                    int n3 = this.computeDropIndex(n, n2);
                    if (n3 != this.iDropIndex) {
                        this.iDropIndex = n3;
                    }
                    CategoryIconPanel.this.repaint();
                    mouseEvent.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.iIsDragging) {
                    this.endDrag();
                }
                this.iPressedPoint = null;
                this.iPressedButton = null;
            }
        }

        private void startDrag(int n, int n2) {
            this.iIsDragging = true;
            this.iDropIndex = this.iInitialIndex = CategoryIconPanel.this.fButtons.indexOf(this.iPressedButton);
            this.iInitialCenter = new Point(this.iPressedButton.getX() + this.iPressedButton.getWidth() / 2, this.iPressedButton.getY() + this.iPressedButton.getHeight() / 2);
            this.iPressedButton.getModel().setArmed(false);
            this.iPressedButton.getModel().setPressed(false);
            this.iDragImage = new BufferedImage(this.iPressedButton.getWidth(), this.iPressedButton.getHeight(), 2);
            Graphics2D graphics2D = this.iDragImage.createGraphics();
            this.iPressedButton.paint(graphics2D);
            graphics2D.dispose();
            this.iDragImageRect = this.computeDragRect(n, n2);
            this.iDragLayer = new DragLayer();
            this.iDragLayer.addMouseListener(this);
            CategoryIconPanel.this.add(this.iDragLayer, 0);
            CategoryIconPanel.this.revalidate();
            CategoryIconPanel.this.repaint();
        }

        private void endDrag() {
            CategoryIconPanel.this.remove(this.iDragLayer);
            this.iDragLayer.removeMouseListener(this);
            this.iDragLayer = null;
            if (this.iDropIndex > this.iInitialIndex) {
                --this.iDropIndex;
            }
            if (this.iDropIndex != this.iInitialIndex) {
                CategoryIconPanel.this.fModel.moveItem(CategoryIconPanel.this.fCategory, (Item)this.iPressedButton.getClientProperty("item"), this.iDropIndex);
            } else {
                CategoryIconPanel.this.repaint();
            }
            this.iInitialCenter = null;
            this.iIsDragging = false;
            this.iDragImageRect = null;
            this.iDragImage = null;
        }

        private Rectangle computeDragRect(int n, int n2) {
            Rectangle rectangle = this.iPressedButton.getBounds();
            rectangle.x += n;
            rectangle.y += n2;
            if (rectangle.x < 0) {
                rectangle.x = 0;
            } else if (rectangle.x + rectangle.width > CategoryIconPanel.this.getWidth()) {
                rectangle.x = CategoryIconPanel.this.getWidth() - rectangle.width;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            } else if (rectangle.y + rectangle.height > CategoryIconPanel.this.getHeight()) {
                rectangle.y = CategoryIconPanel.this.getHeight() - rectangle.height;
            }
            return rectangle;
        }

        private int computeDropIndex(int n, int n2) {
            return CategoryIconPanel.this.indexFromRowColumn(CategoryIconPanel.this.getColumnAt(this.iInitialCenter.x + n), CategoryIconPanel.this.getRowAt(this.iInitialCenter.y + n2));
        }
    }
}

