/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.popups;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.Attributes;
import com.mathworks.desktop.attr.BooleanAttribute;
import com.mathworks.desktop.attr.DefaultAttributes;
import com.mathworks.desktop.attr.EnumAttribute;
import com.mathworks.desktop.attr.IconAttribute;
import com.mathworks.desktop.attr.StringAttribute;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ListItem {
    private final String fName;
    private final Attributes fAttrs = new DefaultAttributes((Object)this);
    public static final StringAttribute TITLE = new StringAttribute("title");
    public static final StringAttribute DESCRIPTION = new StringAttribute("description");
    public static final StringAttribute HELP = new StringAttribute("help");
    public static final IconAttribute ICON = new IconAttribute("icon");
    public static final StringAttribute SHORTCUT_KEY = new StringAttribute("shortcutkey");
    public static final BooleanAttribute HEADER = new BooleanAttribute("header");
    public static final BooleanAttribute SUB_LIST = new BooleanAttribute("sublist");
    public static final Attribute<PopupListener> POPUP_LISTENER = new Attribute("popuplistener");
    public static final BooleanAttribute HAS_CHECKBOX = new BooleanAttribute("checkbox");
    public static final BooleanAttribute CHECKVALUE_STATE = new BooleanAttribute("checkboxvalue");
    public static final BooleanAttribute ENABLED_STATE = new BooleanAttribute("itemstate");
    public static final BooleanAttribute HAS_SEPARATOR = new BooleanAttribute("hasseparator");
    public static final EnumAttribute<ListStyle> STYLE = new EnumAttribute("style", ListStyle.class);

    public ListItem(@NotNull String string) {
        this.fName = string;
        this.getAttributes().setAttribute((Attribute)ENABLED_STATE, (Object)true);
    }

    @NotNull
    public String getName() {
        return this.fName;
    }

    @NotNull
    public Attributes getAttributes() {
        return this.fAttrs;
    }

    @NotNull
    public <T> ListItem setAttribute(Attribute<T> attribute, T t) {
        this.fAttrs.setAttribute(attribute, t);
        return this;
    }

    public boolean isHeader() {
        return (Boolean)this.getAttributes().getAttribute((Attribute)HEADER);
    }

    public boolean isSubList() {
        return (Boolean)this.getAttributes().getAttribute((Attribute)SUB_LIST);
    }

    public static ListItem newItem(@NotNull String string, @NotNull ResourceBundle resourceBundle) {
        String string2 = null;
        if (resourceBundle.containsKey(string + ".title")) {
            string2 = resourceBundle.getString(string + ".title");
        }
        String string3 = null;
        if (resourceBundle.containsKey(string + ".description")) {
            string3 = resourceBundle.getString(string + ".description");
        }
        String string4 = null;
        if (resourceBundle.containsKey(string + ".help")) {
            string4 = resourceBundle.getString(string + ".help");
        }
        ImageIcon imageIcon = null;
        if (resourceBundle.containsKey(string + ".icon")) {
            String string5 = resourceBundle.getString(string + ".icon");
            imageIcon = IconEnumerationUtils.getIcon((String)string5, (ClassLoader)resourceBundle.getClass().getClassLoader());
        }
        return ListItem.newItem(string, string2, string3, string4, imageIcon);
    }

    public static ListItem newItem(@NotNull String string, String string2) {
        return ListItem.newItem(string, string2, null, null);
    }

    public static ListItem newItem(@NotNull String string, String string2, Icon icon) {
        return ListItem.newItem(string, string2, null, icon);
    }

    public static ListItem newItem(@NotNull String string, String string2, String string3, Icon icon) {
        return ListItem.newItem(string, string2, string3, null, icon);
    }

    public static ListItem newItem(@NotNull String string, String string2, String string3, String string4, Icon icon) {
        ListItem listItem = new ListItem(string);
        if (string2 != null) {
            listItem.getAttributes().setAttribute((Attribute)TITLE, (Object)string2);
        }
        if (string3 != null) {
            listItem.getAttributes().setAttribute((Attribute)DESCRIPTION, (Object)string3);
        }
        if (icon != null) {
            listItem.getAttributes().setAttribute((Attribute)ICON, (Object)icon);
        }
        if (string4 != null) {
            listItem.getAttributes().setAttribute((Attribute)HELP, (Object)string4);
        }
        return listItem;
    }

    public static ListItem newHeader(@NotNull String string) {
        return ListItem.newHeader(string, null);
    }

    public static ListItem newHeader(@NotNull String string, ListStyle listStyle) {
        return ListItem.newHeader(string, string, listStyle);
    }

    public static ListItem newHeader(@NotNull String string, @NotNull String string2, ListStyle listStyle) {
        ListItem listItem = new ListItem(string);
        listItem.getAttributes().setAttribute((Attribute)TITLE, (Object)string2);
        listItem.getAttributes().setAttribute((Attribute)HEADER, (Object)true);
        if (listStyle != null) {
            listItem.getAttributes().setAttribute(STYLE, (Object)listStyle);
        }
        return listItem;
    }

    public static ListItem newSubList(@NotNull String string, @NotNull String string2, Icon icon, final PopupList popupList) {
        return ListItem.newSubList(string, string2, icon, new PopupListener(){

            @Override
            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                popupCallback.show(popupList);
            }
        });
    }

    public static ListItem newSubList(@NotNull String string, @NotNull String string2, Icon icon, PopupListener popupListener) {
        ListItem listItem = new ListItem(string);
        listItem.getAttributes().setAttribute((Attribute)TITLE, (Object)string2);
        listItem.getAttributes().setAttribute((Attribute)SUB_LIST, (Object)true);
        if (icon != null) {
            listItem.getAttributes().setAttribute((Attribute)ICON, (Object)icon);
        }
        if (popupListener != null) {
            listItem.getAttributes().setAttribute(POPUP_LISTENER, (Object)popupListener);
        }
        return listItem;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ListItem && ((ListItem)object).fName.equals(this.fName);
    }

    public String toString() {
        return "ListItem{" + this.fName + '}';
    }
}

