/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class TSToolPath {
    private final String fContextName;
    private final String fTabName;
    private final String fSectionName;
    private final boolean fIsCommon;
    private final String[] fToolNames;
    private final String[] fToolSetNames;
    private static final String[] EMPTY_NAMES = new String[0];

    public TSToolPath(@NotNull String string, @NotNull String string2) {
        this((String)null, string, string2);
    }

    public TSToolPath(String string, @NotNull String string2, @NotNull String string3) {
        this.fContextName = string;
        this.fTabName = string2;
        this.fSectionName = string3;
        this.fIsCommon = false;
        this.fToolNames = EMPTY_NAMES;
        this.fToolSetNames = EMPTY_NAMES;
    }

    public TSToolPath(@NotNull TSToolPath tSToolPath, boolean bl) {
        this.fContextName = tSToolPath.fContextName;
        this.fTabName = tSToolPath.fTabName;
        this.fSectionName = tSToolPath.fSectionName;
        this.fIsCommon = bl;
        this.fToolNames = Arrays.copyOf(tSToolPath.fToolNames, tSToolPath.fToolNames.length);
        this.fToolSetNames = Arrays.copyOf(tSToolPath.fToolSetNames, tSToolPath.fToolSetNames.length);
    }

    public TSToolPath(@NotNull TSToolPath tSToolPath, @NotNull String string, @NotNull String string2) {
        this(tSToolPath, string, string2, false);
    }

    public TSToolPath(@NotNull TSToolPath tSToolPath, @NotNull String string, @NotNull String string2, boolean bl) {
        int n = tSToolPath.fToolNames.length;
        int n2 = n + 1;
        this.fContextName = tSToolPath.fContextName;
        this.fTabName = tSToolPath.fTabName;
        this.fSectionName = tSToolPath.fSectionName;
        this.fIsCommon = bl;
        this.fToolNames = new String[n2];
        this.fToolSetNames = new String[n2];
        for (int i = 0; i < n; ++i) {
            this.fToolNames[i] = tSToolPath.fToolNames[i];
            this.fToolSetNames[i] = tSToolPath.fToolSetNames[i];
        }
        this.fToolNames[n2 - 1] = string;
        this.fToolSetNames[n2 - 1] = string2;
    }

    public TSToolPath appendTool(@NotNull String string, @NotNull String string2) {
        return new TSToolPath(this, string, string2);
    }

    public TSToolPath appendTool(@NotNull String string, @NotNull String string2, boolean bl) {
        return new TSToolPath(this, string, string2, bl);
    }

    public String getContextName() {
        return this.fContextName;
    }

    @NotNull
    public String getTabName() {
        return this.fTabName;
    }

    @NotNull
    public String getSectionName() {
        return this.fSectionName;
    }

    public boolean isCommon() {
        return this.fIsCommon;
    }

    public String getToolName() {
        int n = this.fToolNames.length;
        return n == 0 ? null : this.fToolNames[n - 1];
    }

    public String getToolSetName() {
        int n = this.fToolSetNames.length;
        return n == 0 ? null : this.fToolSetNames[n - 1];
    }

    boolean isToolOnPath(String string, String string2) {
        for (int i = 0; i < this.fToolNames.length; ++i) {
            if (!string.equals(this.fToolNames[i]) || !string2.equals(this.fToolSetNames[i])) continue;
            return true;
        }
        return false;
    }

    int getAncestorCount() {
        return this.fToolSetNames.length - 1;
    }

    String getAncestorTool(int n) {
        return n >= this.getAncestorCount() ? null : this.fToolNames[n];
    }

    String getAncestorToolSet(int n) {
        return n >= this.getAncestorCount() ? null : this.fToolSetNames[n];
    }

    public boolean equals(Object object) {
        if (!(object instanceof TSToolPath)) {
            return false;
        }
        TSToolPath tSToolPath = (TSToolPath)object;
        return this.getToolName() != null && this.getToolName().equals(tSToolPath.getToolName()) && (this.fIsCommon && tSToolPath.fIsCommon || this.getToolSetName() != null && this.getToolSetName().equals(tSToolPath.getToolSetName()));
    }

    public int hashCode() {
        if (this.getToolName() == null) {
            return 0;
        }
        int n = this.getToolName().hashCode();
        if (!this.fIsCommon && this.getToolSetName() != null) {
            n = 37 * n + this.getToolSetName().hashCode();
        }
        return n;
    }

    public boolean isIdentical(Object object) {
        if (!(object instanceof TSToolPath)) {
            return false;
        }
        TSToolPath tSToolPath = (TSToolPath)object;
        return (this.fContextName == tSToolPath.fContextName || this.fContextName != null && this.fContextName.equals(tSToolPath.fContextName)) && this.fTabName.equals(tSToolPath.fTabName) && this.fSectionName.equals(tSToolPath.fSectionName) && Arrays.deepEquals(this.fToolNames, tSToolPath.fToolNames) && Arrays.deepEquals(this.fToolSetNames, tSToolPath.fToolSetNames);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fContextName != null) {
            stringBuilder.append(this.fContextName);
            stringBuilder.append(':');
        }
        stringBuilder.append(this.fTabName);
        stringBuilder.append("->");
        stringBuilder.append(this.fSectionName);
        stringBuilder.append("->");
        for (int i = 0; i < this.fToolNames.length; ++i) {
            stringBuilder.append(this.fToolSetNames[i]);
            stringBuilder.append(':');
            stringBuilder.append(this.fToolNames[i]);
            if (i >= this.fToolNames.length - 1) continue;
            stringBuilder.append("->");
        }
        return stringBuilder.toString();
    }
}

