/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.desktop.client.Client;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.impl.ToolstripSectionComponentWithHeader;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.plaf.PanelUI;

public class SectionWithHeaderUI
extends PanelUI {
    private static final int LEFT_GAP = 4;
    private static final int RIGHT_GAP = 4;
    private static final int SEPARATOR_WIDTH = 1;
    private static final int HEADER_HEIGHT;
    private static final int TOP_GAP;
    private static final int BOTTOM_GAP;
    private static final Color HEADER_TEXT_COLOR;
    private static final Font HEADER_FONT;

    @Override
    public void installUI(JComponent jComponent) {
        jComponent.setLayout(new SectionWithHeaderLayout());
        jComponent.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = jComponent.getSize();
        int n2 = HEADER_HEIGHT;
        int n3 = dimension.width;
        int n4 = dimension.height - n2;
        LAFUtil.drawSectionHeaderBackground(graphics2D, 0, n4, n3, n2);
        graphics2D.setColor(HEADER_TEXT_COLOR);
        ToolstripSectionComponentWithHeader toolstripSectionComponentWithHeader = (ToolstripSectionComponentWithHeader)jComponent;
        graphics2D.setFont(HEADER_FONT);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = (String)toolstripSectionComponentWithHeader.getSection().getAttribute(ToolstripSection.ALTERNATE_TITLE);
        if (string == null) {
            string = ((String)toolstripSectionComponentWithHeader.getSection().getAttribute(Client.TITLE)).trim().toUpperCase();
            int n5 = fontMetrics.stringWidth(string);
            n = (n3 - n5) / 2;
        } else {
            int n6;
            int n7 = fontMetrics.stringWidth(string);
            if (n7 < (n6 = n3 - 4 - 4)) {
                n = 4 + (n6 - n7) / 2;
            } else {
                n = 4;
                string = new SimpleStringTrimmer().shortenString(string, fontMetrics, n6);
            }
        }
        LAFUtil.drawString(graphics2D, string, n, n4 + n2 / 2 + fontMetrics.getHeight() / 4);
        LAFUtil.drawSectionBorder(graphics2D, jComponent, n3 - 1, 0, dimension.height);
        graphics2D.dispose();
    }

    public int getTotalSectionWidth(int n) {
        return SectionWithHeaderUI._getTotalSectionWidth(n);
    }

    public int getSectionExtraHeight() {
        return TOP_GAP + BOTTOM_GAP + HEADER_HEIGHT;
    }

    private static int _getTotalSectionWidth(int n) {
        return 4 + n + 4 + 1;
    }

    public static SectionWithHeaderUI createUI(JComponent jComponent) {
        return new SectionWithHeaderUI();
    }

    static {
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        HEADER_HEIGHT = toolstripTheme.getToolstripHeight() - toolstripTheme.getToolstripTotalContentHeight();
        int n = toolstripTheme.getToolstripTotalContentHeight() - toolstripTheme.getToolstripControlContentHeight();
        TOP_GAP = n / 2;
        BOTTOM_GAP = n - TOP_GAP;
        HEADER_TEXT_COLOR = toolstripTheme.getSectionTitleColor();
        HEADER_FONT = toolstripTheme.getSectionTitleFont();
    }

    public static class SectionWithHeaderLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            if (container.getComponentCount() > 0) {
                Component component = container.getComponent(0);
                n = component.getPreferredSize().width;
            }
            int n2 = SectionWithHeaderUI._getTotalSectionWidth(n);
            return new Dimension(n2, container.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            if (n > 0) {
                Component component = container.getComponent(0);
                Dimension dimension = container.getSize();
                int n2 = dimension.width - 1 - 4 - 4;
                int n3 = dimension.height - HEADER_HEIGHT - TOP_GAP - BOTTOM_GAP;
                component.setBounds(4, TOP_GAP, n2, n3);
            }
        }
    }
}

