/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.ResizableIcon;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.DropDownButtonModel;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSToggleButton;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.TSComponentUI;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;

public abstract class ToolstripButtonUI
extends BasicButtonUI
implements TSComponentUI {
    public static final String POPUP_OVERLAY_PROP = "popup.overlay";
    public static final String BUTTON_SELECTED_BY_KEY = "BUTTON_SELECTED_BY_KEY";
    protected ToolstripTheme fTheme = ToolstripTheme.getInstance();
    public static final int TRIANGLE_WIDTH = 7;
    public static final int TRIANGLE_HEIGHT = 4;
    public static final int BIG_TRIANGLE_WIDTH = 9;
    public static final int BIG_TRIANGLE_HEIGHT = 5;
    public static final int LEFT_GAP_H = 4;
    public static final int RIGHT_GAP_H = 4;
    public static final int ICON_TEXT_GAP_H = 4;
    public static final int VERTICAL_GAP_H = 3;
    public static final int SEPARATOR_WIDTH_H = 2;
    public static final int TRIANGLE_TEXT_GAP_H = 6;
    public static final int LEFT_TRIANGLE_GAP_H = 3;
    public static final int RIGHT_TRIANGLE_GAP_H = 2;
    public static final int TOP_GAP_V = 5;
    public static final int BOTTOM_GAP_V = 5;
    public static final int ICON_SIDE_GAP_V = 6;
    public static final int TEXT_SIDE_GAP_V = 4;
    public static final int ICON_SEP_GAP_V = 2;
    public static final int TEXT_SEP_GAP_V = 4;
    public static final int SEP_TEXT_GAP_V = 2;
    public static final int BIG_ICON_HEIGHT = 30;
    public static final int MIN_WIDTH_V = 50;

    protected ToolstripButtonUI() {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Rectangle rectangle = LAFUtil.getWorkArea(abstractButton);
        Shape shape = graphics2D.getClip();
        TSUtil.setDefaultRenderingHints(graphics2D);
        boolean bl = false;
        Object object = jComponent.getClientProperty(BUTTON_SELECTED_BY_KEY);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (this.isPressed(abstractButton)) {
            this.paintPressed(graphics2D, abstractButton, rectangle);
        } else if (buttonModel.isArmed() || abstractButton.isFocusPainted() && abstractButton.hasFocus() || bl) {
            this.paintArmed(graphics2D, abstractButton, rectangle);
        } else {
            this.paintUnArmed(graphics2D, abstractButton, rectangle);
        }
        if (shape != null) {
            graphics2D.setClip(shape);
        }
        this.paintContent(graphics2D, abstractButton, rectangle);
        graphics2D.dispose();
    }

    protected boolean isPressed(AbstractButton abstractButton) {
        return abstractButton.getModel().isPressed();
    }

    protected void paintPressed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
    }

    protected void paintUnArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
    }

    protected void paintArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
    }

    protected void paintContent(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
    }

    protected static void drawIconWithShadow(Graphics2D graphics2D, AbstractButton abstractButton, Icon icon, int n, int n2) {
        if (icon.getIconHeight() <= 30) {
            ImageIcon imageIcon = ToolstripButtonUI.getShadowIcon(icon);
            imageIcon.paintIcon(abstractButton, graphics2D, n + (icon.getIconWidth() - imageIcon.getIconWidth()) / 2, n2 + icon.getIconHeight() - imageIcon.getIconHeight() / 2);
        }
        icon.paintIcon(abstractButton, graphics2D, n, n2);
    }

    private static ImageIcon getShadowIcon(Icon icon) {
        return Math.abs(icon.getIconHeight() - 16) < 3 ? ToolstripIcons.SHADOW_16.getIcon() : ToolstripIcons.SHADOW_24.getIcon();
    }

    protected static Icon getIcon(AbstractButton abstractButton, boolean bl) {
        Icon icon = abstractButton.getIcon();
        if (icon instanceof ResizableIcon) {
            int n = bl ? 24 : 16;
            ((ResizableIcon)icon).setDimension(n, n);
        }
        return abstractButton.isEnabled() ? icon : (icon == null ? abstractButton.getDisabledIcon() : LAFUtil.getDisabledIcon(abstractButton, icon));
    }

    protected ButtonOrientation getButtonOrientation(AbstractButton abstractButton) {
        if (abstractButton instanceof TSButton) {
            return ((TSButton)((Object)abstractButton)).getOrientation();
        }
        if (abstractButton instanceof TSToggleButton) {
            return ((TSToggleButton)((Object)abstractButton)).getOrientation();
        }
        return ButtonOrientation.HORIZONTAL;
    }

    @Override
    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = GraphicsUtils.getAntialiasingRenderingHints();
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintText((Graphics)graphics2D, jComponent, rectangle, string);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installListeners(jComponent);
        this.installDefaults(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        jComponent.setFont(this.fTheme.getButtonTextFont());
        jComponent.setForeground(this.fTheme.getButtonTextColor());
        jComponent.setOpaque(false);
        jComponent.setBorder(null);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        ToolstripButtonListener toolstripButtonListener = this.newToolstripButtonListener((AbstractButton)jComponent);
        jComponent.addMouseListener(toolstripButtonListener);
        jComponent.addMouseMotionListener(toolstripButtonListener);
        jComponent.addFocusListener(toolstripButtonListener);
        jComponent.addPropertyChangeListener(toolstripButtonListener);
        ((AbstractButton)jComponent).addChangeListener(toolstripButtonListener);
        ((AbstractButton)jComponent).addItemListener(toolstripButtonListener);
        jComponent.addAncestorListener(toolstripButtonListener);
        jComponent.addKeyListener(toolstripButtonListener);
    }

    protected void uninstallListeners(JComponent jComponent) {
        ToolstripButtonListener toolstripButtonListener = this.getButtonListener((AbstractButton)jComponent);
        jComponent.removeMouseListener(toolstripButtonListener);
        jComponent.removeMouseMotionListener(toolstripButtonListener);
        jComponent.removeFocusListener(toolstripButtonListener);
        jComponent.removePropertyChangeListener(toolstripButtonListener);
        ((AbstractButton)jComponent).removeChangeListener(toolstripButtonListener);
        ((AbstractButton)jComponent).removeItemListener(toolstripButtonListener);
        jComponent.removeAncestorListener(toolstripButtonListener);
        jComponent.removeKeyListener(toolstripButtonListener);
    }

    protected abstract ToolstripButtonListener newToolstripButtonListener(AbstractButton var1);

    protected ToolstripButtonListener getButtonListener(AbstractButton abstractButton) {
        MouseListener[] mouseListenerArray = abstractButton.getMouseListeners();
        if (mouseListenerArray != null) {
            for (MouseListener mouseListener : mouseListenerArray) {
                if (!(mouseListener instanceof ToolstripButtonListener)) continue;
                return (ToolstripButtonListener)mouseListener;
            }
        }
        return null;
    }

    public static abstract class ToolstripButtonListener
    implements MouseListener,
    MouseMotionListener,
    FocusListener,
    PropertyChangeListener,
    ChangeListener,
    AncestorListener,
    KeyListener,
    ItemListener {
        protected final AbstractButton fButton;

        protected ToolstripButtonListener(AbstractButton abstractButton) {
            this.fButton = abstractButton;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                TSUtil.clickButton(this.fButton);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        protected void handleSelectionChange(ItemEvent itemEvent) {
            if (this.fButton.getModel() instanceof DropDownButtonModel) {
                final Overlay overlay = (Overlay)this.fButton.getClientProperty(ToolstripButtonUI.POPUP_OVERLAY_PROP);
                if (itemEvent.getStateChange() == 1) {
                    final DropDownButtonModel dropDownButtonModel = (DropDownButtonModel)this.fButton.getModel();
                    if (dropDownButtonModel.getPopupListener() != null) {
                        dropDownButtonModel.getPopupListener().onPopupEvent(this.fButton, new PopupListener.PopupCallback(){

                            @Override
                            public void show(JComponent jComponent) {
                                Disposer.dispose((Disposable)overlay);
                                Overlay overlay2 = ToolstripSections.showPopup(ToolstripButtonListener.this.fButton, jComponent);
                                ToolstripButtonListener.this.fButton.putClientProperty(ToolstripButtonUI.POPUP_OVERLAY_PROP, overlay2);
                                if (overlay2 != null) {
                                    Disposer.register((Disposable)new Disposable(){

                                        public void dispose() {
                                            ToolstripButtonListener.this.fButton.putClientProperty(ToolstripButtonUI.POPUP_OVERLAY_PROP, null);
                                            dropDownButtonModel.setSelected(false);
                                        }
                                    }, (Disposable)overlay2);
                                }
                            }
                        });
                    }
                } else if (overlay != null) {
                    Disposer.dispose((Disposable)overlay);
                }
            }
        }
    }
}

