/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.EmulatorDeviceInquiry;
import com.intel.bluetooth.EmulatorHelper;
import com.intel.bluetooth.EmulatorL2CAPClient;
import com.intel.bluetooth.EmulatorL2CAPService;
import com.intel.bluetooth.EmulatorLinkedConnection;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.EmulatorRFCOMMClient;
import com.intel.bluetooth.EmulatorRFCOMMService;
import com.intel.bluetooth.EmulatorSearchServices;
import com.intel.bluetooth.EmulatorServiceConnection;
import com.intel.bluetooth.NotSupportedIOException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothEmulator
implements BluetoothStack {
    static final int NATIVE_LIBRARY_VERSION = 2010100;
    private EmulatorLocalDevice localDevice;
    private EmulatorDeviceInquiry deviceInquiry;

    BluetoothEmulator() {
    }

    public String getStackID() {
        return "emulator";
    }

    public String toString() {
        if (this.localDevice != null) {
            return this.getStackID() + ":" + RemoteDeviceHelper.getBluetoothAddress((long)this.localDevice.getAddress());
        }
        return this.getStackID();
    }

    public boolean isNativeCodeLoaded() {
        return true;
    }

    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return null;
    }

    public int getLibraryVersion() throws BluetoothStateException {
        return 2010100;
    }

    public int detectBluetoothStack() {
        return 64;
    }

    public void initialize() throws BluetoothStateException {
        this.localDevice = EmulatorHelper.createNewLocalDevice();
    }

    public void destroy() {
        EmulatorHelper.releaseDevice(this.localDevice);
        this.localDevice = null;
    }

    public void enableNativeDebug(Class nativeDebugCallback, boolean on) {
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return Thread.interrupted();
    }

    public int getFeatureSet() {
        return 23;
    }

    private void assertClosed() {
        if (this.localDevice == null) {
            throw new RuntimeException("Device Closed");
        }
    }

    public String getLocalDeviceBluetoothAddress() throws BluetoothStateException {
        this.assertClosed();
        return RemoteDeviceHelper.getBluetoothAddress((long)this.localDevice.getAddress());
    }

    public DeviceClass getLocalDeviceClass() {
        this.assertClosed();
        return new DeviceClass(this.localDevice.getDeviceClass());
    }

    public String getLocalDeviceName() {
        this.assertClosed();
        return this.localDevice.getName();
    }

    public boolean isLocalDevicePowerOn() {
        this.assertClosed();
        return this.localDevice.isLocalDevicePowerOn();
    }

    public String getLocalDeviceProperty(String property) {
        this.assertClosed();
        return this.localDevice.getLocalDeviceProperty(property);
    }

    public int getLocalDeviceDiscoverable() {
        this.assertClosed();
        return this.localDevice.getLocalDeviceDiscoverable();
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        this.assertClosed();
        return this.localDevice.setLocalDeviceDiscoverable(mode);
    }

    private EmulatorLocalDevice activeLocalDevice() throws BluetoothStateException {
        this.assertClosed();
        if (!this.localDevice.isActive()) {
            throw new BluetoothStateException("Bluetooth system is off");
        }
        return this.localDevice;
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
        this.assertClosed();
        this.localDevice.setLocalDeviceServiceClasses(classOfDevice);
    }

    public boolean authenticateRemoteDevice(long address) throws IOException {
        return false;
    }

    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        return false;
    }

    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        if (this.deviceInquiry != null) {
            throw new BluetoothStateException("Another inquiry already running");
        }
        this.deviceInquiry = new EmulatorDeviceInquiry(this.activeLocalDevice(), this, listener);
        return DeviceInquiryThread.startInquiry((BluetoothStack)this, (DeviceInquiryRunnable)this.deviceInquiry, (int)accessCode, (DiscoveryListener)listener);
    }

    public boolean cancelInquiry(DiscoveryListener listener) {
        this.assertClosed();
        if (this.deviceInquiry == null) {
            return false;
        }
        if (this.deviceInquiry.cancelInquiry(listener)) {
            this.deviceInquiry = null;
            return true;
        }
        return false;
    }

    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return this.activeLocalDevice().getDeviceManagerService().getRemoteDeviceFriendlyName(address);
    }

    public RemoteDevice[] retrieveDevices(int option) {
        return null;
    }

    public Boolean isRemoteDeviceTrusted(long address) {
        return null;
    }

    public Boolean isRemoteDeviceAuthenticated(long address) {
        return null;
    }

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return SearchServicesThread.startSearchServices((BluetoothStack)this, (SearchServicesRunnable)new EmulatorSearchServices(this.activeLocalDevice(), this), (int[])attrSet, (UUID[])uuidSet, (RemoteDevice)device, (DiscoveryListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelServiceSearch(int transID) {
        this.assertClosed();
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread((int)transID);
        if (sst != null) {
            SearchServicesThread searchServicesThread = sst;
            synchronized (searchServicesThread) {
                if (!sst.isTerminated()) {
                    sst.setTerminated();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        if (attrIDs.length > this.localDevice.getBluetooth_sd_attr_retrievable_max()) {
            throw new IllegalArgumentException();
        }
        return EmulatorSearchServices.populateServicesRecordAttributeValues(this.activeLocalDevice(), serviceRecord, attrIDs, RemoteDeviceHelper.getAddress((RemoteDevice)serviceRecord.getHostDevice()), serviceRecord.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        EmulatorRFCOMMClient c = this.activeLocalDevice().createRFCOMMClient(params.address);
        boolean success = false;
        try {
            c.connect(params);
            success = true;
        }
        finally {
            if (!success) {
                this.localDevice.removeConnection(c);
            }
        }
        return c.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRfCloseClientConnection(long handle) throws IOException {
        this.assertClosed();
        if (this.localDevice == null) {
            return;
        }
        EmulatorRFCOMMClient c = (EmulatorRFCOMMClient)this.localDevice.getConnection(handle);
        try {
            c.close();
        }
        finally {
            if (this.localDevice != null) {
                this.localDevice.removeConnection(c);
            }
        }
    }

    public int rfGetSecurityOpt(long handle, int expected) throws IOException {
        this.assertClosed();
        return ((EmulatorLinkedConnection)this.localDevice.getConnection(handle)).getSecurityOpt(expected);
    }

    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        this.assertClosed();
        return ((EmulatorLinkedConnection)this.localDevice.getConnection(handle)).encrypt(address, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        EmulatorRFCOMMService s = this.activeLocalDevice().createRFCOMMService();
        boolean success = false;
        try {
            s.open(params);
            serviceRecord.setHandle(s.getHandle());
            serviceRecord.populateRFCOMMAttributes(s.getHandle(), s.getChannel(), params.uuid, params.name, params.obex);
            s.updateServiceRecord(serviceRecord);
            success = true;
        }
        finally {
            if (!success) {
                this.localDevice.removeConnection(s);
            }
        }
        return s.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        this.assertClosed();
        if (this.localDevice == null) {
            return;
        }
        EmulatorRFCOMMService s = (EmulatorRFCOMMService)this.localDevice.getConnection(handle);
        try {
            s.close(serviceRecord);
        }
        finally {
            if (this.localDevice != null) {
                this.localDevice.removeConnection(s);
            }
        }
    }

    private void serverUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        EmulatorServiceConnection s;
        try {
            s = (EmulatorServiceConnection)this.activeLocalDevice().getConnection(handle);
        }
        catch (IOException e) {
            throw new ServiceRegistrationException(e.getMessage());
        }
        s.updateServiceRecord(serviceRecord);
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.serverUpdateServiceRecord(handle, serviceRecord, acceptAndOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerAcceptAndOpenRfServerConnection(long handle) throws IOException {
        EmulatorRFCOMMService s = (EmulatorRFCOMMService)this.activeLocalDevice().getConnection(handle);
        if (!this.localDevice.isConnectable()) {
            throw new BluetoothStateException("Local device is not connectable");
        }
        long clientHandle = 0L;
        boolean success = false;
        while (!success) {
            long connectionHandle = s.accept();
            try {
                long remoteAddress = this.localDevice.getDeviceManagerService().getRemoteAddress(this.localDevice.getAddress(), connectionHandle);
                EmulatorRFCOMMClient c = this.localDevice.createRFCOMMClient(remoteAddress);
                c.connect(remoteAddress, connectionHandle);
                this.localDevice.getDeviceManagerService().connectionAccepted(this.localDevice.getAddress(), connectionHandle);
                success = true;
                clientHandle = c.getHandle();
            }
            catch (IOException e) {
                DebugLog.debug((String)"fail to accept connection", (Throwable)e);
            }
            finally {
                if (success) continue;
                this.localDevice.getDeviceManagerService().closeConnection(this.localDevice.getAddress(), connectionHandle);
            }
        }
        return clientHandle;
    }

    public void connectionRfCloseServerConnection(long handle) throws IOException {
        this.connectionRfCloseClientConnection(handle);
    }

    public int connectionRfRead(long handle) throws IOException {
        return ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).read();
    }

    public int connectionRfRead(long handle, byte[] b, int off, int len) throws IOException {
        return ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).read(b, off, len);
    }

    public int connectionRfReadAvailable(long handle) throws IOException {
        return ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).available();
    }

    public void connectionRfWrite(long handle, int b) throws IOException {
        ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).write(b);
    }

    public void connectionRfWrite(long handle, byte[] b, int off, int len) throws IOException {
        ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).write(b, off, len);
    }

    public void connectionRfFlush(long handle) throws IOException {
        ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).flush();
    }

    public long getConnectionRfRemoteAddress(long handle) throws IOException {
        return ((EmulatorRFCOMMClient)this.activeLocalDevice().getConnection(handle)).getRemoteAddress();
    }

    private void validateMTU(int receiveMTU, int transmitMTU) {
        if (receiveMTU > this.localDevice.getBluetooth_l2cap_receiveMTU_max()) {
            throw new IllegalArgumentException("invalid ReceiveMTU value " + receiveMTU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        this.validateMTU(receiveMTU, transmitMTU);
        EmulatorL2CAPClient c = this.activeLocalDevice().createL2CAPClient(params.address);
        boolean success = false;
        try {
            c.connect(params, receiveMTU, transmitMTU);
            success = true;
        }
        finally {
            if (!success) {
                this.localDevice.removeConnection(c);
            }
        }
        return c.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void l2CloseClientConnection(long handle) throws IOException {
        this.assertClosed();
        EmulatorL2CAPClient c = (EmulatorL2CAPClient)this.localDevice.getConnection(handle);
        try {
            c.close();
        }
        finally {
            this.localDevice.removeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        this.validateMTU(receiveMTU, transmitMTU);
        EmulatorL2CAPService s = this.activeLocalDevice().createL2CAPService(params.bluecove_ext_psm);
        boolean success = false;
        try {
            s.open(params, receiveMTU, transmitMTU);
            serviceRecord.setHandle(s.getHandle());
            serviceRecord.populateL2CAPAttributes((int)s.getHandle(), s.getPcm(), params.uuid, params.name);
            s.updateServiceRecord(serviceRecord);
            success = true;
        }
        finally {
            if (!success) {
                this.localDevice.removeConnection(s);
            }
        }
        return s.getHandle();
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.serverUpdateServiceRecord(handle, serviceRecord, acceptAndOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2ServerAcceptAndOpenServerConnection(long handle) throws IOException {
        EmulatorL2CAPService s = (EmulatorL2CAPService)this.activeLocalDevice().getConnection(handle);
        if (!this.localDevice.isConnectable()) {
            throw new BluetoothStateException("Local device is not connectable");
        }
        long clientHandle = 0L;
        boolean success = false;
        while (!success) {
            long connectionHandle = s.accept();
            try {
                long remoteAddress = this.localDevice.getDeviceManagerService().getRemoteAddress(this.localDevice.getAddress(), connectionHandle);
                EmulatorL2CAPClient c = this.localDevice.createL2CAPClient(remoteAddress);
                c.connect(remoteAddress, connectionHandle, s.getReceiveMTU(), s.getTransmitMTU());
                this.localDevice.getDeviceManagerService().connectionAccepted(this.localDevice.getAddress(), connectionHandle);
                success = true;
                clientHandle = c.getHandle();
            }
            catch (IOException e) {
                DebugLog.debug((String)"fail to accept connection", (Throwable)e);
            }
            finally {
                if (success) continue;
                this.localDevice.getDeviceManagerService().closeConnection(this.localDevice.getAddress(), connectionHandle);
            }
        }
        return clientHandle;
    }

    public void l2CloseServerConnection(long handle) throws IOException {
        this.l2CloseClientConnection(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        this.assertClosed();
        EmulatorL2CAPService s = (EmulatorL2CAPService)this.localDevice.getConnection(handle);
        try {
            s.close(serviceRecord);
        }
        finally {
            this.localDevice.removeConnection(s);
        }
    }

    public int l2GetSecurityOpt(long handle, int expected) throws IOException {
        this.assertClosed();
        return ((EmulatorLinkedConnection)this.localDevice.getConnection(handle)).getSecurityOpt(expected);
    }

    public boolean l2Ready(long handle) throws IOException {
        return ((EmulatorL2CAPClient)this.activeLocalDevice().getConnection(handle)).ready();
    }

    public int l2Receive(long handle, byte[] inBuf) throws IOException {
        return ((EmulatorL2CAPClient)this.activeLocalDevice().getConnection(handle)).receive(inBuf);
    }

    public void l2Send(long handle, byte[] data, int transmitMTU) throws IOException {
        ((EmulatorL2CAPClient)this.activeLocalDevice().getConnection(handle)).send(data);
    }

    public int l2GetReceiveMTU(long handle) throws IOException {
        return ((EmulatorL2CAPClient)this.activeLocalDevice().getConnection(handle)).getReceiveMTU();
    }

    public int l2GetTransmitMTU(long handle) throws IOException {
        return ((EmulatorL2CAPClient)this.activeLocalDevice().getConnection(handle)).getTransmitMTU();
    }

    public long l2RemoteAddress(long handle) throws IOException {
        return ((EmulatorL2CAPClient)this.activeLocalDevice().getConnection(handle)).getRemoteAddress();
    }

    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        this.assertClosed();
        return ((EmulatorLinkedConnection)this.localDevice.getConnection(handle)).encrypt(address, on);
    }
}

