/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.fixedpoint;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorMenuID;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuContext;
import com.mathworks.matlab.api.menus.MenuContributor;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.matlab.api.menus.MenuID;
import com.mathworks.toolbox.fixedpoint.FixedPointMenuAction;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import com.mathworks.widgets.menus.DefaultMenuBuilder;
import com.mathworks.widgets.menus.DefaultMenuGroupID;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class FixedPointMenuContributor
implements MenuContributor<Editor> {
    public static final String FIXED_POINT_MENU_NAME = "FixedPointMenu";

    public Class<Editor> getContributionTarget() {
        return Editor.class;
    }

    public void contribute(Editor editor, MenuContext menuContext) {
        if (editor.getLanguage() instanceof MLanguage) {
            new FixedPointMenuContribution(editor, menuContext).contribute();
        }
    }

    public void contributeToContextMenu(Editor editor, MenuBuilder menuBuilder) {
    }

    private static class FixedPointMenuContribution {
        private final MenuContext fContext;
        private final List<FixedPointMenuAction> fFixedPointActions = new ArrayList<FixedPointMenuAction>();

        private FixedPointMenuContribution(Editor editor, MenuContext menuContext) {
            this.fContext = menuContext;
            this.fFixedPointActions.add(FixedPointMenuAction.createFiConstructorAction(editor));
            this.fFixedPointActions.add(FixedPointMenuAction.createFiMathConstructorAction(editor));
            this.fFixedPointActions.add(FixedPointMenuAction.createNumericTypeConstructorAction(editor));
            new SelfRemovingEditorEventListener(editor){

                public void cleanup() {
                    for (FixedPointMenuAction fixedPointMenuAction : FixedPointMenuContribution.this.fFixedPointActions) {
                        fixedPointMenuAction.dispose();
                    }
                }
            };
        }

        private void contribute() {
            FixedPointMenuAction fixedPointMenuAction2;
            DefaultMenuGroupID defaultMenuGroupID = new DefaultMenuGroupID("FiGroup");
            DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(FixedPointMenuAction.BUNDLE.getString("menuName"), FixedPointMenuContributor.FIXED_POINT_MENU_NAME, new MenuGroupID[]{defaultMenuGroupID});
            defaultMenuBuilder.clearContents();
            for (FixedPointMenuAction fixedPointMenuAction2 : this.fFixedPointActions) {
                defaultMenuBuilder.add((MenuGroupID)defaultMenuGroupID, (Action)((Object)fixedPointMenuAction2));
            }
            MenuBuilder menuBuilder = this.fContext.getBuilder((MenuID)EditorMenuID.TOOLS);
            fixedPointMenuAction2 = new DefaultMenuGroupID("fixedpoint");
            menuBuilder.insertNextGroup((MenuGroupID)fixedPointMenuAction2);
            menuBuilder.add((MenuGroupID)fixedPointMenuAction2, (Component)defaultMenuBuilder.getMenu());
        }
    }
}

