/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullToStax;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQItem;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQSequence
implements XQResultSequence {
    private Value value;
    private Configuration config;
    private int position;
    private boolean closed;
    private SaxonXQConnection connection;

    SaxonXQSequence(Value value, Configuration config) {
        this.value = value;
        this.config = config;
    }

    SaxonXQSequence(Value value, Configuration config, SaxonXQConnection connection) {
        this.value = value;
        this.config = config;
        this.connection = connection;
    }

    Value getValue() {
        return this.value;
    }

    Configuration getConfiguration() {
        return this.config;
    }

    public boolean absolute(int itempos) throws XQException {
        try {
            if (itempos > 0) {
                if (itempos <= this.value.getLength()) {
                    this.position = itempos;
                    return true;
                }
                this.position = -1;
                return false;
            }
            if (itempos < 0) {
                if (-itempos <= this.value.getLength()) {
                    this.position = this.value.getLength() + itempos + 1;
                    return true;
                }
                this.position = 0;
                return false;
            }
            this.position = 0;
            return false;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void afterLast() throws XQException {
        this.position = -1;
    }

    public void beforeFirst() throws XQException {
        this.position = 0;
    }

    public void close() throws XQException {
        this.closed = true;
        this.value = null;
    }

    public int count() throws XQException {
        try {
            return this.value.getLength();
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public boolean first() throws XQException {
        try {
            if (this.value.getLength() == 0) {
                this.position = 0;
                return false;
            }
            this.position = 1;
            return true;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public XQItem getItem() throws XQException {
        try {
            return new SaxonXQItem(this.value.itemAt(this.position - 1), this.connection);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public int getPosition() throws XQException {
        try {
            if (this.position >= 0) {
                return this.position;
            }
            return this.value.getLength();
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        return new PullToStax((PullProvider)new PullFromIterator(this.iterateRemainder()));
    }

    public String getSequenceAsString(Properties props) throws XQException {
        StringWriter sw = new StringWriter();
        this.writeSequence(sw, props);
        return sw.toString();
    }

    public boolean isAfterLast() throws XQException {
        return this.position < 0;
    }

    public boolean isBeforeFirst() throws XQException {
        return this.position == 0;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFirst() throws XQException {
        return this.position == 1;
    }

    public boolean isLast() throws XQException {
        try {
            return this.position == this.value.getLength();
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public boolean isOnItem() throws XQException {
        return this.position >= 1;
    }

    public boolean isScrollable() throws XQException {
        return true;
    }

    public boolean last() throws XQException {
        try {
            int n = this.value.getLength();
            if (n == 0) {
                this.position = -1;
                return false;
            }
            this.position = 0;
            return true;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public boolean next() throws XQException {
        try {
            if (this.position == this.value.getLength()) {
                this.position = -1;
                return false;
            }
            ++this.position;
            return true;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public boolean previous() throws XQException {
        --this.position;
        return this.position != 0;
    }

    public boolean relative(int itempos) throws XQException {
        try {
            this.position += itempos;
            if (this.position <= 0) {
                this.position = 0;
                return false;
            }
            if (this.position > this.value.getLength()) {
                this.position = -1;
                return false;
            }
            return true;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequence(OutputStream os, Properties props) throws XQException {
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.config, (OutputStream)os, (Properties)props);
            this.position = -1;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequence(Writer ow, Properties props) throws XQException {
        try {
            PrintWriter pw = ow instanceof PrintWriter ? (PrintWriter)ow : new PrintWriter(ow);
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.config, (Writer)pw, (Properties)props);
            this.position = -1;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequenceToResult(Result result) throws XQException {
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.config, (Result)result, (Properties)new Properties());
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequenceToSAX(ContentHandler saxHandler) throws XQException {
        this.writeSequenceToResult(new SAXResult(saxHandler));
    }

    public String getAtomicValue() throws XQException {
        return this.getCurrentItem().getAtomicValue();
    }

    public boolean getBoolean() throws XQException {
        return this.getCurrentItem().getBoolean();
    }

    public byte getByte() throws XQException {
        return this.getCurrentItem().getByte();
    }

    public double getDouble() throws XQException {
        return this.getCurrentItem().getDouble();
    }

    public float getFloat() throws XQException {
        return this.getCurrentItem().getFloat();
    }

    public int getInt() throws XQException {
        return this.getCurrentItem().getInt();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentItem().getItemAsStream();
    }

    public String getItemAsString(Properties props) throws XQException {
        return this.getCurrentItem().getItemAsString(props);
    }

    public XQItemType getItemType() throws XQException {
        return this.getCurrentItem().getItemType();
    }

    public long getLong() throws XQException {
        return this.getCurrentItem().getLong();
    }

    public Node getNode() throws XQException {
        return this.getCurrentItem().getNode();
    }

    public URI getNodeUri() throws XQException {
        return this.getCurrentItem().getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.getCurrentItem().getObject();
    }

    public short getShort() throws XQException {
        return this.getCurrentItem().getShort();
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getCurrentItem().instanceOf(type);
    }

    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.getCurrentItem().writeItem(os, props);
    }

    public void writeItem(Writer ow, Properties props) throws XQException {
        this.getCurrentItem().writeItem(ow, props);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.getCurrentItem().writeItemToResult(result);
    }

    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.getCurrentItem().writeItemToSAX(saxHandler);
    }

    private SaxonXQItem getCurrentItem() throws XQException {
        if (this.closed) {
            throw new XQException("Sequence is closed");
        }
        if (this.position == 0) {
            throw new XQException("Sequence is positioned before first item");
        }
        if (this.position < 0) {
            throw new XQException("Sequence is positioned after last item");
        }
        try {
            return new SaxonXQItem(this.value.itemAt(this.position - 1), this.connection);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public XQConnection getConnection() {
        return this.connection;
    }

    private SequenceIterator iterateRemainder() throws XQException {
        try {
            if (this.position == 0) {
                return this.value.iterate();
            }
            if (this.position < 0) {
                return EmptyIterator.getInstance();
            }
            return TailIterator.make((SequenceIterator)this.value.iterate(), (int)this.position);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }
}

