/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.accessories;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.client.ClientCollectionListener;
import com.mathworks.desktop.mnemonics.HasMnemonic;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicPath;
import com.mathworks.desktop.mnemonics.Mnemonics;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSToggleButton;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.util.Predicate;
import com.mathworks.util.async.Status;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class QuickAccessToolBar {
    private final Toolstrip fToolstrip;
    private final TSRegistry fRegistry;
    private TSRegistry.Listener fRegistryListener;
    private MJToolBar fToolBar;
    private MnemonicsProvider fMnemonicsProvider;
    private ContextTargetingManager fTargetingManager;
    private QuickAccessConfiguration fConfig;
    private Predicate<TSToolPath> fFilter;
    private QuickAccessConfiguration.ChangeListener fConfigListener;
    private ToolBarPopulator fPopulator;
    private int fGrowthEnd = 2;
    static final Attribute<QuickAccessToolBar> QUICK_ACCESS_TOOLBAR_ATTRIBUTE = new Attribute("QuickAccessToolBar");
    static final String QUICK_ACCESS_TOOLBAR_PROPERTY = "QuickAccessToolBar";

    public QuickAccessToolBar(Toolstrip toolstrip, @NotNull TSRegistry tSRegistry, QuickAccessConfiguration quickAccessConfiguration) {
        this.fToolstrip = toolstrip;
        this.fRegistry = tSRegistry;
        this.setConfiguration(quickAccessConfiguration);
        this.setPopulator(new ToolBarPopulator(){

            @Override
            public void populate(JToolBar jToolBar, QuickAccessConfiguration quickAccessConfiguration, TSRegistry tSRegistry, Toolstrip toolstrip, ContextTargetingManager contextTargetingManager) {
                TSFactory.populate(jToolBar, quickAccessConfiguration, tSRegistry, toolstrip, contextTargetingManager);
            }
        });
        if (this.fToolstrip != null) {
            toolstrip.setAttribute(QUICK_ACCESS_TOOLBAR_ATTRIBUTE, this);
            AttributeChangeListener attributeChangeListener = new AttributeChangeListener(){

                public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
                    if (attributeChangeEvent.getAttribute() == Toolstrip.STATE) {
                        QuickAccessToolBar.this.updateToolBar();
                    }
                }
            };
            this.fToolstrip.addAttributeChangeListener(attributeChangeListener);
            this.fToolstrip.getModel().addClientCollectionListener((ClientCollectionListener)new TabCollectionListener());
        }
        this.fRegistryListener = new TSRegistry.Listener(){

            @Override
            public void registryUpdated(TSRegistry.UpdateEvent updateEvent) {
                QuickAccessToolBar.this.updateToolBar();
            }
        };
        tSRegistry.addCoalescingListener(this.fRegistryListener);
    }

    public void setTargetingManager(ContextTargetingManager contextTargetingManager) {
        this.fTargetingManager = contextTargetingManager;
    }

    public void setFilter(Predicate<TSToolPath> predicate) {
        this.fFilter = predicate;
        this.updateToolBar();
    }

    public void setGrowthEnd(int n) {
        if (n != this.fGrowthEnd) {
            this.fGrowthEnd = n;
            this.updateToolBar();
        }
    }

    public int getGrowthEnd() {
        return this.fGrowthEnd;
    }

    public MJToolBar getComponent() {
        if (this.fToolBar == null) {
            this.fMnemonicsProvider = new MnemonicsProvider(){

                @NotNull
                public Status<Component> select(@NotNull MnemonicPath mnemonicPath) {
                    if (mnemonicPath.isEmpty()) {
                        return new Status.Success();
                    }
                    ((AbstractButton)((Mnemonic)mnemonicPath.getPath().get(0)).getComponent()).doClick();
                    return new Status.Fail();
                }

                @NotNull
                public Mnemonics getMnemonics(@NotNull MnemonicPath mnemonicPath) {
                    if (mnemonicPath.isEmpty()) {
                        ArrayList<Mnemonic> arrayList = new ArrayList<Mnemonic>(QuickAccessToolBar.this.fToolBar.getComponentCount());
                        if (QuickAccessToolBar.this.fToolBar.getWidth() > 0) {
                            for (int i = 0; i < QuickAccessToolBar.this.fToolBar.getComponentCount(); ++i) {
                                Mnemonic mnemonic;
                                Component component = QuickAccessToolBar.this.fToolBar.getComponent(i);
                                if (!(component instanceof TSButton) && !(component instanceof TSToggleButton) || QuickAccessToolBar.this.fToolBar.isOnMoreMenu(component) || !component.isShowing() || (mnemonic = ((HasMnemonic)component).getComponentMnemonic()) == null) continue;
                                arrayList.add(mnemonic);
                            }
                        }
                        return new Mnemonics(arrayList);
                    }
                    return new Mnemonics();
                }

                public Status<Component> cancel(@NotNull MnemonicPath mnemonicPath) {
                    return null;
                }

                public boolean isFocusOwner() {
                    return QuickAccessToolBar.this.fToolBar.isFocusOwner();
                }

                public boolean isDefaultFocusOwner() {
                    return false;
                }
            };
            this.fToolBar = new MJToolBar(){

                public void addNotify() {
                    super.addNotify();
                    MnemonicsManagers.get().register(QuickAccessToolBar.this.fMnemonicsProvider, SwingUtilities.windowForComponent((Component)((Object)this)));
                }

                public void removeNotify() {
                    MnemonicsManagers.get().unRegister(QuickAccessToolBar.this.fMnemonicsProvider, SwingUtilities.windowForComponent((Component)((Object)this)));
                    super.removeNotify();
                }
            };
            this.fToolBar.setName(QUICK_ACCESS_TOOLBAR_PROPERTY);
            this.fToolBar.setOpaque(false);
            this.fToolBar.setFloatable(false);
            this.fToolBar.setBorder(BorderFactory.createEmptyBorder());
            this.fToolBar.putClientProperty((Object)QUICK_ACCESS_TOOLBAR_PROPERTY, (Object)this);
            this.updateToolBar();
        }
        return this.fToolBar;
    }

    public QuickAccessConfiguration getConfiguration() {
        return this.fConfig;
    }

    public void setConfiguration(QuickAccessConfiguration quickAccessConfiguration) {
        if (this.fConfig != quickAccessConfiguration) {
            if (this.fConfig != null) {
                this.fConfig.removeListener(this.fConfigListener);
            }
            this.fConfig = quickAccessConfiguration;
            if (quickAccessConfiguration != null) {
                if (this.fConfigListener == null) {
                    this.fConfigListener = new QuickAccessConfiguration.ChangeListener(){

                        @Override
                        public void configurationChanged(QuickAccessConfiguration.ChangeEvent changeEvent) {
                            if (changeEvent.getType() == QuickAccessConfiguration.ChangeType.LABEL_VISIBILITY) {
                                TSToolPath tSToolPath = changeEvent.getTool().getPath();
                                for (Component component : QuickAccessToolBar.this.fToolBar.getComponents()) {
                                    TSToolPath tSToolPath2;
                                    TSToolPath tSToolPath3 = tSToolPath2 = component instanceof JComponent ? (TSToolPath)((JComponent)component).getClientProperty("tool path") : null;
                                    if (!tSToolPath.equals(tSToolPath2)) continue;
                                    if (component instanceof MJButton) {
                                        MJButton mJButton = (MJButton)component;
                                        if (changeEvent.getTool().isLabelVisible()) {
                                            mJButton.unHideText();
                                        } else {
                                            mJButton.hideText();
                                        }
                                    } else if (component instanceof MJToggleButton) {
                                        MJToggleButton mJToggleButton = (MJToggleButton)component;
                                        if (changeEvent.getTool().isLabelVisible()) {
                                            mJToggleButton.unHideText();
                                        } else {
                                            mJToggleButton.hideText();
                                        }
                                    }
                                    break;
                                }
                            } else {
                                QuickAccessToolBar.this.updateToolBar();
                            }
                        }
                    };
                }
                this.fConfig.addListener(this.fConfigListener);
            }
            this.updateToolBar();
        }
    }

    public void setPopulator(ToolBarPopulator toolBarPopulator) {
        this.fPopulator = toolBarPopulator;
    }

    private void updateToolBar() {
        if (this.fToolBar != null && this.fConfig != null) {
            this.fPopulator.populate((JToolBar)this.fToolBar, this.fFilter == null ? this.fConfig : new QuickAccessConfiguration(this.fConfig, this.fFilter), this.fRegistry, this.fToolstrip, this.fTargetingManager);
            int n = 0;
            for (int i = 0; i < this.fToolBar.getComponentCount(); ++i) {
                Component component = this.fToolBar.getComponent(i);
                if (component instanceof TSButton) {
                    ((TSButton)((Object)component)).setButtonMnemonic(TSUtil.getSequentialMnemonic(n++));
                    continue;
                }
                if (!(component instanceof TSToggleButton)) continue;
                ((TSToggleButton)((Object)component)).setButtonMnemonic(TSUtil.getSequentialMnemonic(n++));
            }
        }
    }

    public void dispose() {
        if (this.fConfig != null) {
            this.fConfig.removeListener(this.fConfigListener);
        }
        if (this.fToolstrip != null) {
            this.fToolstrip.setAttribute(QUICK_ACCESS_TOOLBAR_ATTRIBUTE, null);
        }
        this.fRegistry.removeListener(this.fRegistryListener);
    }

    private class TabCollectionListener
    implements ClientCollectionListener<ToolstripTab>,
    Runnable {
        private boolean iIsUpdatePending;

        private TabCollectionListener() {
        }

        public void clientAdded(ClientCollectionListener.Added<ToolstripTab> added) {
            this.postUpdate();
        }

        public void clientRemoved(ClientCollectionListener.Removed<ToolstripTab> removed) {
            this.postUpdate();
        }

        public void clientMoved(ClientCollectionListener.Moved<ToolstripTab> moved) {
        }

        private void postUpdate() {
            if (!this.iIsUpdatePending) {
                this.iIsUpdatePending = true;
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public void run() {
            QuickAccessToolBar.this.updateToolBar();
            this.iIsUpdatePending = false;
        }
    }

    public static interface ToolBarPopulator {
        public void populate(JToolBar var1, QuickAccessConfiguration var2, TSRegistry var3, Toolstrip var4, ContextTargetingManager var5);
    }
}

