/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.toolstrip.components.TSSlider;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class ToolstripSliderUI
extends BasicSliderUI {
    private static final int TRACK_LABEL_GAP_V = 3;
    private static final int TRACK_LABEL_GAP_H = 2;
    private Rectangle fTitleRect = new Rectangle();
    private final ToolstripTheme fTheme = ToolstripTheme.getInstance();

    public static ComponentUI createUI(JComponent jComponent) {
        return new ToolstripSliderUI((JSlider)jComponent);
    }

    public ToolstripSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        jSlider.setOpaque(false);
        jSlider.setFont(this.fTheme.getSliderLabelFont());
        jSlider.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSlider.setForeground(this.fTheme.getTrackColor0());
        this.focusInsets = new Insets(0, 0, 0, 0);
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        Icon icon = this.getKnobIcon();
        dimension.width = icon.getIconWidth();
        dimension.height = icon.getIconHeight();
        return dimension;
    }

    @Override
    protected int getTickLength() {
        return 10;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (!rectangle.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.slider.hasFocus() && rectangle.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
        this.paintTitle(graphics, jComponent);
    }

    private void paintTitle(Graphics graphics, JComponent jComponent) {
        if (this.isPaintTitle()) {
            FontMetrics fontMetrics = this.getTitleFontMetrics();
            String string = this.getTitle();
            Rectangle rectangle = this.fTitleRect;
            graphics.setFont(fontMetrics.getFont());
            graphics.setColor(this.slider.getForeground());
            if (this.slider.getOrientation() == 0) {
                int n = rectangle.x + (rectangle.width - fontMetrics.stringWidth(string)) / 2;
                int n2 = rectangle.y + fontMetrics.getAscent();
                LAFUtil.drawString(graphics, string, n, n2);
            }
        }
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        this.getKnobIcon().paintIcon(this.slider, graphics, rectangle.x, rectangle.y);
    }

    private Icon getKnobIcon() {
        ImageIcon imageIcon = ToolstripIcons.SLIDER_THUMB.getIcon();
        return this.slider.isEnabled() ? imageIcon : LAFUtil.getDisabledIcon(this.slider, imageIcon);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    public void paintTicks(Graphics graphics) {
        UIManager.getDefaults().put("Slider.tickColor", this.getTickColor());
        super.paintTicks(graphics);
    }

    private Color getTickColor() {
        return this.slider.isEnabled() ? this.fTheme.getTickColor() : this.fTheme.getTickDisabledColor();
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n = rectangle.height / 2 - 1;
            int n2 = rectangle.width;
            graphics.translate(rectangle.x, rectangle.y + n);
            graphics.setColor(this.slider.isEnabled() ? this.fTheme.getTrackColor0() : this.fTheme.getTickDisabledColor());
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.setColor(this.slider.isEnabled() ? this.fTheme.getTrackColor1() : this.fTheme.getTickDisabledColor());
            graphics.drawLine(0, 1, n2 - 1, 1);
            graphics.translate(-rectangle.x, -(rectangle.y + n));
        } else {
            int n = rectangle.width / 2 - 1;
            int n3 = rectangle.height;
            graphics.translate(rectangle.x + n, rectangle.y);
            graphics.setColor(this.slider.isEnabled() ? this.fTheme.getTrackColor0() : this.fTheme.getTickDisabledColor());
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.setColor(this.slider.isEnabled() ? this.fTheme.getTrackColor1() : this.fTheme.getTickDisabledColor());
            graphics.drawLine(1, 0, 1, n3 - 1);
            graphics.translate(-(rectangle.x + n), -rectangle.y);
        }
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 2 * rectangle.height / 3;
        int n3 = (rectangle.height - n2) / 2;
        graphics.drawLine(n, n3, n, n3 + n2 - 1);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 1);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 2 * rectangle.width / 3;
        int n3 = (rectangle.width - n2) / 2;
        graphics.drawLine(n3, n, n3 + n2 - 1, n);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width - 1, n);
    }

    private String getTitle() {
        return ((TSSlider)((Object)this.slider)).getTitle();
    }

    private boolean isPaintTitle() {
        return ((TSSlider)((Object)this.slider)).isPaintTitle() && this.getTitle() != null;
    }

    private Font getTitleFont() {
        return this.fTheme.getSliderTitleFont();
    }

    private FontMetrics getTitleFontMetrics() {
        return FontUtils.getFontMetrics((Font)this.getTitleFont());
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height + this.fTitleRect.height + 2;
        } else {
            dimension = new Dimension(this.getPreferredVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width + 3;
        }
        return dimension;
    }

    @Override
    protected void calculateTrackRect() {
        int n = 0;
        if (this.slider.getOrientation() == 0) {
            n = Math.max(this.thumbRect.height, this.slider.getPaintTicks() ? this.getTickLength() : 0);
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel() + 2;
            }
            if (this.isPaintTitle()) {
                FontMetrics fontMetrics = this.getTitleFontMetrics();
                this.fTitleRect.height = fontMetrics.getHeight();
                n += this.fTitleRect.height;
            } else {
                this.fTitleRect.height = this.slider.getPaintLabels() ? 4 : 0;
            }
            this.fTitleRect.y = this.contentRect.y + (this.contentRect.height - n) / 2;
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.fTitleRect.y + this.fTitleRect.height;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height;
            this.fTitleRect.x = this.trackRect.x;
            this.fTitleRect.width = this.trackRect.width;
        } else {
            n = Math.max(this.thumbRect.width, this.slider.getPaintTicks() ? this.getTickLength() : 0);
            if (ToolstripSliderUI.isLeftToRight(this.slider)) {
                if (this.slider.getPaintLabels()) {
                    n += this.getWidthOfWidestLabel() + 3;
                }
            } else if (this.slider.getPaintLabels()) {
                n -= this.getWidthOfWidestLabel() + 3;
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    private int getWidthOfVerticalTitle() {
        String string = this.getTitle();
        FontMetrics fontMetrics = this.getTitleFontMetrics();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = Math.max(n, fontMetrics.charWidth(string.charAt(i)));
        }
        return n;
    }

    @Override
    protected void calculateTickRect() {
        int n;
        int n2 = n = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height / 2 - n / 2;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = n;
        } else {
            this.tickRect.width = n;
            this.tickRect.x = ToolstripSliderUI.isLeftToRight(this.slider) ? this.trackRect.x + this.trackRect.width / 2 - n / 2 : this.trackRect.x - this.tickRect.width / 2 + n / 2;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
    }

    @Override
    protected void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height + 2;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (ToolstripSliderUI.isLeftToRight(this.slider)) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width + 3;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width - 3;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = ToolstripSliderUI.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }
}

