/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.arrayEditor;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJTable;
import com.mathworks.toolbox.dastudio.arrayEditor.DAArrayEditorInterface;
import com.mathworks.toolbox.dastudio.arrayEditor.DAArrayEditorTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class DAArrayEditor
extends MJFrame {
    int inside;
    private MJTable table;
    private JScrollPane tablePane;
    private DAArrayEditorTableModel model;
    private DAArrayEditorTableModel model2;
    private DAArrayEditorInterface uddInterface;
    private JTextField valueField;
    private JTextField rowSizeField;
    private JTextField colSizeField;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();

    public DAArrayEditor(DAArrayEditorInterface dAArrayEditorInterface) {
        this.uddInterface = dAArrayEditorInterface;
        this.inside = 5;
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[][] stringArray = DAArrayEditor.this.getValues();
                DAArrayEditor.this.uddInterface.saveTableValues(stringArray);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(" Inside Cancel button listener \n");
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.valueField = new JTextField();
        this.valueField.setColumns(10);
        this.valueField.addKeyListener(new KeyHandler());
        JLabel jLabel = new JLabel("Value");
        jLabel.setLabelFor(this.valueField);
        JLabel jLabel2 = new JLabel("Size");
        this.rowSizeField = new JTextField();
        Document document = this.rowSizeField.getDocument();
        class RowSizeListener
        implements DocumentListener {
            RowSizeListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = DAArrayEditor.this.rowSizeField.getText();
                try {
                    int n = Integer.parseInt(string);
                    int n2 = DAArrayEditor.this.table.getRowCount();
                    DAArrayEditorTableModel dAArrayEditorTableModel = (DAArrayEditorTableModel)DAArrayEditor.this.table.getModel();
                    if (n2 < n) {
                        for (int i = 0; i < n - n2; ++i) {
                            dAArrayEditorTableModel.insertRow(dAArrayEditorTableModel.getRowCount(), new Object[]{""});
                        }
                    } else {
                        for (int i = 0; i < n2 - n; ++i) {
                            dAArrayEditorTableModel.removeRow(dAArrayEditorTableModel.getRowCount() - 1);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (DAArrayEditor.this.colSizeField.getText().length() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.insertUpdate(documentEvent);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        }
        document.addDocumentListener(new RowSizeListener());
        this.rowSizeField.setColumns(7);
        jLabel2.setLabelFor(this.rowSizeField);
        JLabel jLabel3 = new JLabel("By");
        this.colSizeField = new JTextField();
        Document document2 = this.colSizeField.getDocument();
        class ColumnSizeListener
        implements DocumentListener {
            ColumnSizeListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = DAArrayEditor.this.colSizeField.getText();
                try {
                    int n = Integer.parseInt(string);
                    int n2 = DAArrayEditor.this.table.getColumnCount();
                    if (n2 < n) {
                        for (int i = 0; i < n - n2; ++i) {
                            DAArrayEditor.this.betterAddColumn((JTable)DAArrayEditor.this.table, " ", new Object[]{""});
                        }
                    } else {
                        for (int i = 0; i < n2 - n; ++i) {
                            DAArrayEditor.this.removeColumnAndData((JTable)DAArrayEditor.this.table, DAArrayEditor.this.table.getColumnCount() - 1);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (DAArrayEditor.this.colSizeField.getText().length() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.insertUpdate(documentEvent);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        }
        document2.addDocumentListener(new ColumnSizeListener());
        this.colSizeField.setColumns(7);
        jLabel3.setLabelFor(this.colSizeField);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.add(this.valueField);
        jPanel2.add(jLabel2);
        jPanel2.add(this.rowSizeField);
        jPanel2.add(jLabel3);
        jPanel2.add(this.colSizeField);
        jPanel2.add(jLabel2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Hello close");
            }
        });
        this.model = new DAArrayEditorTableModel(this.table, 1, 5);
        this.table = new MJTable((TableModel)this.model);
        this.table.setAutoCreateColumnsFromModel(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)this.table, "Center");
        jPanel3.add((Component)jPanel, "South");
        Container container = this.getContentPane();
        container.add(jPanel3);
        this.setSize(600, 400);
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setBounds(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
    }

    public String[][] getValues() {
        int n = this.table.getColumnCount();
        int n2 = this.table.getRowCount();
        String[][] stringArray = new String[n2][n];
        System.out.println("no cols \n" + n);
        System.out.println("no rows \n" + n2);
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                System.out.println("Val is " + this.table.getValueAt(i, j));
                stringArray[i][j] = this.table.getValueAt(i, j).toString();
            }
        }
        return stringArray;
    }

    public void betterAddColumn(JTable jTable, Object object, Object[] objectArray) {
        DAArrayEditorTableModel dAArrayEditorTableModel = (DAArrayEditorTableModel)jTable.getModel();
        TableColumn tableColumn = new TableColumn(dAArrayEditorTableModel.getColumnCount());
        if (jTable.getAutoCreateColumnsFromModel()) {
            throw new IllegalStateException();
        }
        tableColumn.setHeaderValue(object);
        jTable.addColumn(tableColumn);
        dAArrayEditorTableModel.addColumn((Object)object.toString(), objectArray);
    }

    public void emptyTableData() {
        DAArrayEditorTableModel dAArrayEditorTableModel = (DAArrayEditorTableModel)this.table.getModel();
        for (int i = 0; i < dAArrayEditorTableModel.getRowCount(); ++i) {
            dAArrayEditorTableModel.removeRow(dAArrayEditorTableModel.getRowCount() - 1);
        }
    }

    public void populate(double[][] dArray) {
        DAArrayEditorTableModel dAArrayEditorTableModel = (DAArrayEditorTableModel)this.table.getModel();
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0) {
                dAArrayEditorTableModel.insertRow(dAArrayEditorTableModel.getRowCount(), new Object[]{""});
            }
            for (int j = 0; j < dArray[i].length; ++j) {
                this.table.setValueAt((Object)String.valueOf(dArray[i][j]), i, j);
            }
        }
    }

    public void populate(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("Value is %f" + dArray[i]);
            this.table.setValueAt((Object)String.valueOf(dArray[i]), 0, i);
        }
    }

    public void removeColumnAndData(JTable jTable, int n) {
        Serializable serializable;
        DAArrayEditorTableModel dAArrayEditorTableModel = (DAArrayEditorTableModel)jTable.getModel();
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        int n2 = tableColumn.getModelIndex();
        Vector<Vector> vector = dAArrayEditorTableModel.getDataVector();
        Vector vector2 = dAArrayEditorTableModel.getColumnIdentifiers();
        jTable.removeColumn(tableColumn);
        vector2.removeElementAt(n2);
        for (int i = 0; i < vector.size(); ++i) {
            serializable = vector.get(i);
            ((Vector)serializable).removeElementAt(n2);
        }
        dAArrayEditorTableModel.setDataVector(vector, vector2);
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            if (((TableColumn)serializable).getModelIndex() < n2) continue;
            ((TableColumn)serializable).setModelIndex(((TableColumn)serializable).getModelIndex() - 1);
        }
        dAArrayEditorTableModel.fireTableStructureChanged();
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            int n = keyEvent.getModifiers();
            int n2 = keyEvent.getKeyCode();
            boolean bl2 = bl = n2 == 10;
            if (bl) {
                String string = DAArrayEditor.this.valueField.getText();
                System.out.println("Please be right %s" + string);
            }
        }
    }
}

