/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.dastudio.truthtable.ActionTableModel;
import com.mathworks.toolbox.dastudio.truthtable.ActionTablePopupMenu;
import com.mathworks.toolbox.dastudio.truthtable.TruthTableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

class ActionTableEditor
implements ActionListener {
    private int _selectedRow = -1;
    private JPanel editorPanel;
    private MJTable actTbl;
    private ActionTableModel actTblMdl;
    private ActionTablePopupMenu popupMenu;
    private MJButton btnAddRow;
    private MJButton btnDel;
    private MJButton btnCompact;
    private MJButton btnUp;
    private MJButton btnDown;

    public ActionTableEditor() {
        this.actTblMdl = new ActionTableModel();
        this.initializeEditor();
    }

    public ActionTableEditor(int n) {
        this.actTblMdl = new ActionTableModel(n);
        this.initializeEditor();
    }

    public ActionTableEditor(String[][] stringArray) {
        this.actTblMdl = new ActionTableModel(stringArray);
        this.initializeEditor();
    }

    private void initializeEditor() {
        this.editorPanel = new JPanel(new BorderLayout());
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        String string = TruthTableEditor.getMatlabRoot() + "toolbox/shared/dastudio/resources/";
        Insets insets = new Insets(3, 3, 3, 3);
        this.btnAddRow = new MJButton((Icon)new ImageIcon(string + "TTE_addrow.gif"));
        this.btnAddRow.setMargin(insets);
        this.btnAddRow.addActionListener((ActionListener)this);
        this.btnAddRow.setToolTipText("Add a row.");
        this.btnDel = new MJButton((Icon)new ImageIcon(string + "TTE_delete.gif"));
        this.btnDel.setMargin(insets);
        this.btnDel.addActionListener((ActionListener)this);
        this.btnDel.setToolTipText("Delete selected row.");
        this.btnDel.setEnabled(false);
        this.btnCompact = new MJButton((Icon)new ImageIcon(string + "TTE_compact.gif"));
        this.btnCompact.setMargin(insets);
        this.btnCompact.addActionListener((ActionListener)this);
        this.btnCompact.setToolTipText("Make table compact.");
        this.btnUp = new MJButton((Icon)new ImageIcon(string + "TTE_up.gif"));
        this.btnUp.setMargin(insets);
        this.btnUp.addActionListener((ActionListener)this);
        this.btnUp.setToolTipText("Move selected row up.");
        this.btnUp.setEnabled(false);
        this.btnDown = new MJButton((Icon)new ImageIcon(string + "TTE_down.gif"));
        this.btnDown.setMargin(insets);
        this.btnDown.addActionListener((ActionListener)this);
        this.btnDown.setToolTipText("Move selected row down.");
        this.btnDown.setEnabled(false);
        mJToolBar.add((Component)new JLabel(" Action Table: "));
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.btnAddRow);
        mJToolBar.add((Component)this.btnDel);
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.btnUp);
        mJToolBar.add((Component)this.btnDown);
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.btnCompact);
        this.editorPanel.add((Component)mJToolBar, "North");
        this.actTbl = new MJTable((TableModel)this.actTblMdl, this.actTblMdl.getColumnModel());
        this.actTbl.setAutoCreateColumnsFromModel(false);
        this.actTbl.setSelectionMode(0);
        this.actTbl.setAutoResizeMode(0);
        this.actTbl.setRowHeight(60);
        this.actTbl.setPreferredScrollableViewportSize(new Dimension(500, 200));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.actTbl);
        this.editorPanel.add((Component)mJScrollPane, "Center");
        JTableHeader jTableHeader = this.actTbl.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ActionTableEditor.this.stopEditing();
            }
        });
        this.editorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ActionTableEditor.this.stopEditing();
            }
        });
        this.actTbl.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16) {
                    ActionTableEditor.this.clearSelection();
                    int n = ActionTableEditor.this.actTbl.rowAtPoint(mouseEvent.getPoint());
                    int n2 = ActionTableEditor.this.actTbl.columnAtPoint(mouseEvent.getPoint());
                    if (n2 == 0 && n < ActionTableEditor.this.actTbl.getRowCount()) {
                        ActionTableEditor.this.rowSelected(n);
                    } else {
                        ActionTableEditor.this.actTbl.editCellAt(n, n2);
                    }
                }
            }
        });
        this.popupMenu = new ActionTablePopupMenu(this);
    }

    public void stopEditing() {
        if (this.actTbl.isEditing()) {
            this.actTbl.getCellEditor().stopCellEditing();
        }
    }

    public void clearSelection() {
        this.actTbl.clearSelection();
        this.actTbl.setColumnSelectionAllowed(false);
        this.actTbl.setRowSelectionAllowed(false);
        this._selectedRow = -1;
        this.btnDel.setEnabled(false);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
    }

    public void rowSelected(int n) {
        if (n < 0 || n >= this.actTblMdl.getRowCount()) {
            return;
        }
        this.actTbl.setColumnSelectionAllowed(false);
        this.actTbl.setRowSelectionAllowed(true);
        this.actTbl.setRowSelectionInterval(n, n);
        this._selectedRow = n;
        this.btnDel.setEnabled(true);
        if (this._selectedRow > 0) {
            this.btnUp.setEnabled(true);
        } else {
            this.btnUp.setEnabled(false);
        }
        if (this._selectedRow < this.actTblMdl.getRowCount() - 1) {
            this.btnDown.setEnabled(true);
        } else {
            this.btnDown.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        if (actionEvent.getSource() == this.btnDel) {
            if (this._selectedRow >= 0) {
                this.actTblMdl.deleteRow(this._selectedRow);
            }
            this.clearSelection();
        }
        if (actionEvent.getSource() == this.btnAddRow) {
            if (this._selectedRow >= 0) {
                this.actTblMdl.addRow(this._selectedRow);
                this.rowSelected(this._selectedRow + 1);
            } else {
                this.actTblMdl.addRow();
            }
        }
        if (actionEvent.getSource() == this.btnUp) {
            this.actTblMdl.switchRow(this._selectedRow - 1, this._selectedRow);
            this.rowSelected(this._selectedRow - 1);
        }
        if (actionEvent.getSource() == this.btnDown) {
            this.actTblMdl.switchRow(this._selectedRow, this._selectedRow + 1);
            this.rowSelected(this._selectedRow + 1);
        }
        if (actionEvent.getSource() == this.btnCompact) {
            this.actTblMdl.makeCompact();
            this.clearSelection();
        }
    }

    public String[][] getStringArray() {
        return this.actTblMdl.getStringArray();
    }

    public String getCellValue(int n, int n2) {
        return (String)this.actTblMdl.getValueAt(n, n2);
    }

    public JPanel getEditorPanel() {
        return this.editorPanel;
    }

    public MJTable getActionTable() {
        return this.actTbl;
    }

    public ActionTableModel getActionTableModel() {
        return this.actTblMdl;
    }

    public int getSelectedRow() {
        return this._selectedRow;
    }
}

