/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.mwswing.MJTable;
import com.mathworks.toolbox.dastudio.truthtable.ActionTableEditor;
import com.mathworks.toolbox.dastudio.truthtable.ActionTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;

class ActionTablePopupMenu
extends JPopupMenu
implements ActionListener {
    private ActionTableEditor editor;
    private ActionTableModel tm;
    private JTableHeader th;
    private MJTable table;
    private Component src = null;
    private MouseAdapter popupListener;
    private JMenuItem mAddRow;
    private JMenuItem mCopy;
    private JMenuItem mCut;
    private JMenuItem mPaste;
    private JMenuItem mDel;
    private int col;
    private int row;
    private int sRow;
    private Vector cpBuffer;
    private int cpMode;

    ActionTablePopupMenu(ActionTableEditor actionTableEditor) {
        this.editor = actionTableEditor;
        this.table = this.editor.getActionTable();
        this.tm = this.editor.getActionTableModel();
        this.th = this.table.getTableHeader();
        this.cpBuffer = new Vector();
        this.cpMode = -1;
        this.mAddRow = new JMenuItem("Add Row");
        this.mAddRow.addActionListener(this);
        this.add(this.mAddRow);
        this.addSeparator();
        this.mCopy = new JMenuItem("Copy");
        this.mCopy.addActionListener(this);
        this.add(this.mCopy);
        this.mCut = new JMenuItem("Cut");
        this.mCut.addActionListener(this);
        this.add(this.mCut);
        this.mPaste = new JMenuItem("Paste");
        this.mPaste.addActionListener(this);
        this.mPaste.setEnabled(false);
        this.add(this.mPaste);
        this.addSeparator();
        this.mDel = new JMenuItem("Delete");
        this.mDel.addActionListener(this);
        this.add(this.mDel);
        this.popupListener = new PopupListener();
        this.table.addMouseListener((MouseListener)this.popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem == this.mAddRow) {
            this.doAddRow();
        }
        if (jMenuItem == this.mDel) {
            this.doDelete();
        }
        if (jMenuItem == this.mCopy) {
            this.doCopy();
        }
        if (jMenuItem == this.mPaste) {
            this.doPaste();
        }
        if (jMenuItem == this.mCut) {
            this.doCopy();
            this.doDelete();
        }
    }

    private void doDelete() {
        if (this.sRow < 0) {
            this.tm.setValueAt(null, this.row, this.col);
            this.tm.fireTableCellUpdated(this.row, this.col);
        } else {
            this.tm.deleteRow(this.sRow);
        }
        this.editor.clearSelection();
    }

    private void doCopy() {
        this.cpBuffer.removeAllElements();
        if (this.sRow >= 0) {
            this.cpMode = 0;
            this.cpBuffer = this.tm.getRowData(this.sRow);
        } else {
            this.cpMode = 1;
            this.cpBuffer.addElement(this.tm.getValueAt(this.row, this.col));
        }
    }

    private void doPaste() {
        if (this.cpMode == 0) {
            if (this.row != this.sRow) {
                this.tm.addRow(this.row);
            }
            this.tm.setRow(this.cpBuffer, this.row);
            this.editor.clearSelection();
        } else {
            this.tm.setValueAt(this.cpBuffer.elementAt(0), this.row, this.col);
            this.tm.fireTableCellUpdated(this.row, this.col);
        }
    }

    private void doAddRow() {
        this.tm.addRow(this.row);
        if (this.sRow >= this.row) {
            this.editor.rowSelected(this.sRow + 1);
        } else if (this.sRow >= 0) {
            this.editor.rowSelected(this.sRow);
        }
    }

    private void setCopyCutDeleteContext(String string, int n, int n2) {
        this.mCopy.setText("Copy " + string);
        this.mCut.setText("Cut " + string);
        this.mDel.setText("Delete " + string);
        if (n == n2) {
            this.mCopy.setEnabled(true);
            this.mCut.setEnabled(true);
            this.mDel.setEnabled(true);
        } else {
            this.mCopy.setEnabled(false);
            this.mCut.setEnabled(false);
            this.mDel.setEnabled(false);
        }
    }

    private void setPasteContext(String string, int n, int n2) {
        this.mPaste.setText("Paste " + string);
        if (n == n2) {
            this.mPaste.setEnabled(true);
        } else {
            this.mPaste.setEnabled(false);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ActionTablePopupMenu.this.editor.stopEditing();
                ActionTablePopupMenu.this.src = mouseEvent.getComponent();
                ActionTablePopupMenu.this.sRow = ActionTablePopupMenu.this.editor.getSelectedRow();
                if (ActionTablePopupMenu.this.src == ActionTablePopupMenu.this.table) {
                    ActionTablePopupMenu.this.col = ActionTablePopupMenu.this.table.columnAtPoint(mouseEvent.getPoint());
                    ActionTablePopupMenu.this.row = ActionTablePopupMenu.this.table.rowAtPoint(mouseEvent.getPoint());
                    if (ActionTablePopupMenu.this.row != ActionTablePopupMenu.this.sRow) {
                        ActionTablePopupMenu.this.editor.clearSelection();
                        ActionTablePopupMenu.this.sRow = -1;
                    }
                    if (ActionTablePopupMenu.this.col == 0 || ActionTablePopupMenu.this.sRow == ActionTablePopupMenu.this.row) {
                        ActionTablePopupMenu.this.setCopyCutDeleteContext("row", ActionTablePopupMenu.this.row, ActionTablePopupMenu.this.sRow);
                        ActionTablePopupMenu.this.setPasteContext("row", ActionTablePopupMenu.this.cpMode, 0);
                    } else if (ActionTablePopupMenu.this.col > 0) {
                        ActionTablePopupMenu.this.setCopyCutDeleteContext("cell", 1, 1);
                        ActionTablePopupMenu.this.setPasteContext("cell", ActionTablePopupMenu.this.cpMode, 1);
                    }
                } else {
                    return;
                }
                ActionTablePopupMenu.this.show(ActionTablePopupMenu.this.src, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

