/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.datamgr.brushing;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.page.plottool.plotbrowser.ChartObjectProxyFactory;
import com.mathworks.page.plottool.plotbrowser.LegendIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class AxesDragRecogniser {
    public static int IMAGE_ROWCOUNT = 10;
    public static int IMAGE_COLUMNCOUNT = 20;
    private static DragImageWindow fDragImageWindow = null;
    private static DragTextWindow fDragTextWindow = null;
    private static DragSourceListener sDragSourceListener = null;
    private static DragSourceAdapter sDragSourceMotionListener = null;
    private static boolean fVariableDrag = false;
    public static LegendIcon sIcon = null;
    private static Rectangle fSourceBounds;
    private static Point fSourceOrigin;
    private static final String resStr = "com.mathworks.page.datamgr.resources.RES_LinkedPlots";
    private static final String key = "AxesDragRecogniser.";
    private static ResourceBundle resources;

    public static VariableDragImage createVariableDragImage(String string, Color color) {
        return new VariableDragImage(string, color);
    }

    public static void dragGestureRecognized(final Component component, final Object object, final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AxesDragRecogniser.utdragGestureRecognized(component, object, string);
            }
        });
    }

    private static void utdragGestureRecognized(Component component, Object object, String string) {
        Object object2;
        Point point = MouseInfo.getPointerInfo().getLocation();
        fSourceBounds = component.getBounds();
        fSourceOrigin = component.getLocationOnScreen();
        if (object instanceof ChartObjectProxyFactory.SeriesProxy) {
            fVariableDrag = false;
            if (fDragTextWindow != null) {
                fDragTextWindow.setVisible(false);
            }
            object2 = (ChartObjectProxyFactory.SeriesProxy)object;
            if (fDragImageWindow == null) {
                fDragImageWindow = new DragImageWindow((ChartObjectProxyFactory.SeriesProxy)object2);
                fDragImageWindow.setLocation(point);
            } else {
                fDragImageWindow.setSeriesProxy((ChartObjectProxyFactory.SeriesProxy)object2);
            }
            fDragImageWindow.drag();
        } else if (object instanceof VariableDragImage) {
            fVariableDrag = true;
            if (fDragImageWindow != null) {
                fDragImageWindow.setVisible(false);
            }
            object2 = (VariableDragImage)object;
            if (fDragTextWindow == null) {
                fDragTextWindow = new DragTextWindow((VariableDragImage)object2);
                fDragTextWindow.setLocation(point);
            } else {
                fDragTextWindow.setVarImage((VariableDragImage)object2);
            }
            fDragTextWindow.drag();
        }
        object2 = DragSource.getDefaultDragSource();
        if (sDragSourceListener == null) {
            sDragSourceListener = new DragSourceAdapter((DragSource)object2){
                final /* synthetic */ DragSource val$ds;
                {
                    this.val$ds = dragSource;
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                    if (fDragImageWindow != null) {
                        fDragImageWindow.setVisible(false);
                    }
                    if (fDragTextWindow != null) {
                        fDragTextWindow.setVisible(false);
                    }
                    this.val$ds.removeDragSourceListener(sDragSourceListener);
                    this.val$ds.removeDragSourceMotionListener(sDragSourceMotionListener);
                }
            };
        }
        if (sDragSourceMotionListener == null) {
            sDragSourceMotionListener = new DragSourceAdapter(){

                @Override
                public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
                    boolean bl;
                    Point point = dragSourceDragEvent.getLocation();
                    boolean bl2 = bl = point.x >= fSourceOrigin.x && point.x <= fSourceOrigin.x + fSourceBounds.width && point.y >= fSourceOrigin.y && point.y <= fSourceOrigin.y + fSourceBounds.height;
                    if (dragSourceDragEvent.getTargetActions() != 0 || bl) {
                        if (fDragImageWindow != null && !fVariableDrag) {
                            fDragImageWindow.drag();
                        }
                        if (fDragTextWindow != null && fVariableDrag) {
                            fDragTextWindow.drag();
                        }
                        dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                    } else {
                        if (fDragImageWindow != null) {
                            fDragImageWindow.setVisible(false);
                        }
                        if (fDragTextWindow != null) {
                            fDragTextWindow.setVisible(false);
                        }
                        dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                    }
                }
            };
        }
        ((DragSource)object2).addDragSourceListener(sDragSourceListener);
        ((DragSource)object2).addDragSourceMotionListener(sDragSourceMotionListener);
        MouseEvent mouseEvent = new MouseEvent(component, 506, new Date().getTime(), 1024, point.x, point.y, 0, false);
        Vector<MouseEvent> vector = new Vector<MouseEvent>();
        vector.add(mouseEvent);
        DragGestureRecognizer dragGestureRecognizer = ((DragSource)object2).createDefaultDragGestureRecognizer(component, 2, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            }
        });
        LocDragGestureEvent locDragGestureEvent = new LocDragGestureEvent(dragGestureRecognizer, point, component, vector);
        try {
            locDragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new BufferedImage(1, 1, 1), new Point(0, 0), new StringSelection(string), null);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    static {
        resources = ResourceBundle.getBundle(resStr);
    }

    private static class VariableDragImage {
        private String fVarString;
        private Color fColor;

        public VariableDragImage(String string, Color color) {
            this.fVarString = string;
            this.fColor = color;
        }

        public Color getColor() {
            return this.fColor;
        }

        public String getVarName() {
            return this.fVarString;
        }
    }

    private static class DragTextWindow
    extends DragWindow {
        public DragTextWindow(VariableDragImage variableDragImage) {
            this.setVarImage(variableDragImage);
        }

        public void setVarImage(VariableDragImage variableDragImage) {
            this.fLabel.setText(variableDragImage.getVarName());
            this.fLabel.setForeground(variableDragImage.getColor());
            this.pack();
        }
    }

    private static class DragImageWindow
    extends DragWindow {
        private LegendIcon fIcon = new LegendIcon();

        public DragImageWindow(ChartObjectProxyFactory.SeriesProxy seriesProxy) {
            this.fIcon.setSeriesProxy(seriesProxy);
            this.fLabel.setText(resources.getString("AxesDragRecogniser.DragMsg"));
            this.fLabel.setFont(this.fLabel.getFont().deriveFont(2));
            this.getContentPane().add((Component)this.fLabel, "Center");
            this.getContentPane().add((Component)((Object)this.fIcon), "West");
            this.fIcon.setBackground(Color.white);
            this.pack();
        }

        public void setSeriesProxy(ChartObjectProxyFactory.SeriesProxy seriesProxy) {
            this.fIcon.setSeriesProxy(seriesProxy);
        }
    }

    private static class DragWindow
    extends JWindow {
        protected JLabel fLabel = new MJLabel();

        DragWindow() {
            this.fLabel.setBackground(Color.white);
            this.getContentPane().add((Component)this.fLabel, "Center");
            this.getContentPane().setBackground(Color.white);
            this.setBackground(Color.white);
        }

        public void drag() {
            this.setVisible(true);
            Point point = MouseInfo.getPointerInfo().getLocation();
            point.x += 20;
            point.y += 20;
            this.setLocation(point);
            this.repaint();
        }
    }

    private static class LocDragGestureEvent
    extends DragGestureEvent {
        Component fComponent;
        Point fPt;

        public LocDragGestureEvent(DragGestureRecognizer dragGestureRecognizer, Point point, Component component, Vector<MouseEvent> vector) {
            super(dragGestureRecognizer, 2, point, vector);
            this.fComponent = component;
            this.fPt = point;
        }

        @Override
        public InputEvent getTriggerEvent() {
            return new MouseEvent(this.fComponent, 503, new Date().getTime(), 1024, this.fPt.x, this.fPt.y, 0, false);
        }
    }
}

