/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlwidgets.graphics.PlotArgDescriptor;
import com.mathworks.mlwidgets.graphics.PlotMetadata;
import com.mathworks.mlwidgets.graphics.PlotSignature;
import com.mathworks.mlwidgets.graphics.PlotTypeCombo;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceModel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.plotbrowser.PlotBrowserResources;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class AddDataPanel
extends MJPanel {
    protected PlotSignature fCurrentPlotType;
    protected final MJPanel fDataPanel;
    protected volatile Matlab fMatlab;
    protected static volatile AddDataPanel SINGLETON = null;
    private MatlabListener plotExpressionsLsnr = new MatlabListener(){

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() != 0) {
                ErrorHandler.showMatlabError("AddDataPanel.plotExpressions", matlabEvent, AddDataPanel.this.fMatlab);
            }
        }
    };
    private final Map fReusablePanels = new HashMap();

    public static synchronized AddDataPanel getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new AddDataPanel();
        }
        return SINGLETON;
    }

    public static synchronized void showInstance(Object object, Component component) {
        final Object object2 = object;
        final Component component2 = component;
        if (SwingUtilities.isEventDispatchThread()) {
            AddDataPanel addDataPanel = AddDataPanel.getInstance();
            addDataPanel.showDialog(object2, component2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddDataPanel addDataPanel = AddDataPanel.getInstance();
                    addDataPanel.showDialog(object2, component2);
                }
            });
        }
    }

    public int showDialog(Object object, Component component) {
        final Object object2 = object;
        MJButton mJButton = new MJButton(PlotBrowserResources.getBundle().getString("adddata.dialog.button.ok"));
        mJButton.setName("adddata.dialog.button.ok");
        MJButton mJButton2 = new MJButton(PlotBrowserResources.getBundle().getString("adddata.dialog.button.cancel"));
        mJButton2.setName("adddata.dialog.button.cancel");
        final MJOptionPane mJOptionPane = new MJOptionPane((Object)this, -1, 0, null, new Object[]{mJButton, mJButton2}, (Object)mJButton);
        final JDialog jDialog = mJOptionPane.createDialog(component, PlotBrowserResources.getBundle().getString("adddata.dialog.title"));
        jDialog.setName("figurepalette.dialog.adddata");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AddDataPanel.this.doPlot(object2);
                }
                catch (DataArgsException dataArgsException) {
                    MJOptionPane.showMessageDialog((Component)jDialog, (Object)dataArgsException.getMessage(), (String)(dataArgsException.getNumBadArgs() == 1 ? PlotBrowserResources.getBundle().getString("adddata.dialog.error.title1") : PlotBrowserResources.getBundle().getString("adddata.dialog.error.titlemany")), (int)0);
                    return;
                }
                catch (Exception exception) {
                    ErrorHandler.showJavaException("AddDataPanel.doPlot", exception);
                    return;
                }
                mJOptionPane.setValue((Object)0);
                jDialog.setVisible(false);
            }
        });
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mJOptionPane.setValue((Object)2);
                jDialog.setVisible(false);
            }
        });
        jDialog.setVisible(true);
        Object object3 = mJOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        return (Integer)object3;
    }

    private AddDataPanel() {
        this.fMatlab = new Matlab();
        this.setLayout(new BorderLayout());
        MJPanel mJPanel = this.createAppearancePanel();
        this.fDataPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fDataPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)mJPanel, "North");
        this.add((Component)this.fDataPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setName("AddDataPanel");
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) > 0L && AddDataPanel.this.isShowing()) {
                    for (DataArgsPanel dataArgsPanel : AddDataPanel.this.fReusablePanels.values()) {
                        dataArgsPanel.restoreSavedExpressions();
                    }
                }
            }
        });
        this.setPlotType(PlotMetadata.getPlotSignature((String)"plot"));
    }

    private MJPanel createAppearancePanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        PlotTypeCombo plotTypeCombo = new PlotTypeCombo();
        plotTypeCombo.setName("PlotType");
        plotTypeCombo.addActionListener(new ActionListener((JComboBox)plotTypeCombo){
            final /* synthetic */ JComboBox val$combo;
            {
                this.val$combo = jComboBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotSignature plotSignature = (PlotSignature)this.val$combo.getSelectedItem();
                AddDataPanel.this.setPlotType(plotSignature);
            }
        });
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)new MJLabel(PlotBrowserResources.getBundle().getString("adddata.dialog.label.plottype")), (Object)"West");
        mJPanel2.add((Component)plotTypeCombo, (Object)"East");
        mJPanel.add((Component)mJPanel2, (Object)"West");
        return mJPanel;
    }

    public void doPlot(Object object) throws DataArgsException, Exception {
        DataArgsPanel dataArgsPanel = this.lookupPanelForPlotType(this.fCurrentPlotType);
        dataArgsPanel.commit();
        String[] stringArray = dataArgsPanel.getExpressionArgs();
        String[] stringArray2 = dataArgsPanel.getDisplayNameArgs();
        String[] stringArray3 = dataArgsPanel.getDataSourceArgs();
        String[] stringArray4 = dataArgsPanel.getExtraArgs();
        String[] stringArray5 = new String[stringArray2.length + stringArray3.length + stringArray4.length];
        System.arraycopy(stringArray4, 0, stringArray5, 0, stringArray4.length);
        System.arraycopy(stringArray2, 0, stringArray5, stringArray4.length, stringArray2.length);
        System.arraycopy(stringArray3, 0, stringArray5, stringArray4.length + stringArray2.length, stringArray3.length);
        Object[] objectArray = new Object[]{"plotExpressions", object, this.fCurrentPlotType.getCommand(), stringArray, stringArray5};
        if (stringArray != null) {
            this.fMatlab.feval("plottoolfunc", objectArray, 0, this.plotExpressionsLsnr);
        }
    }

    public PlotSignature getPlotType() {
        return this.fCurrentPlotType;
    }

    public void setPlotType(PlotSignature plotSignature) {
        this.fCurrentPlotType = plotSignature;
        this.fDataPanel.removeAll();
        DataArgsPanel dataArgsPanel = this.lookupPanelForPlotType(plotSignature);
        this.fDataPanel.add((Component)((Object)dataArgsPanel), (Object)"North");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)AddDataPanel.this));
                if (window != null) {
                    window.pack();
                }
                AddDataPanel.this.fDataPanel.revalidate();
                AddDataPanel.this.fDataPanel.repaint();
            }
        });
    }

    protected DataArgsPanel lookupPanelForPlotType(PlotSignature plotSignature) {
        DataArgsPanel dataArgsPanel = null;
        if (this.fReusablePanels.containsKey(plotSignature)) {
            dataArgsPanel = (DataArgsPanel)((Object)this.fReusablePanels.get(plotSignature));
        } else {
            dataArgsPanel = new DataArgsPanel(plotSignature);
            this.fReusablePanels.put(plotSignature, dataArgsPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 0, 0, 3);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints3.insets = new Insets(3, 0, 0, 0);
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 1;
            MJLabel mJLabel = new MJLabel();
            Font font = mJLabel.getFont();
            Font font2 = font.deriveFont((float)font.getSize() - 2.0f);
            dataArgsPanel.setLayout(new GridBagLayout());
            dataArgsPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
            boolean bl = false;
            Vector<AddDataCombo> vector = new Vector<AddDataCombo>();
            PlotArgDescriptor[] plotArgDescriptorArray = plotSignature.getPrimaryArgs();
            for (int i = 0; i < plotArgDescriptorArray.length; ++i) {
                boolean bl2 = plotArgDescriptorArray[i].getRequired() == PlotArgDescriptor.RequiredType.REQUIRED;
                MJLabel mJLabel2 = new MJLabel(plotArgDescriptorArray[i].getLabel() + ":");
                int[] nArray = plotArgDescriptorArray[i].getNumDimensions();
                Object[] objectArray = this.makeDimsLabels(nArray);
                AddDataCombo addDataCombo = bl2 ? new AddDataCombo(false) : new AddDataCombo(true);
                String string = null;
                switch (nArray.length) {
                    case 1: {
                        string = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.tooltip1"), objectArray);
                        break;
                    }
                    case 2: {
                        string = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.tooltip2"), objectArray);
                        break;
                    }
                    case 3: {
                        string = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.tooltip3"), objectArray);
                    }
                }
                addDataCombo.setToolTipText(string);
                String string2 = bl2 ? PlotBrowserResources.getBundle().getString("adddata.dialog.label.required") : PlotBrowserResources.getBundle().getString("adddata.dialog.label.optional");
                MJLabel mJLabel3 = new MJLabel(string2);
                mJLabel3.setFont(font2);
                addDataCombo.setName(plotArgDescriptorArray[i].getLabel());
                vector.add(addDataCombo);
                dataArgsPanel.registerComboBox(plotArgDescriptorArray[i], (JComboBox)((Object)addDataCombo));
                dataArgsPanel.add((Component)mJLabel2, gridBagConstraints);
                dataArgsPanel.add((Component)((Object)addDataCombo), gridBagConstraints2);
                dataArgsPanel.add((Component)mJLabel3, gridBagConstraints3);
                gridBagConstraints.gridy += 2;
                gridBagConstraints2.gridy += 2;
                gridBagConstraints3.gridy += 2;
                if (!bl2 || bl) continue;
                addDataCombo.requestFocus();
                bl = true;
            }
        }
        return dataArgsPanel;
    }

    private Object[] makeDimsLabels(int[] nArray) {
        Object[] objectArray = new Object[nArray.length];
        block4: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 0: {
                    objectArray[i] = PlotBrowserResources.getBundle().getString("adddata.dialog.label.scalar");
                    continue block4;
                }
                case 1: {
                    objectArray[i] = PlotBrowserResources.getBundle().getString("adddata.dialog.label.vector");
                    continue block4;
                }
                default: {
                    objectArray[i] = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.label.nd"), String.valueOf(nArray[i]));
                }
            }
        }
        return objectArray;
    }

    private static class AutoRecordlistTableModel
    extends RecordlistTableModel {
        public AutoRecordlistTableModel(IRecordlistModel iRecordlistModel) {
            super(iRecordlistModel);
        }

        public int getSize() {
            return super.getSize() + 1;
        }

        public Object getElementAt(int n) {
            return n == 0 ? "auto" : super.getElementAt(n - 1);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n != 0) {
                super.setValueAt(object, n - 1, n2);
            }
        }
    }

    class AddDataCombo
    extends MJComboBox {
        protected int expressionIndex = 0;
        public boolean fShowingVariable = false;
        protected RecordlistTableModel fRLTM = null;

        AddDataCombo(boolean bl) {
            MatlabWorkspaceModel matlabWorkspaceModel = new MatlabWorkspaceModel();
            this.fRLTM = bl ? new AutoRecordlistTableModel((IRecordlistModel)matlabWorkspaceModel) : new RecordlistTableModel((IRecordlistModel)matlabWorkspaceModel);
            this.setModel((ComboBoxModel)this.fRLTM);
            this.setEditable(true);
            this.setPreferredSize(new Dimension(220, this.getPreferredSize().height));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddDataCombo.this.getEditor().setItem(AddDataCombo.this.getSelectedItem());
                }
            });
            this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        // empty if block
                    }
                }
            });
            if (bl) {
                this.setSelectedItem("auto");
            }
        }

        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
            this.getEditor().setItem(object);
        }

        public int getExpressionIndex() {
            return this.expressionIndex;
        }

        public void setExpressionIndex(int n) {
            this.expressionIndex = n;
        }
    }

    private static class DataArgsException
    extends Exception {
        private int fNumBadArgs;

        public DataArgsException(String string) {
            super(string);
        }

        public DataArgsException(String string, int n) {
            super(string);
            this.fNumBadArgs = n;
        }

        public int getNumBadArgs() {
            return this.fNumBadArgs;
        }
    }

    class DataArgsPanel
    extends MJPanel {
        private Vector fArgDescs = new Vector();
        private Vector fComboBoxes = new Vector();
        private Vector fSavedArgs = new Vector();
        private PlotSignature fPlotType;
        private String[] fExpressionArgs;
        private String[] fDisplayNameArgs;
        private String[] fDataSourceArgs;

        public DataArgsPanel(PlotSignature plotSignature) {
            this.fPlotType = plotSignature;
            this.fDisplayNameArgs = new String[2];
            this.fDisplayNameArgs[0] = "DisplayName";
        }

        public void registerComboBox(PlotArgDescriptor plotArgDescriptor, JComboBox jComboBox) {
            this.fArgDescs.add(plotArgDescriptor);
            this.fComboBoxes.add(jComboBox);
            this.fSavedArgs.add(jComboBox.getSelectedItem());
        }

        public void commit() throws DataArgsException, Exception {
            int n;
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            this.fDisplayNameArgs[1] = null;
            this.fSavedArgs.clear();
            Vector<String> vector3 = new Vector<String>();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (n = 0; n < this.fComboBoxes.size(); ++n) {
                PlotArgDescriptor plotArgDescriptor = (PlotArgDescriptor)this.fArgDescs.get(n);
                String string = plotArgDescriptor.getName();
                AddDataCombo addDataCombo = (AddDataCombo)((Object)this.fComboBoxes.get(n));
                String string2 = (String)addDataCombo.getEditor().getItem();
                this.fSavedArgs.add(string2);
                addDataCombo.fShowingVariable = false;
                for (int i = 0; i < addDataCombo.getItemCount(); ++i) {
                    if (!addDataCombo.getItemAt(i).equals(string2)) continue;
                    addDataCombo.fShowingVariable = true;
                }
                if (string2 != null && string2.length() > 0 && !string2.toLowerCase().equals("auto")) {
                    vector.add(string2);
                    vector2.add(string + "DataSource");
                    vector2.add(string2);
                    if (string.equals("X")) {
                        bl3 = true;
                    } else if (string.equals("Y")) {
                        bl4 = true;
                    }
                } else if (plotArgDescriptor.getRequired() == PlotArgDescriptor.RequiredType.REQUIRED) {
                    vector3.add(plotArgDescriptor.getLabel());
                }
                if (plotArgDescriptor.getRequired() == PlotArgDescriptor.RequiredType.REQUIRED && this.fDisplayNameArgs[1] == null && !this.fPlotType.getCommand().equals("scatter")) {
                    this.fDisplayNameArgs[1] = string2;
                }
                if (plotArgDescriptor.getRequired() != PlotArgDescriptor.RequiredType.OPTIONAL) continue;
                if (string.equals("X")) {
                    bl = true;
                    continue;
                }
                if (!string.equals("Y")) continue;
                bl2 = true;
            }
            if (vector3.size() > 0) {
                String string = null;
                switch (vector3.size()) {
                    case 1: {
                        string = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.error.required1"), vector3.get(0));
                        break;
                    }
                    case 2: {
                        string = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.error.required2"), vector3.get(0), vector3.get(1));
                        break;
                    }
                    case 3: {
                        string = MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.error.required3"), vector3.get(0), vector3.get(1), vector3.get(2));
                        break;
                    }
                    default: {
                        string = PlotBrowserResources.getBundle().getString("adddata.dialog.error.requiredmany");
                    }
                }
                throw new DataArgsException(string, vector3.size());
            }
            if (bl && bl2 && (bl3 && !bl4 || !bl3 && bl4)) {
                throw new DataArgsException(PlotBrowserResources.getBundle().getString("adddata.dialog.error.invaliddata"));
            }
            if (this.isXY(this.fPlotType.getCommand()) && vector.size() >= 2) {
                this.fDisplayNameArgs[1] = PlotMetadata.isIndependent((String)((String)vector.get(0))) ? (String)vector.get(1) : (PlotMetadata.isIndependent((String)((String)vector.get(1))) ? (String)vector.get(0) : MessageFormat.format(PlotBrowserResources.getBundle().getString("adddata.dialog.displayname.vs"), (String)vector.get(1), (String)vector.get(0)));
            }
            this.fExpressionArgs = new String[vector.size()];
            for (n = 0; n < this.fExpressionArgs.length; ++n) {
                this.fExpressionArgs[n] = (String)vector.get(n);
            }
            this.fDataSourceArgs = new String[vector2.size()];
            for (n = 0; n < this.fDataSourceArgs.length; ++n) {
                this.fDataSourceArgs[n] = (String)vector2.get(n);
            }
        }

        private boolean isXY(String string) {
            String[] stringArray = new String[]{"plot", "semilogx", "semilogy", "loglog", "area", "comet", "errorbar", "stem", "stairs", "bar", "barh", "scatter", "polar", "ezplot", "ezpolar"};
            if (string == null || stringArray.length == 0) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
            return false;
        }

        public String[] getExpressionArgs() {
            return this.fExpressionArgs;
        }

        public String[] getDataSourceArgs() {
            return this.fPlotType.isUsingDisplayName() ? this.fDataSourceArgs : new String[]{};
        }

        public String[] getDisplayNameArgs() {
            return this.fPlotType.isUsingDisplayName() ? this.fDisplayNameArgs : new String[]{};
        }

        public String[] getExtraArgs() {
            String[] stringArray = this.fPlotType.getExtraFlags();
            return stringArray != null ? stringArray : new String[]{};
        }

        protected void restoreSavedExpressions() {
            for (int i = 0; i < this.fComboBoxes.size(); ++i) {
                AddDataCombo addDataCombo = (AddDataCombo)((Object)this.fComboBoxes.get(i));
                if (i >= this.fSavedArgs.size()) continue;
                String string = (String)this.fSavedArgs.get(i);
                if (addDataCombo.fShowingVariable) {
                    boolean bl = false;
                    for (int j = 0; j < addDataCombo.getItemCount(); ++j) {
                        if (!addDataCombo.getItemAt(j).equals(string)) continue;
                        addDataCombo.setSelectedItem(string);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    addDataCombo.setSelectedItem("");
                    this.fSavedArgs.setElementAt(null, i);
                    continue;
                }
                addDataCombo.setSelectedItem(string);
            }
        }
    }
}

