/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.page.plottool.AbstractPlotTool;
import com.mathworks.page.plottool.AddDataPanel;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.MatlabSelectionEvent;
import com.mathworks.page.plottool.MatlabSelectionListener;
import com.mathworks.page.plottool.SelectionManager;
import com.mathworks.page.plottool.plotbrowser.ChartObjectProxyFactory;
import com.mathworks.page.plottool.plotbrowser.CheckBoxCellRenderer;
import com.mathworks.page.plottool.plotbrowser.IdentifierCellRenderer;
import com.mathworks.page.plottool.plotbrowser.PlotBrowserAction;
import com.mathworks.page.plottool.plotbrowser.PlotBrowserEntry;
import com.mathworks.page.plottool.plotbrowser.PlotBrowserModel;
import com.mathworks.page.plottool.plotbrowser.PlotBrowserResources;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class PlotBrowser
extends AbstractPlotTool {
    private boolean DEBUG_SELECTION_FLAG = false;
    protected Matlab fMatlab;
    protected PlotBrowserModel fModel;
    public DefaultTreeModel fTreeModel;
    protected Hashtable<Object, CachedFigureState> fCachedFigureStates = new Hashtable();
    protected Color fBackground;
    protected MJTable fTable;
    protected MJScrollPane fSP;
    protected MJPanel fBtnPanel;
    protected MJButton fAddDataBtn;
    protected MJPopupMenu fPopupMenu;
    protected PlotBrowserAction[] fBrowserActions;
    protected Vector<String> fVisibleUIPanelClasses = new Vector();
    protected Vector<String> fHiddenAxesUIPanelClasses = new Vector();
    protected static final String NAME = "Plot Browser";
    private boolean fIgnoreAddDelete = false;
    protected String currentActionName;
    protected MatlabListener fBrowserActionLsnr = new MatlabListener(){

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() != 0) {
                ErrorHandler.showMatlabError(PlotBrowser.this.currentActionName, matlabEvent, PlotBrowser.this.fMatlab);
            }
        }
    };
    private ActionListener fAddDataLsnr = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Container container = PlotBrowser.this.getTopLevelAncestor();
            AddDataPanel addDataPanel = AddDataPanel.getInstance();
            addDataPanel.showDialog(PlotBrowser.this.fCurrentlySelectedAxes, container);
        }
    };
    protected Vector<Object> fObjsToSelect = new Vector();
    protected Object fCurrentlySelectedAxes = null;
    protected boolean fForwardEventsToMatlab = true;
    protected boolean fRespondToMatlabEvents = true;
    private MatlabSelectionListener fSelectionLsnr = new MatlabSelectionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectionChanged(MatlabSelectionEvent matlabSelectionEvent) {
            Object object;
            Object object2;
            Object object3;
            Vector vector = matlabSelectionEvent.getSelectedObjs();
            if (vector == null) {
                return;
            }
            if (PlotBrowser.this.DEBUG_SELECTION_FLAG) {
                System.out.println("S  PlotBrowser.fSelectionLsnr:  objs = " + vector.size() + ", fRespondToMatlabEvents = " + PlotBrowser.this.fRespondToMatlabEvents);
            }
            if (!PlotBrowser.this.fRespondToMatlabEvents) {
                PlotBrowser.this.fRespondToMatlabEvents = true;
                return;
            }
            if (PlotBrowser.this.fObjsToSelect.equals(vector)) {
                if (PlotBrowser.this.DEBUG_SELECTION_FLAG) {
                    System.out.println("S     same objs, returning!");
                }
                return;
            }
            if (PlotBrowser.this.fTable == null || PlotBrowser.this.fTable.getSelectionModel() == null) {
                return;
            }
            PlotBrowser.this.fForwardEventsToMatlab = false;
            ListSelectionModel listSelectionModel = PlotBrowser.this.fTable.getSelectionModel();
            int[] nArray = PlotBrowser.this.fTable.getSelectedRows();
            Vector<Integer> vector2 = new Vector<Integer>(nArray.length);
            for (int n : nArray) {
                vector2.add(n);
            }
            ListSelectionModel listSelectionModel2 = listSelectionModel;
            synchronized (listSelectionModel2) {
                object3 = new Vector<Integer>(vector.size());
                for (Object n : vector) {
                    int n2 = PlotBrowser.this.fModel.indexOfChartObject(n);
                    if (vector2.contains(n2)) {
                        vector2.remove(new Integer(n2));
                        continue;
                    }
                    ((Vector)object3).add(n2);
                }
                listSelectionModel.setValueIsAdjusting(true);
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    int n = (Integer)object2.next();
                    listSelectionModel.addSelectionInterval(n, n);
                }
                object2 = vector2.iterator();
                while (object2.hasNext()) {
                    int n = (Integer)object2.next();
                    listSelectionModel.removeSelectionInterval(n, n);
                }
                listSelectionModel.setValueIsAdjusting(false);
            }
            if (PlotBrowser.this.fSelectionMgr != null && (object3 = PlotBrowser.this.fCachedFigureStates.get(object = PlotBrowser.this.fSelectionMgr.getFigureHandle())) != null) {
                object2 = PlotBrowser.this.fTable.getSelectedRows();
                ((CachedFigureState)object3).selectedIndices = object2 != null ? (Object)object2 : new int[0];
            }
            PlotBrowser.this.fForwardEventsToMatlab = true;
        }
    };
    private ListSelectionListener fListLsnr = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CachedFigureState cachedFigureState;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int[] nArray = PlotBrowser.this.fTable.getSelectedRows();
            PlotBrowser.this.fCurrentlySelectedAxes = null;
            int n = 0;
            PlotBrowser.this.fObjsToSelect.clear();
            Object object = nArray;
            int n2 = ((int[])object).length;
            for (int i = 0; i < n2; ++i) {
                int n3 = object[i];
                Object object2 = PlotBrowser.this.fModel.get(n3);
                if (!PlotBrowser.this.fTable.isRowSelected(n3) || !(object2 instanceof ChartObjectProxyFactory.ChartObjectProxy)) continue;
                ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy = (ChartObjectProxyFactory.ChartObjectProxy)object2;
                PlotBrowser.this.fObjsToSelect.addElement(chartObjectProxy.getChartObject());
                if (chartObjectProxy instanceof AxesProxy) {
                    PlotBrowser.this.fCurrentlySelectedAxes = chartObjectProxy.getChartObject();
                    ++n;
                    continue;
                }
                if (!(chartObjectProxy instanceof ChartObjectProxyFactory.SeriesProxy)) continue;
                ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy2 = chartObjectProxy.parent;
                PlotBrowser.this.fAddDataBtn.setEnabled(false);
                PlotBrowser.this.fCurrentlySelectedAxes = chartObjectProxy2 != null && chartObjectProxy2 instanceof AxesProxy ? chartObjectProxy2.getChartObject() : null;
            }
            if (PlotBrowser.this.DEBUG_SELECTION_FLAG) {
                System.out.println("S  PlotBrowser.fListLsnr:  objs = " + PlotBrowser.this.fObjsToSelect.size() + ", adj = " + listSelectionEvent.getValueIsAdjusting() + ", forward = " + PlotBrowser.this.fForwardEventsToMatlab + ", ev = " + listSelectionEvent.getFirstIndex() + "," + listSelectionEvent.getLastIndex());
            }
            if (PlotBrowser.this.fForwardEventsToMatlab) {
                if (PlotBrowser.this.fObjsToSelect.size() > 0) {
                    PlotBrowser.this.fRespondToMatlabEvents = false;
                }
                if (PlotBrowser.this.fSelectionMgr != null) {
                    PlotBrowser.this.fSelectionMgr.selectObjs(PlotBrowser.this.fObjsToSelect);
                }
                PlotBrowser.this.fRespondToMatlabEvents = true;
            }
            if (PlotBrowser.this.fCurrentlySelectedAxes == null || PlotBrowser.this.fObjsToSelect.size() == 0 || n > 1) {
                PlotBrowser.this.fAddDataBtn.setEnabled(false);
            } else {
                PlotBrowser.this.fAddDataBtn.setEnabled(true);
            }
            if (PlotBrowser.this.fSelectionMgr != null && (object = (Object)PlotBrowser.this.fSelectionMgr.getFigureHandle()) != null && (cachedFigureState = PlotBrowser.this.fCachedFigureStates.get(object)) instanceof CachedFigureState) {
                CachedFigureState cachedFigureState2 = cachedFigureState;
                int[] nArray2 = PlotBrowser.this.fTable.getSelectedRows();
                cachedFigureState2.selectedIndices = nArray2 != null ? nArray2 : new int[0];
            }
        }
    };

    public PlotBrowser() {
        this.constructorHelper();
    }

    public PlotBrowser(SimpleElement simpleElement) {
        super(simpleElement);
        this.constructorHelper();
    }

    public PlotBrowser(String string, Desktop desktop) {
        super(string, desktop);
        this.constructorHelper();
    }

    public static Component addAsDesktopClient(final Desktop desktop, final String string) {
        final AtomicReference atomicReference = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread()) {
            return PlotBrowser.utAddAsDesktopClient(desktop, string);
        }
        Runnable runnable = new Runnable(){
            public Object iReturnObj;

            @Override
            public void run() {
                atomicReference.set(PlotBrowser.utAddAsDesktopClient(desktop, string));
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
            return (Component)atomicReference.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Component utAddAsDesktopClient(Desktop desktop, String string) {
        Object object = desktop.getClient(NAME, string);
        if (object == null) {
            object = new PlotBrowser(string, desktop);
            desktop.addClient(object, NAME, false, DTLocation.create((String)"NNE"), false);
        }
        return object;
    }

    private void constructorHelper() {
        MJMenuItem mJMenuItem;
        this.setName(NAME);
        this.setClientName(NAME);
        this.fMatlab = new Matlab();
        this.fAddDataBtn = new MJButton(PlotBrowserResources.getBundle().getString("adddata.button.launch"));
        if (PlatformInfo.getPlatform() != 0) {
            this.fAddDataBtn.setMnemonic(65);
        }
        this.fAddDataBtn.setName("AddDataButton");
        this.fAddDataBtn.setDefaultCapable(false);
        this.fAddDataBtn.addActionListener(this.fAddDataLsnr);
        this.fAddDataBtn.setEnabled(false);
        this.fBrowserActions = new PlotBrowserAction[]{new PlotBrowserAction(PlotBrowserResources.getBundle().getString("action.hide"), this), new PlotBrowserAction(PlotBrowserResources.getBundle().getString("action.show"), this), new PlotBrowserAction(PlotBrowserResources.getBundle().getString("action.delete"), this)};
        this.fPopupMenu = new MJPopupMenu();
        for (int i = 0; i < this.fBrowserActions.length; ++i) {
            mJMenuItem = new MJMenuItem((Action)this.fBrowserActions[i]);
            this.fPopupMenu.add((JMenuItem)mJMenuItem);
            if (i != 1) continue;
            this.fPopupMenu.addSeparator();
        }
        this.fTreeModel = this.createTreeModel();
        this.fModel = new PlotBrowserModel(this);
        this.fTable = new BrowserTable();
        this.setupTable();
        CachedFigureState cachedFigureState = new CachedFigureState();
        cachedFigureState.tableModel = this.fModel;
        cachedFigureState.treeModel = this.fTreeModel;
        cachedFigureState.selectedIndices = new int[0];
        this.fCachedFigureStates.put("no figure", cachedFigureState);
        this.fSP = new MJScrollPane();
        this.fSP.getViewport().add((Component)this.fTable);
        this.fSP.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PlotBrowser.this.fTable.clearSelection();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PlotBrowser.this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PlotBrowser.this.maybeShowPopup(mouseEvent);
            }
        });
        this.fBtnPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fBtnPanel.add((Component)this.fAddDataBtn, (Object)"East");
        this.fBtnPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        this.fSP.setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));
        mJMenuItem = new MJPanel((LayoutManager)new BorderLayout());
        mJMenuItem.add((Component)this.fSP, (Object)"Center");
        mJMenuItem.add((Component)this.fBtnPanel, (Object)"South");
        this.setLayout(new BorderLayout());
        this.add((Component)mJMenuItem, "Center");
        this.setPreferredSize(new Dimension(180, 0));
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setDarkBackground(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.showUIPanels("tsguis_uitspanel");
        this.hideAxesInPanels("tsguis_uitspanel");
    }

    @Override
    protected void plotToolClosed() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.disableAllPlotBrowserListeners();
        } else {
            new MatlabWorker(){

                public Object runOnMatlabThread() {
                    PlotBrowser.this.disableAllPlotBrowserListeners();
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                }
            }.start();
        }
    }

    @Override
    protected void plotToolOpened() {
        final SelectionManager selectionManager = this.fSelectionMgr;
        if (selectionManager == null) {
            return;
        }
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() {
                if (PlotBrowser.ishg2()) {
                    Object object = selectionManager.getFigureHandle();
                    try {
                        Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"enablePlotBrowserListeners", object, true}, (int)0);
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        };
        matlabWorker.start();
    }

    @Override
    protected void respondToNullFigure() {
        CachedFigureState cachedFigureState = this.fCachedFigureStates.get("no figure");
        this.fModel = cachedFigureState.tableModel;
        this.fTreeModel = cachedFigureState.treeModel;
        if (this.fSelectionMgr != null) {
            this.fSelectionMgr.removeMatlabSelectionListener(this.fSelectionLsnr);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotBrowser.this.fAddDataBtn.setEnabled(false);
                PlotBrowser.this.fTable.setModel((TableModel)PlotBrowser.this.fModel);
                PlotBrowser.this.revalidate();
            }
        });
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.disableAllPlotBrowserListeners();
        } else {
            new MatlabWorker(){

                public Object runOnMatlabThread() {
                    PlotBrowser.this.disableAllPlotBrowserListeners();
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                }
            }.start();
        }
    }

    private static boolean ishg2() {
        assert (NativeMatlab.nativeIsMatlabThread());
        try {
            boolean[] blArray = (boolean[])Matlab.mtFeval((String)"graphicsversion", (Object[])new Object[]{"handlegraphics"}, (int)1);
            return !blArray[0];
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void disableAllPlotBrowserListeners() {
        if (PlotBrowser.ishg2()) {
            Enumeration<Object> enumeration = this.fCachedFigureStates.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (object instanceof String) continue;
                try {
                    Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"enablePlotBrowserListeners", object, false}, (int)0);
                }
                catch (Exception exception) {
                    Log.log((String)exception.toString());
                }
            }
        }
    }

    @Override
    protected void respondToDifferentFigure() {
        final SelectionManager selectionManager = this.fSelectionMgr;
        if (selectionManager == null) {
            return;
        }
        Object object = selectionManager.getFigureHandle();
        CachedFigureState cachedFigureState = this.fCachedFigureStates.get(object);
        if (cachedFigureState != null) {
            if (PlotBrowser.ishg2()) {
                this.disableAllPlotBrowserListeners();
                try {
                    Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"enablePlotBrowserListeners", object, true}, (int)0);
                }
                catch (Exception exception) {
                    Log.log((String)exception.toString());
                }
            }
            this.fModel = cachedFigureState.tableModel;
            this.fTreeModel = cachedFigureState.treeModel;
            final int[] nArray = cachedFigureState.selectedIndices;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotBrowser.this.fForwardEventsToMatlab = false;
                    PlotBrowser.this.fTable.setModel((TableModel)PlotBrowser.this.fModel);
                    ListSelectionModel listSelectionModel = PlotBrowser.this.fTable.getSelectionModel();
                    listSelectionModel.setValueIsAdjusting(true);
                    listSelectionModel.clearSelection();
                    for (int n : nArray) {
                        listSelectionModel.addSelectionInterval(n, n);
                    }
                    listSelectionModel.setValueIsAdjusting(false);
                    PlotBrowser.this.fForwardEventsToMatlab = true;
                    PlotBrowser.this.revalidate();
                    selectionManager.addMatlabSelectionListener(PlotBrowser.this.fSelectionLsnr);
                }
            });
        } else {
            this.fModel = new PlotBrowserModel(this);
            this.fTreeModel = this.createTreeModel();
            CachedFigureState cachedFigureState2 = new CachedFigureState();
            cachedFigureState2.tableModel = this.fModel;
            cachedFigureState2.treeModel = this.fTreeModel;
            this.fCachedFigureStates.put(object, cachedFigureState2);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.fTreeModel.getRoot();
            defaultMutableTreeNode.setUserObject(object);
            try {
                Matlab.mtFeval((String)"setupplotbrowser", (Object[])new Object[]{this.fFigure, this}, (int)0);
            }
            catch (Exception exception) {
                ErrorHandler.showJavaException("setupplotbrowser", exception);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotBrowser.this.fForwardEventsToMatlab = false;
                    PlotBrowser.this.fTable.setModel((TableModel)PlotBrowser.this.fModel);
                    PlotBrowser.this.fForwardEventsToMatlab = true;
                    PlotBrowser.this.revalidate();
                    selectionManager.addMatlabSelectionListener(PlotBrowser.this.fSelectionLsnr);
                }
            });
        }
    }

    public void showUIPanels(String string) {
        if (!this.fVisibleUIPanelClasses.contains(string)) {
            this.fVisibleUIPanelClasses.add(string);
        }
    }

    public void hideAxesInPanels(String string) {
        if (!this.fHiddenAxesUIPanelClasses.contains(string)) {
            this.fHiddenAxesUIPanelClasses.add(string);
        }
    }

    public void discardPanelHidingInfo() {
        this.fHiddenAxesUIPanelClasses.clear();
        this.fVisibleUIPanelClasses.clear();
        this.showUIPanels("tsguis_uitspanel");
        this.hideAxesInPanels("tsguis_uitspanel");
    }

    public Object[] getSelectedMatlabObjects() {
        int[] nArray;
        Vector<Object> vector = new Vector<Object>();
        for (int n : nArray = this.fTable.getSelectedRows()) {
            BrowserItem browserItem = (BrowserItem)this.fTable.getValueAt(n, 1);
            if (!(browserItem instanceof ChartObjectProxyFactory.ChartObjectProxy)) continue;
            vector.add(((ChartObjectProxyFactory.ChartObjectProxy)browserItem).getChartObject());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setSelectedObjects(Object[] objectArray) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fTable.clearSelection();
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            BrowserItem browserItem = (BrowserItem)this.fTable.getValueAt(i, 1);
            if (!(browserItem instanceof ChartObjectProxyFactory.ChartObjectProxy) || objectArray == null) continue;
            Object object = ((ChartObjectProxyFactory.ChartObjectProxy)browserItem).getChartObject();
            for (Object object2 : objectArray) {
                if (!object2.equals(object)) continue;
                this.fTable.addRowSelectionInterval(i, i);
            }
        }
    }

    private void deleteSelectedObjects() {
        Object object = this.fSelectionMgr.getFigureHandle();
        this.fMatlab.feval("plottoolfunc", new Object[]{"deleteObjects", object}, 0, this.fBrowserActionLsnr);
    }

    public void setVisible(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setVisible(bl);
        } else {
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotBrowser.super.setVisible(bl2);
                }
            });
        }
    }

    public void setAddDataButtonVisible(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fAddDataBtn.setVisible(bl);
        } else {
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotBrowser.this.fAddDataBtn.setVisible(bl2);
                }
            });
        }
    }

    public void turnOffAddDeleteListeners() {
        this.fIgnoreAddDelete = true;
    }

    public void setDarkBackground(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.innerSetDarkBackground(bl);
        } else {
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotBrowser.this.innerSetDarkBackground(bl2);
                }
            });
        }
    }

    private void innerSetDarkBackground(boolean bl) {
        if (bl) {
            this.fBackground = Color.black;
            this.fTable.setForeground(Color.white);
            this.fTable.setSelectionBackground(Color.white);
            this.fTable.setSelectionForeground(Color.black);
        } else {
            this.fBackground = UIManager.getColor("List.background");
            this.fTable.setForeground(UIManager.getColor("List.foreground"));
            this.fTable.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
            this.fTable.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        }
        this.fTable.setBackground(this.fBackground);
        this.fSP.setBackground(this.fBackground);
        this.fSP.getViewport().setBackground(this.fBackground);
        this.fBtnPanel.setBackground(this.fBackground);
    }

    public Color getBackground() {
        return this.fBackground;
    }

    public Vector getEntries() {
        Vector<String> vector = new Vector<String>(this.fModel.getRowCount());
        for (int i = 0; i < this.fModel.getRowCount(); ++i) {
            vector.add(this.fModel.getValueAt(i, 1).toString());
        }
        return vector;
    }

    public boolean getForwardEventsToMatlab() {
        return this.fForwardEventsToMatlab;
    }

    public void setForwardEventsToMatlab(boolean bl) {
        this.fForwardEventsToMatlab = bl;
    }

    public boolean hasProxyAlready(Object object) {
        return this.fModel == null || this.fModel.indexOfChartObject(object) != -1;
    }

    public void addAxesProxy(Object object, Object object2, Object object3) {
        Object object4;
        if (this.fIgnoreAddDelete) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        boolean bl = false;
        Object[] objectArray = new Object[]{object2, "handlegraphics"};
        try {
            object4 = (boolean[])Matlab.mtFeval((String)"graphicsversion", (Object[])objectArray, (int)1);
            if (object4 != null && ((boolean[])object4).length >= 0) {
                bl = !object4[0];
            }
        }
        catch (Exception exception) {
            Log.log((String)exception.toString());
        }
        object4 = this.createAxesProxy((UDDObject)object, (UDDObject)object3, bl);
        this.postAdd((ChartObjectProxyFactory.ChartObjectProxy)object4, defaultMutableTreeNode);
    }

    public void addUIPanelProxy(Object object, Object object2) {
        if (this.fIgnoreAddDelete) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        UIPanelProxy uIPanelProxy = this.createUIPanelProxy((UDDObject)object);
        this.postAdd(uIPanelProxy, defaultMutableTreeNode);
    }

    public void addSeriesProxy_MatlabThread(Object object, Object object2, String string) {
        if (this.fIgnoreAddDelete) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        try {
            ChartObjectProxyFactory.SeriesProxy seriesProxy = ChartObjectProxyFactory.createSeriesProxy(object, string);
            if (seriesProxy != null) {
                this.postAdd(seriesProxy, defaultMutableTreeNode);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void addSeriesProxyArray_MatlabThread(final PlotBrowserEntry[] plotBrowserEntryArray) {
        if (this.fIgnoreAddDelete) {
            return;
        }
        Object object = plotBrowserEntryArray[0].Parent;
        final DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object);
        if (defaultMutableTreeNode == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotBrowser.this.postAddArray_EventThread(plotBrowserEntryArray, defaultMutableTreeNode);
            }
        });
    }

    private void postAdd(final ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy, final DefaultMutableTreeNode defaultMutableTreeNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.postAdd_EventThread(chartObjectProxy, defaultMutableTreeNode);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PlotBrowser.this.postAdd_EventThread(chartObjectProxy, defaultMutableTreeNode);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void postAdd_EventThread(ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy, DefaultMutableTreeNode defaultMutableTreeNode) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.fTable.getSelectedRows();
        this.fTreeModel.insertNodeInto(new DefaultMutableTreeNode(chartObjectProxy), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        int[] nArray2 = this.fTable.getSelectedRows();
        if (nArray.length == 0 && nArray2.length == 1) {
            this.fTable.clearSelection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postAddArray_EventThread(PlotBrowserEntry[] plotBrowserEntryArray, DefaultMutableTreeNode defaultMutableTreeNode) {
        PlotBrowserModel plotBrowserModel = this.fModel;
        synchronized (plotBrowserModel) {
            int[] nArray = this.fTable.getSelectedRows();
            boolean bl = this.fModel.isFireImplicitTableRowsInsertedEvent();
            this.fModel.setFireImplicitTableRowsInsertedEvent(false);
            int n = this.fModel.indexOf(defaultMutableTreeNode.getUserObject());
            int n2 = 0;
            for (PlotBrowserEntry plotBrowserEntry : plotBrowserEntryArray) {
                if (this.findTreeModelNode(plotBrowserEntry.AxesChild, this.fTreeModel) != null) continue;
                plotBrowserEntry.Proxy = ChartObjectProxyFactory.createSeriesProxy(plotBrowserEntry.AxesChild, plotBrowserEntry.NearestClassName);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(plotBrowserEntry.Proxy);
                this.fTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                ++n2;
            }
            this.fModel.setFireImplicitTableRowsInsertedEvent(bl);
            this.fModel.fireTableRowsInserted(n + 1, n + 1 + n2);
            int[] nArray2 = this.fTable.getSelectedRows();
            if (nArray.length == 0 && nArray2.length == 1) {
                this.fTable.clearSelection();
            }
        }
    }

    public void removeProxy(Object object) {
        if (this.fIgnoreAddDelete) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object);
        if (defaultMutableTreeNode != null) {
            PlotBrowser.removeNodeAndChildren(defaultMutableTreeNode, this.fTreeModel);
        }
    }

    public void removeInvalidProxies() {
        this.removeInvalidTreeModelNode((DefaultMutableTreeNode)this.fTreeModel.getRoot(), this.fTreeModel);
    }

    public void clearAll() {
        if (this.fModel != null) {
            this.fModel.clearAll();
        }
        ((DefaultMutableTreeNode)this.fTreeModel.getRoot()).removeAllChildren();
        this.fTable.clearSelection();
    }

    public void updateProperty(final Object object, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PlotBrowser.this.utUpdateProperty(object, string);
                    }
                });
            }
        });
    }

    private void utUpdateProperty(Object object, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object);
        if (defaultMutableTreeNode == null) {
            return;
        }
        ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy = (ChartObjectProxyFactory.ChartObjectProxy)defaultMutableTreeNode.getUserObject();
        if (chartObjectProxy == null || chartObjectProxy.hashCode() == 0) {
            return;
        }
        if (string.equalsIgnoreCase("HandleVisibility")) {
            chartObjectProxy.updateHandleVisibility();
            if (Boolean.FALSE.equals(chartObjectProxy.getHandleVisibility())) {
                this.fModel.removeElementAt(this.fModel.indexOf(chartObjectProxy));
                if (defaultMutableTreeNode.getParent() != null) {
                    this.fTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                }
            }
        } else {
            ChartObjectProxyFactory.updateProperty(chartObjectProxy, string);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotBrowser.this.revalidate();
                PlotBrowser.this.repaint();
            }
        });
    }

    public void updateAxesTitle(Object object, Object object2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object);
        if (defaultMutableTreeNode == null) {
            return;
        }
        ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy = (ChartObjectProxyFactory.ChartObjectProxy)defaultMutableTreeNode.getUserObject();
        if (object2 instanceof String[]) {
            chartObjectProxy.setTitleString(((String[])object2)[0]);
        } else if (object2 instanceof String) {
            chartObjectProxy.setTitleString((String)object2);
        } else if (object2 instanceof Character) {
            chartObjectProxy.setTitleString(object2.toString());
        } else if (object2 == null) {
            chartObjectProxy.setTitleString(PlotBrowserResources.getBundle().getString("item.axes.notitle"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotBrowser.this.revalidate();
                PlotBrowser.this.repaint();
            }
        });
    }

    private DefaultTreeModel createTreeModel() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        defaultTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
                int[] nArray = treeModelEvent.getChildIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeModelEvent.getChildren()[i];
                    PlotBrowser.this.fModel.addTreeItem(defaultMutableTreeNode2, defaultMutableTreeNode, n);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                if (PlotBrowser.this.fTreeModel == null || PlotBrowser.this.fModel == null) {
                    return;
                }
                treeModelEvent.getTreePath().getLastPathComponent();
                int[] nArray = treeModelEvent.getChildIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getChildren()[i];
                    PlotBrowser.this.fModel.removeTreeItem(defaultMutableTreeNode);
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        return defaultTreeModel;
    }

    private DefaultMutableTreeNode findTreeModelNode(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeModelNode(object, this.fTreeModel);
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode;
        }
        Enumeration<Object> enumeration = this.fCachedFigureStates.keys();
        while (enumeration.hasMoreElements()) {
            Object object2 = enumeration.nextElement();
            CachedFigureState cachedFigureState = this.fCachedFigureStates.get(object2);
            if (cachedFigureState == null || (defaultMutableTreeNode = this.findTreeModelNode(object, cachedFigureState.treeModel)) == null) continue;
            this.fCachedFigureStates.remove(object2);
            return null;
        }
        return null;
    }

    private static void removeNodeAndChildren(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel) {
        if (defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode.getChildCount() == 0) {
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            arrayList.add((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode2 : arrayList) {
            PlotBrowser.removeNodeAndChildren(defaultMutableTreeNode2, defaultTreeModel);
        }
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    private void removeInvalidTreeModelNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            this.removeInvalidTreeModelNode(defaultMutableTreeNode2, defaultTreeModel);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode3.getUserObject();
            if (object == null || object.hashCode() == 0) {
                arrayList.add(defaultMutableTreeNode3);
                continue;
            }
            if (!(object instanceof ChartObjectProxyFactory.ChartObjectProxy) || ((UDDObject)((ChartObjectProxyFactory.ChartObjectProxy)object).getChartObject()).isValid()) continue;
            arrayList.add(defaultMutableTreeNode3);
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode3 : arrayList) {
            PlotBrowser.removeNodeAndChildren(defaultMutableTreeNode3, defaultTreeModel);
        }
    }

    private DefaultMutableTreeNode findTreeModelNode(Object object, DefaultTreeModel defaultTreeModel) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)defaultTreeModel.getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 == null || object2.hashCode() == 0) {
                return null;
            }
            if (!(object2 instanceof ChartObjectProxyFactory.ChartObjectProxy ? object == ((ChartObjectProxyFactory.ChartObjectProxy)object2).getChartObject() : object2 == object)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public void printTree() {
        System.out.println("TreeModel:");
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.fTreeModel.getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            System.out.println("    node = " + defaultMutableTreeNode.getUserObject());
        }
    }

    public boolean isUIPanelHidden(UIPanelProxy uIPanelProxy) {
        Object object = uIPanelProxy.getChartObject();
        String string = object.getClass().getName();
        for (String string2 : this.fVisibleUIPanelClasses) {
            if (!string.startsWith(string2)) continue;
            return false;
        }
        return true;
    }

    public boolean isChildAxesHidden(UIPanelProxy uIPanelProxy) {
        Object object = uIPanelProxy.getChartObject();
        String string = object.getClass().getName();
        for (String string2 : this.fHiddenAxesUIPanelClasses) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private void setupTable() {
        this.fTable.setName("PlotBrowserTable");
        this.fTable.setSelectionMode(2);
        this.fTable.getSelectionModel().addListSelectionListener(this.fListLsnr);
        this.fTable.setAutoResizeMode(3);
        this.fTable.setAutoCreateColumnsFromModel(false);
        this.fTable.setModel((TableModel)this.fModel);
        this.fTable.setShowGrid(false);
        this.fTable.setTableHeader(null);
        this.fTable.setIntercellSpacing(new Dimension(0, 0));
        this.fTable.setCellViewerEnabled(true);
        this.fTable.setRightSelectionEnabled(true);
        CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer();
        IdentifierCellRenderer identifierCellRenderer = new IdentifierCellRenderer();
        this.fTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)checkBoxCellRenderer);
        this.fTable.setDefaultRenderer(BrowserItem.class, (TableCellRenderer)identifierCellRenderer);
        Component component = this.fTable.getDefaultRenderer(this.fModel.getColumnClass(0)).getTableCellRendererComponent((JTable)this.fTable, Boolean.TRUE, false, false, 0, 0);
        int n = component.getPreferredSize().width;
        TableColumn tableColumn = new TableColumn(0, n, null, null);
        tableColumn.setResizable(false);
        tableColumn.setMaxWidth(n);
        tableColumn.setPreferredWidth(n);
        this.fTable.getColumnModel().addColumn(tableColumn);
        TableColumn tableColumn2 = new TableColumn(1, 50, null, null);
        tableColumn2.setResizable(true);
        tableColumn2.setMinWidth(50);
        this.fTable.getColumnModel().addColumn(tableColumn2);
        this.fTable.setPreferredScrollableViewportSize(new Dimension(50, 50));
        this.doLayout();
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PlotBrowser.this.onDoubleClick(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PlotBrowser.this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PlotBrowser.this.maybeShowPopup(mouseEvent);
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    PlotBrowser.this.deleteSelectedObjects();
                    keyEvent.consume();
                }
            }
        });
    }

    private void onDoubleClick(MouseEvent mouseEvent) {
        int n;
        Object object;
        if (mouseEvent.getClickCount() == 2 && (object = this.fModel.get(n = this.fTable.rowAtPoint(mouseEvent.getPoint()))) instanceof ChartObjectProxyFactory.ChartObjectProxy) {
            final Object object2 = ((ChartObjectProxyFactory.ChartObjectProxy)object).getChartObject();
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    PlotBrowser.this.fMatlab.feval("propedit", new Object[]{object2}, 0, new MatlabListener(){

                        public void matlabEvent(MatlabEvent matlabEvent) {
                            if (matlabEvent.getStatus() != 0) {
                                ErrorHandler.showMatlabError("propedit", matlabEvent, PlotBrowser.this.fMatlab);
                            }
                        }
                    });
                }
            });
        }
    }

    public PlotBrowserAction getHideAction() {
        return this.fBrowserActions[0];
    }

    public PlotBrowserAction getShowAction() {
        return this.fBrowserActions[1];
    }

    public PlotBrowserAction getDeleteAction() {
        return this.fBrowserActions[2];
    }

    public void doAction(String string, Object[] objectArray) {
        this.currentActionName = string;
        if (string.startsWith(PlotBrowserResources.getBundle().getString("action.hide"))) {
            this.fMatlab.feval("plottoolfunc", new Object[]{"setPropertyValue", objectArray, "visible", "off"}, 0, this.fBrowserActionLsnr);
        } else if (string.startsWith(PlotBrowserResources.getBundle().getString("action.show"))) {
            this.fMatlab.feval("plottoolfunc", new Object[]{"setPropertyValue", objectArray, "visible", "on"}, 0, this.fBrowserActionLsnr);
        } else if (string.startsWith(PlotBrowserResources.getBundle().getString("action.delete"))) {
            this.deleteSelectedObjects();
        }
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray = this.fTable.getSelectedRows();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            Object object = this.fModel.get(nArray[i]);
            if (!(object instanceof ChartObjectProxyFactory.ChartObjectProxy)) continue;
            ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy = (ChartObjectProxyFactory.ChartObjectProxy)object;
            objectArray[i] = chartObjectProxy.getChartObject();
            bl3 = true;
            bl = bl || chartObjectProxy.isVisible != false;
            bl2 = bl2 || chartObjectProxy.isVisible == false;
        }
        for (PlotBrowserAction plotBrowserAction : this.fBrowserActions) {
            plotBrowserAction.setMatlabObjects(objectArray);
        }
        this.fBrowserActions[0].setEnabled(bl);
        this.fBrowserActions[1].setEnabled(bl2);
        this.fBrowserActions[2].setEnabled(bl3);
        this.fPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    protected UIPanelProxy createUIPanelProxy(UDDObject uDDObject) {
        if (!NativeMatlab.nativeIsMatlabThread()) {
            throw new Error("unexpected access from other than MATLAB thread");
        }
        UIPanelProxy uIPanelProxy = new UIPanelProxy(uDDObject);
        uIPanelProxy.name = "UIPanel";
        return uIPanelProxy;
    }

    protected AxesProxy createAxesProxy(UDDObject uDDObject, UDDObject uDDObject2, boolean bl) {
        if (!NativeMatlab.nativeIsMatlabThread()) {
            throw new Error("unexpected access from other than MATLAB thread");
        }
        AxesProxy axesProxy = new AxesProxy(uDDObject);
        axesProxy.name = PlotBrowserResources.getBundle().getString("item.axes.notitle");
        if (uDDObject2 != null) {
            String[] stringArray = new String[]{""};
            if (!bl) {
                stringArray = uDDObject2.getPropertyValue("String");
            } else {
                try {
                    Object object = Matlab.mtFeval((String)"get", (Object[])new Object[]{uDDObject2, "String"}, (int)1);
                    if (object instanceof MLArrayRef) {
                        if ((object = ((MLArrayRef)object).getData()) instanceof String) {
                            stringArray = new String[]{(String)object};
                        } else if (object instanceof double[]) {
                            stringArray = new String[]{""};
                        }
                    } else if (object instanceof String) {
                        stringArray = new String[]{(String)object};
                    } else if (object instanceof double[]) {
                        stringArray = new String[]{""};
                    }
                }
                catch (Exception exception) {
                    stringArray = new String[]{""};
                }
            }
            axesProxy.name = this.createAxesProxyName(stringArray);
        }
        return axesProxy;
    }

    private String createAxesProxyName(String[] stringArray) {
        String string = null;
        if (stringArray != null) {
            switch (stringArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    string = stringArray[0];
                    break;
                }
                default: {
                    string = stringArray[0] + " ...";
                }
            }
        }
        if (string == null || string.length() == 0) {
            string = PlotBrowserResources.getBundle().getString("item.axes.notitle");
        }
        return string;
    }

    public static Image createMarkerImage(String string) {
        URL uRL = PlotBrowser.class.getResource("resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon.getImage();
    }

    public class SurfaceProxy
    extends ChartObjectProxyFactory.SurfaceProxy {
        SurfaceProxy(Object object) {
            super(object);
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object == null || object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() == 0) {
                this.faceColor = PlotBrowser.this.getBackground();
            } else if (object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() != -1) {
                this.faceColor = new Color(16, 16, 255);
            } else if (object instanceof HGMeshColor) {
                this.faceColor = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
            }
        }
    }

    public static class PatchProxy
    extends ChartObjectProxyFactory.PatchProxy {
        PatchProxy(Object object) {
            super(object);
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object == null || object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() == 0) {
                this.faceColor = SystemColor.text;
            } else if (object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() != -1) {
                this.faceColor = new Color(16, 16, 255);
            } else if (object instanceof HGMeshColor) {
                this.faceColor = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
            }
        }
    }

    public class AxesProxy
    extends ChartObjectProxyFactory.ChartObjectProxy
    implements ParentProxy {
        private Vector<ChartObjectProxyFactory.ChartObjectProxy> children;

        AxesProxy(Object object) {
            super(object);
        }

        @Override
        public void setTitleString(String string) {
            this.name = string;
        }

        @Override
        public Vector<ChartObjectProxyFactory.ChartObjectProxy> getChildren() {
            return this.children;
        }

        @Override
        public synchronized void addChild(ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy) {
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(chartObjectProxy)) {
                this.children.add(chartObjectProxy);
            }
        }

        @Override
        public synchronized void removeChild(ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy) {
            if (this.children != null && this.children.contains(chartObjectProxy)) {
                this.children.remove(chartObjectProxy);
            }
        }
    }

    public class UIPanelProxy
    extends ChartObjectProxyFactory.ChartObjectProxy
    implements ParentProxy {
        private Vector<ChartObjectProxyFactory.ChartObjectProxy> children;

        UIPanelProxy(Object object) {
            super(object);
        }

        @Override
        public void updateDisplayName() {
            this.name = "UI Panel";
        }

        @Override
        public void updateName() {
            this.name = (String)((UDDObject)this.chartObject).getPropertyValue("Name");
        }

        @Override
        public void updateTitle() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Title");
            if (object instanceof String[]) {
                this.name = ((String[])object).length == 0 ? "UI Panel" : ((String[])object)[0];
            } else if (object instanceof String) {
                this.name = (String)object;
            } else if (object instanceof Character) {
                this.name = object.toString();
            }
        }

        @Override
        public Vector<ChartObjectProxyFactory.ChartObjectProxy> getChildren() {
            return this.children;
        }

        @Override
        public synchronized void addChild(ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy) {
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(chartObjectProxy)) {
                this.children.add(chartObjectProxy);
            }
        }

        @Override
        public synchronized void removeChild(ChartObjectProxyFactory.ChartObjectProxy chartObjectProxy) {
            if (this.children != null && this.children.contains(chartObjectProxy)) {
                this.children.remove(chartObjectProxy);
            }
        }
    }

    static interface ParentProxy {
        public Vector<ChartObjectProxyFactory.ChartObjectProxy> getChildren();

        public void addChild(ChartObjectProxyFactory.ChartObjectProxy var1);

        public void removeChild(ChartObjectProxyFactory.ChartObjectProxy var1);
    }

    public class BrowserSeparator
    extends BrowserItem {
        public String toString() {
            return "---";
        }
    }

    public static class BrowserItem {
    }

    class BrowserTable
    extends MJTable {
        BrowserTable() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            super.tableChanged(tableModelEvent);
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (tableColumnModel.getColumnCount() < 2) {
                return;
            }
            Component component = this.getDefaultRenderer(PlotBrowser.this.fModel.getColumnClass(0)).getTableCellRendererComponent((JTable)PlotBrowser.this.fTable, Boolean.TRUE, false, false, 0, 0);
            int n = component.getPreferredSize().width;
            int n2 = this.widthOfWidestCell();
            tableColumnModel.getColumn(1).setPreferredWidth(this.widthOfWidestCell());
            Dimension dimension = this.getPreferredSize();
            this.setPreferredScrollableViewportSize(new Dimension(n + n2, dimension.height));
            this.doLayout();
            this.revalidate();
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            if (n2 > 0) {
                n2 = 0;
            }
            super.changeSelection(n, n2, bl, bl2);
        }

        public int[] getSelectedColumns() {
            int[] nArray = super.getSelectedColumns();
            if (nArray == null) {
                return nArray;
            }
            if (nArray[0] == 1) {
                nArray[0] = 0;
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int widthOfWidestCell() {
            int n = 0;
            MJTable mJTable = PlotBrowser.this.fTable;
            synchronized (mJTable) {
                for (int i = 0; i < PlotBrowser.this.fTable.getRowCount(); ++i) {
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(0, 1);
                    if (i >= PlotBrowser.this.fModel.getRowCount()) break;
                    Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), PlotBrowser.this.fModel.get(i), false, false, i, 1);
                    int n2 = component.getPreferredSize().width;
                    n = n2 > n ? n2 : n;
                }
            }
            return n;
        }
    }

    static class CachedFigureState {
        PlotBrowserModel tableModel;
        DefaultTreeModel treeModel;
        int[] selectedIndices = new int[0];

        CachedFigureState() {
        }
    }
}

