/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ProjectType;
import com.mathworks.project.impl.model.SaveErrorHandler;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.util.Holder;
import com.mathworks.util.Log;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ProjectGUI {
    private static final ProjectGUI INSTANCE = new ProjectGUI();
    private DTLocation fLastLocation;
    private ProjectClient fCurrentClient;
    private Project fCurrentProject;
    private DeploymentProcess fCurrentProcess;
    private final Map<Class<?>, ProjectClient> fClientsByClass = new HashMap();
    private final Runnable fUiCloseCallback = new Runnable(){

        @Override
        public void run() {
            if (ProjectGUI.this.fCurrentClient != null) {
                ProjectGUI.this.fCurrentClient.projectClosed();
            }
        }
    };

    public static void init() {
        ProjectManager.setSaveErrorHandler(new SaveErrorHandler(){

            @Override
            public void saveFailed(final Project project, final IOException iOException) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Log.logException((Exception)iOException);
                        MJOptionPane.showMessageDialog((Component)(ProjectGUI.getInstance().getCurrentClient() != null ? ProjectGUI.getInstance().getCurrentClient().getComponent() : MLDesktop.getInstance().getMainFrame()), (Object)MessageFormat.format(BuiltInResources.getString("error.savefailed"), project.getConfiguration().getName()), (String)BuiltInResources.getString("error.savefailed.title"), (int)0);
                    }
                });
            }
        });
    }

    public static ProjectGUI getInstance() {
        return INSTANCE;
    }

    public void restoreLastOpenProject() {
        File file = null;
        if (ProjectPrefs.LAST_OPEN_FILE.get() != null) {
            file = new File(ProjectPrefs.LAST_OPEN_FILE.get());
        }
        if (file != null && file.exists()) {
            this.open(file, true);
        } else {
            this.changeClientForTarget(null);
        }
    }

    public ProjectClient getCurrentClient() {
        return this.fCurrentClient;
    }

    public ProjectClient getClient(boolean bl) {
        if (this.fCurrentClient == null) {
            if (bl) {
                this.restoreLastOpenProject();
                return this.fCurrentClient;
            }
            return this.getClientForTarget(null);
        }
        return this.fCurrentClient;
    }

    public Project getCurrentProject() {
        return this.fCurrentProject;
    }

    public DeploymentProcess getCurrentProcess() {
        return this.fCurrentProcess;
    }

    public void setCurrentProcess(DeploymentProcess deploymentProcess) {
        this.fCurrentProcess = deploymentProcess;
    }

    public void open(String string) {
        this.open(new File(string));
    }

    public void open(File file) {
        this.open(file, false);
    }

    public void open(final File file, final boolean bl) {
        if (!this.confirmCloseIfActive()) {
            return;
        }
        final Project project = this.fCurrentProject;
        Target target = ProjectManager.getTarget(file);
        if (target == null) {
            ProjectGUI.showErrorMessageLater("error.badproject", "error.badproject.title", file.getName());
            return;
        }
        this.changeClientForTarget(target);
        Thread thread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        thread.setName("Project load for " + file.getName());
        thread.start();
    }

    public void createAndOpen(File file, ProjectType projectType) {
        this.createAndOpen(file, projectType, null);
    }

    public void createAndOpen(final File file, final ProjectType projectType, final ParameterRunnable<Project> parameterRunnable) {
        if (!this.confirmCloseIfActive()) {
            return;
        }
        final Project project = this.fCurrentProject;
        this.changeClientForTarget(projectType.getTarget());
        this.fCurrentClient.switchToLoadingMode();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                file.getParentFile().mkdirs();
                ProjectGUI.this.fCurrentProject = ProjectManager.closeAndCreate(project, ProjectGUI.this.fUiCloseCallback, file, projectType);
                if (parameterRunnable != null) {
                    parameterRunnable.run((Object)ProjectGUI.this.fCurrentProject);
                }
                ProjectManager.addRecentProject(file);
                ProjectPrefs.LAST_OPEN_FILE.set(file.getAbsolutePath());
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ProjectGUI.this.fCurrentProject != null) {
                            ProjectGUI.this.fCurrentClient.loadingFinished(ProjectGUI.this.fCurrentProject);
                        } else {
                            ProjectGUI.this.fCurrentClient.loadingFailed();
                        }
                    }
                });
            }
        });
        thread.setName("Project creation for " + file);
        thread.start();
    }

    public void showClient() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Desktop desktop = MatlabDesktopServices.getDesktop();
                if (desktop.hasClient(ProjectGUI.this.fCurrentClient.getTitle())) {
                    MatlabDesktopServices.getDesktop().showClient(ProjectGUI.this.fCurrentClient.getTitle());
                } else {
                    DTLocation dTLocation = ProjectGUI.this.fLastLocation != null && ProjectGUI.this.fCurrentClient.getDefaultLocation().isDocked() ? ProjectGUI.this.fLastLocation : ProjectGUI.this.fCurrentClient.getDefaultLocation();
                    desktop.addClient((Component)ProjectGUI.this.fCurrentClient.getComponent(), ProjectGUI.this.fCurrentClient.getTitle(), true, dTLocation, true);
                }
            }
        });
    }

    public boolean isCurrentClient(ProjectClient projectClient) {
        return this.fCurrentClient == projectClient;
    }

    public void closeCurrentProject() {
        if (this.fCurrentProject != null) {
            ProjectManager.close(this.fCurrentProject, false);
            this.fCurrentProject = null;
        }
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProjectGUI.this.fCurrentClient != null) {
                    ProjectGUI.this.fCurrentClient.projectClosed();
                }
            }
        });
    }

    private void changeClientForTarget(final Target target) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectClient projectClient = ProjectGUI.this.getClientForTarget(target);
                if (projectClient != ProjectGUI.this.fCurrentClient) {
                    if (ProjectGUI.this.fCurrentClient != null) {
                        MLDesktop.getInstance().closeClient((Component)ProjectGUI.this.fCurrentClient.getComponent());
                        MLDesktop.getInstance().removeClient((Component)ProjectGUI.this.fCurrentClient.getComponent());
                    }
                    ProjectGUI.this.fCurrentClient = projectClient;
                }
                ProjectGUI.this.showClient();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
        }
    }

    private ProjectClient getClientForTarget(Target target) {
        ProjectClient projectClient;
        Class clazz = BasicProjectClient.class;
        if (target != null && target.getClientClassName() != null) {
            try {
                clazz = Class.forName(target.getClientClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
        if ((projectClient = this.fClientsByClass.get(clazz)) == null) {
            try {
                projectClient = (ProjectClient)clazz.newInstance();
                final Class clazz2 = clazz;
                final ProjectClient projectClient2 = projectClient;
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MatlabDesktopServices.getDesktop().addClientListener((Component)projectClient2.getComponent(), (DTClientListener)new DTClientAdapter(){

                            public void clientClosing(DTClientEvent dTClientEvent) {
                                if (projectClient2.getDefaultLocation() == null || projectClient2.getDefaultLocation().isDocked()) {
                                    ProjectGUI.this.fLastLocation = MatlabDesktopServices.getDesktop().getClientLocation((Component)projectClient2.getComponent());
                                }
                            }

                            public void clientClosed(DTClientEvent dTClientEvent) {
                                1 var2_2 = this;
                                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable((DTClientListener)var2_2){
                                    final /* synthetic */ DTClientListener val$listener;
                                    {
                                        this.val$listener = dTClientListener;
                                    }

                                    @Override
                                    public void run() {
                                        MatlabDesktopServices.getDesktop().removeClientListener((Component)projectClient2.getComponent(), this.val$listener);
                                        ProjectGUI.this.fClientsByClass.remove(clazz2);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException(instantiationException);
            }
            this.fClientsByClass.put(clazz, projectClient);
        }
        return projectClient;
    }

    private boolean confirmConversion(final File file) {
        final Holder holder = new Holder();
        holder.set((Object)2);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    holder.set((Object)Dialogs.showOptionalConfirmDialog((Component)ProjectGUI.this.fCurrentClient.getComponent(), (Object)MessageFormat.format(BuiltInResources.getString("warning.conversion"), file.getName()), (String)BuiltInResources.getString("warning.conversion.title"), (int)2, (int)2, (String)"DeployToolConfirmProjectConversionOnLoad", (int)0, (boolean)true));
                }
            });
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return (Integer)holder.get() == 0;
    }

    private static void showErrorMessageLater(final String string, final String string2, final String ... stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)MLDesktop.getInstance().getMainFrame(), (Object)MessageFormat.format(BuiltInResources.getString(string), stringArray), (String)BuiltInResources.getString(string2), (int)0);
            }
        });
    }

    private static boolean confirmUnsupportedVersion(final File file) {
        final Holder holder = new Holder();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String string = MessageFormat.format(BuiltInResources.getString("warning.unsupportedVersion"), file.getName());
                    Object[] objectArray = new Object[]{BuiltInResources.getString("button.overwrite"), BuiltInResources.getString("button.cancel")};
                    holder.set((Object)JOptionPane.showOptionDialog((Component)MLDesktop.getInstance().getMainFrame(), string, BuiltInResources.getString("warning.unsupportedVersion.title"), -1, 2, null, objectArray, objectArray[1]));
                }
            });
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return (Integer)holder.get() == 0;
    }

    private boolean confirmCloseIfActive() {
        DeploymentProcess deploymentProcess = this.fCurrentProcess;
        if (deploymentProcess == null && WorkflowDialog.getInstance() != null) {
            deploymentProcess = WorkflowDialog.getInstance().getCurrentProcess();
        }
        if (this.fCurrentProject != null && deploymentProcess != null) {
            boolean bl;
            int n = MJOptionPane.showConfirmDialog((Component)this.fCurrentClient.getComponent(), (Object)MessageFormat.format(BuiltInResources.getString("warning.closeproject.active"), this.fCurrentProject.getFile().getName()), (String)BuiltInResources.getString("warning.closeproject.active.title"), (int)2, (int)2);
            boolean bl2 = bl = n == 0;
            if (bl) {
                deploymentProcess.cancel();
            } else if (this.fCurrentClient != null) {
                this.fCurrentClient.loadingFailed();
            }
            return bl;
        }
        return true;
    }

    static /* synthetic */ void access$100(String string, String string2, String[] stringArray) {
        ProjectGUI.showErrorMessageLater(string, string2, stringArray);
    }

    static /* synthetic */ boolean access$200(File file) {
        return ProjectGUI.confirmUnsupportedVersion(file);
    }

    static /* synthetic */ boolean access$300(ProjectGUI projectGUI, File file) {
        return projectGUI.confirmConversion(file);
    }

    static {
        ProjectGUI.init();
    }
}

