/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.explorer.util.PrefUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.ActionGroup;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BuildAction;
import com.mathworks.project.impl.desktop.HelpAction;
import com.mathworks.project.impl.desktop.NewProjectAction;
import com.mathworks.project.impl.desktop.OpenProjectAction;
import com.mathworks.project.impl.desktop.PackageAction;
import com.mathworks.project.impl.desktop.ProjectSettingsAction;
import com.mathworks.project.impl.desktop.ProjectTabbedPane;
import com.mathworks.project.impl.desktop.RenameProjectAction;
import com.mathworks.project.impl.desktop.ToolbarProjectClient;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.ReferenceOptionDialog;
import com.mathworks.project.impl.logui.BuildProgressDialog;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.project.impl.settingsui.NewSettingsDialog;
import com.mathworks.project.impl.settingsui.ProjectSettingsDialog;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

public class BasicProjectClient
extends ToolbarProjectClient {
    private final ProjectTabbedPane fTabs = new ProjectTabbedPane();
    private final MJPanel fTabContainer = new MJPanel((LayoutManager)new BorderLayout(0, 0));
    private final MJMenu fProjectMenu;
    private final MJMenuBar fMenuBar;
    private MJAbstractAction fAddEntityActionMenuAction;
    private BuildProgressDialog fProgressDialog;
    private ActionGroup fAddEntityActions;
    public static final String NAME = "Deploy Tool";
    public static final String TITLE = BuiltInResources.getString("title");

    public BasicProjectClient() {
        this(NAME, TITLE);
    }

    public BasicProjectClient(String string, String string2) {
        super(NAME, TITLE);
        this.fTabContainer.setOpaque(false);
        this.fTabContainer.add((Component)this.fTabs.getComponent());
        this.fMenuBar = new MJMenuBar();
        this.fMenuBar.setName("deploytool.menubar");
        this.fProjectMenu = new MJMenu(BuiltInResources.getString("menu.project"));
        this.fProjectMenu.setName("menu.project");
        this.fMenuBar.add((JMenu)this.fProjectMenu);
        ReturnRunnable<Component> returnRunnable = new ReturnRunnable<Component>(){

            public Component run() {
                return BasicProjectClient.this.fProgressDialog != null && BasicProjectClient.this.fProgressDialog.isShowing() ? BasicProjectClient.this.fProgressDialog : BasicProjectClient.this;
            }
        };
        this.addAction(new NewProjectAction(), false);
        this.addAction(new OpenProjectAction(), false);
        this.addAction(new RenameProjectAction((Component)((Object)this)), false);
        this.addAction(new BuildAction(this), true);
        this.addAction(new PackageAction(this, returnRunnable), true);
        this.addAction(new ProjectSettingsAction(), false);
        this.addAction(new HelpAction((Component)((Object)this)), false);
        this.switchToNoProjectMode();
        this.updateProjectMenu();
        this.setMenuBar((JMenuBar)this.fMenuBar);
        this.setContentPane((Component)this.fTabContainer);
        PrefUtils.manageBackgroundColor((Container)((Object)this));
        DataTransferSupport.installDropToOpenSupport((Component)((Object)this));
        MatlabDesktopServices.getDesktop().addClientListener((Component)((Object)this), (DTClientListener)new DTClientAdapter(){

            public void clientDocking(DTClientEvent dTClientEvent) {
                if (BasicProjectClient.this.fProgressDialog != null) {
                    BasicProjectClient.this.fProgressDialog.notifyDockTransition();
                }
            }

            public void clientUndocking(DTClientEvent dTClientEvent) {
                this.clientDocking(dTClientEvent);
            }

            public void clientDocked(DTClientEvent dTClientEvent) {
                if (BasicProjectClient.this.fProgressDialog != null) {
                    BasicProjectClient.this.fProgressDialog = BasicProjectClient.this.fProgressDialog.reparent((Component)((Object)BasicProjectClient.this));
                    BasicProjectClient.this.fProgressDialog.show();
                }
            }

            public void clientUndocked(DTClientEvent dTClientEvent) {
                this.clientDocked(dTClientEvent);
            }
        });
    }

    public void setInfoComponent(Component component) {
        this.fTabContainer.removeAll();
        if (component == null) {
            this.fTabContainer.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.fTabContainer.add((Component)this.fTabs.getComponent());
        } else {
            this.fTabContainer.setLayout((LayoutManager)new FormLayout("fill:d:grow", "fill:d, fill:d:grow"));
            CellConstraints cellConstraints = new CellConstraints();
            this.fTabContainer.add(component, (Object)cellConstraints.xy(1, 1));
            this.fTabContainer.add((Component)this.fTabs.getComponent(), (Object)cellConstraints.xy(1, 2));
        }
        this.fTabContainer.revalidate();
        this.fTabContainer.repaint();
    }

    public static Component getInstance() {
        return ProjectGUI.getInstance().getClient(true).getComponent();
    }

    public List<FileSetEditor> getFileSetEditors() {
        Project project = this.getProject();
        ArrayList<FileSetEditor> arrayList = new ArrayList<FileSetEditor>();
        for (FileSetDefinition fileSetDefinition : project.getConfiguration().getTarget().getFileSets()) {
            arrayList.add(this.fTabs.getFileSetEditor(fileSetDefinition.getKey()));
        }
        return arrayList;
    }

    @Override
    protected ActionGroup getAddEntityActionGroup() {
        return this.fAddEntityActions;
    }

    @Override
    protected void customizeActionMenu(JPopupMenu jPopupMenu) {
        int n;
        Project project = this.getProject();
        jPopupMenu.removeAll();
        BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("NEW"));
        BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("OPEN"));
        jPopupMenu.addSeparator();
        BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("RENAME_PROJECT"));
        jPopupMenu.addSeparator();
        if (this.fAddEntityActionMenuAction != null) {
            BasicProjectClient.addToActionMenu(jPopupMenu, this.fAddEntityActionMenuAction);
            jPopupMenu.addSeparator();
        }
        if ((n = this.addSpecialFileOptions(jPopupMenu)) > 0) {
            jPopupMenu.addSeparator();
        }
        BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("BUILD"));
        if (this.getAction("PACKAGE").isApplicable(project)) {
            BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("PACKAGE"));
        }
        if (this.getAction("SETTINGS").isApplicable(project)) {
            jPopupMenu.addSeparator();
            BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("SETTINGS"));
        }
        jPopupMenu.addSeparator();
        this.addExtraActions(jPopupMenu);
        BasicProjectClient.addToActionMenu(jPopupMenu, this.getAction("HELP"));
    }

    protected void addExtraActions(JPopupMenu jPopupMenu) {
    }

    @Override
    public DTLocation getDefaultLocation() {
        return DTLocation.create((String)"EE");
    }

    @Override
    public void loadingFinished(Project project) {
        super.loadingFinished(project);
        this.fTabs.setConfiguration(project);
        this.fTabs.activateDefaultTab();
        this.updateProjectMenu();
        project.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("__package-enabled")) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BasicProjectClient.this.updateToolbar();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void projectClosed() {
        ProjectSettingsDialog.close();
        NewSettingsDialog.close(this.getProject());
        WorkflowDialog.close();
        this.disposeBuildProgressDialog();
        super.projectClosed();
    }

    @Override
    protected void switchToNoProjectMode() {
        super.switchToNoProjectMode();
        this.fTabs.reset();
    }

    private void updateProjectMenu() {
        Object object;
        Object object2;
        Object object3;
        Project project = this.getProject();
        FileSetDefinition fileSetDefinition = this.getHierarchicalFileSet();
        this.fAddEntityActions = new ActionGroup();
        this.fAddEntityActionMenuAction = null;
        MJAbstractAction mJAbstractAction = null;
        Action action = null;
        if (fileSetDefinition != null) {
            object3 = fileSetDefinition.getRootLevelEntities().get(0).getChildren().get(0);
            if (((EntityDefinition)object3).getMinCount() != 1 || ((EntityDefinition)object3).getMaxCount() != 1) {
                mJAbstractAction = new MJAbstractAction(MessageFormat.format(BuiltInResources.getString("action.addEntity"), ((EntityDefinition)object3).getName())){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BasicProjectClient.this.addNewEntity();
                    }
                };
                this.fAddEntityActionMenuAction = new MJAbstractAction(MessageFormat.format(BuiltInResources.getString("action.addEntity"), ((EntityDefinition)object3).getName()), DocumentIcon.ADD_CLASS.getIcon()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BasicProjectClient.this.addNewEntity();
                    }
                };
                this.fAddEntityActions.add(mJAbstractAction);
                this.fAddEntityActions.add(this.fAddEntityActionMenuAction);
            }
            action = this.fTabs.getFileSetEditor(fileSetDefinition.getKey()).getRenameEntityAction();
            if (((EntityDefinition)object3).getMaxCount() < Integer.MAX_VALUE) {
                object2 = project.getConfiguration().getFileSet(fileSetDefinition.getKey());
                object = ((FileSetInstance)object2).getRootEntities().get(0);
                ((FileSetInstance)object2).addPropertyChangeListener(new PropertyChangeListener((FileSetInstance)object2, (EntityInstance)object, (EntityDefinition)object3){
                    final /* synthetic */ FileSetInstance val$instance;
                    final /* synthetic */ EntityInstance val$root;
                    final /* synthetic */ EntityDefinition val$secondLevelEntity;
                    {
                        this.val$instance = fileSetInstance;
                        this.val$root = entityInstance;
                        this.val$secondLevelEntity = entityDefinition;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        BasicProjectClient.this.fAddEntityActions.setEnabled(this.val$instance.getChildren((ReadableEntityInstance)this.val$root).size() < this.val$secondLevelEntity.getMaxCount());
                    }
                });
                this.fAddEntityActions.setEnabled(((FileSetInstance)object2).getChildren((ReadableEntityInstance)object).size() < ((EntityDefinition)object3).getMaxCount());
            }
        }
        this.fProjectMenu.removeAll();
        if (mJAbstractAction != null) {
            object3 = this.fProjectMenu.add(mJAbstractAction);
            ((Component)object3).setName("menuitem.addentity");
        }
        if (action != null) {
            object3 = this.fProjectMenu.add(action);
            ((Component)object3).setName("menuitem.rename.entity");
        }
        object3 = this.fProjectMenu.add((Action)((Object)this.getAction("RENAME_PROJECT")));
        ((Component)object3).setName("menuitem.rename.project");
        if (project != null && !project.getConfiguration().getTarget().getNonWorkflowParamSets().isEmpty()) {
            this.fProjectMenu.addSeparator();
            object2 = this.fProjectMenu.add((Action)((Object)this.getAction("SETTINGS")));
            ((Component)object2).setName("menuitem.settings");
        }
        this.fProjectMenu.addSeparator();
        object2 = this.fProjectMenu.add((Action)((Object)this.getAction("BUILD")));
        ((Component)object2).setName("menuitem.build");
        if (project != null && project.getConfiguration().getTarget().getPackageScript() != null) {
            object = this.fProjectMenu.add((Action)((Object)this.getAction("PACKAGE")));
            ((Component)object).setName("menuitem.package");
        }
        this.addExtraProjectMenuActions((JMenu)this.fProjectMenu);
        this.setMenuBar((JMenuBar)this.fMenuBar);
    }

    protected void addExtraProjectMenuActions(JMenu jMenu) {
    }

    public void addNewEntity() {
        FileSetDefinition fileSetDefinition = this.getHierarchicalFileSet();
        assert (fileSetDefinition != null);
        FileSetEditor fileSetEditor = this.getFileSetEditor(fileSetDefinition.getKey());
        fileSetEditor.addNewEntity(true);
    }

    @Override
    public void start(DeploymentProcess deploymentProcess) {
        this.updatePackageSizeWhenFinished(deploymentProcess);
        this.disableChangeActionsWhileRunning(deploymentProcess);
        this.startAndShowProgress(deploymentProcess);
    }

    private void startAndShowProgress(final DeploymentProcess deploymentProcess) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectGUI.getInstance().setCurrentProcess(deploymentProcess);
                if (BasicProjectClient.this.fProgressDialog != null) {
                    BasicProjectClient.this.fProgressDialog.setVisible(false);
                    BasicProjectClient.this.fProgressDialog.dispose();
                }
                BasicProjectClient.this.fProgressDialog = new BuildProgressDialog((Component)((Object)BasicProjectClient.this), deploymentProcess);
                BasicProjectClient.this.fProgressDialog.show();
                deploymentProcess.addMonitor(new DeploymentProcessMonitor(){

                    public void subProcessStarted(SubProcessType subProcessType) {
                    }

                    public void commandStarted(String string) {
                    }

                    public void commandOutput(String string) {
                    }

                    public void commandError(String string) {
                    }

                    public void finished() {
                        ProjectGUI.getInstance().setCurrentProcess(null);
                    }

                    public void failed() {
                        this.finished();
                    }

                    public void canceled() {
                        this.finished();
                    }
                });
                deploymentProcess.start();
            }
        });
    }

    private void updatePackageSizeWhenFinished(final DeploymentProcess deploymentProcess) {
        if (this.fTabs.getFileSetEditor("fileset.package") != null) {
            deploymentProcess.addMonitor(new DeploymentProcessMonitor(){

                public void subProcessStarted(SubProcessType subProcessType) {
                }

                public void commandStarted(String string) {
                }

                public void commandOutput(String string) {
                }

                public void commandError(String string) {
                }

                public void failed() {
                    this.finished();
                }

                public void canceled() {
                    this.finished();
                }

                public void finished() {
                    deploymentProcess.removeMonitor((DeploymentProcessMonitor)this);
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (BasicProjectClient.this.fTabs.getFileSetEditor("fileset.package") != null) {
                                BasicProjectClient.this.fTabs.getFileSetEditor("fileset.package").updateSizeEstimate();
                            }
                        }
                    });
                }
            });
        }
    }

    public void disposeBuildProgressDialog() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BasicProjectClient.this.fProgressDialog != null) {
                    BasicProjectClient.this.fProgressDialog.setVisible(false);
                    BasicProjectClient.this.fProgressDialog.dispose();
                    BasicProjectClient.this.fProgressDialog = null;
                }
            }
        });
    }

    @Override
    public FileSetEditor getFileSetEditor(String string) {
        return this.fTabs.getFileSetEditor(string);
    }

    private int addSpecialFileOptions(JPopupMenu jPopupMenu) {
        Project project = this.getProject();
        if (project != null) {
            final Configuration configuration = project.getConfiguration();
            FileSetDefinition fileSetDefinition = project.getConfiguration().getTarget().getFileSet("fileset.package");
            final FileSetInstance fileSetInstance = project.getConfiguration().getFileSet("fileset.package");
            int n = 0;
            for (final SpecialFile specialFile : fileSetDefinition.getSpecialFiles()) {
                MJAbstractAction mJAbstractAction;
                String string;
                ++n;
                if (fileSetInstance.getFiles().contains(configuration.getSpecialFileLocation(specialFile))) {
                    string = MessageFormat.format(BuiltInResources.getString("link.remove"), specialFile.getName());
                    mJAbstractAction = new MJAbstractAction(string){

                        public void actionPerformed(ActionEvent actionEvent) {
                            fileSetInstance.remove(Arrays.asList(configuration.getSpecialFileLocation(specialFile)));
                        }
                    };
                    mJAbstractAction.setComponentName("remove." + specialFile.getKey());
                    BasicProjectClient.addToActionMenu(jPopupMenu, mJAbstractAction);
                    continue;
                }
                string = MessageFormat.format(BuiltInResources.getString("link.add"), specialFile.getName());
                mJAbstractAction = new MJAbstractAction(string){

                    public void actionPerformed(ActionEvent actionEvent) {
                        FileSetEditor fileSetEditor = BasicProjectClient.this.fTabs.getFileSetEditor("fileset.package");
                        BasicProjectClient.this.fTabs.activatePackageTab();
                        ReferenceOptionDialog.show(specialFile, configuration, fileSetEditor, specialFile.getLocationPreferencePanelName());
                    }
                };
                mJAbstractAction.setComponentName("add." + specialFile.getKey());
                BasicProjectClient.addToActionMenu(jPopupMenu, mJAbstractAction);
            }
            return n;
        }
        return 0;
    }
}

