/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.mvm.MvmSwingWorker;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.SectionedProjectTab;
import com.mathworks.project.impl.apps.DepfunAction;
import com.mathworks.project.impl.apps.Utils;
import com.mathworks.project.impl.desktop.AppsProjectClient;
import com.mathworks.project.impl.desktop.DottedLine;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectSectionDefinition;
import com.mathworks.project.impl.model.ProjectTabDefinition;
import com.mathworks.project.impl.model.Target;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.border.Border;

public class FileManager
implements ProjectComponent {
    private MJPanel fMain = new MJPanel();
    private SectionedProjectTab fPanel;
    private AppsProjectClient fClient;

    public FileManager(AppsProjectClient appsProjectClient) {
        this.fClient = appsProjectClient;
        this.fMain = new MJPanel(new GridBagLayout()){

            public Dimension getMinimumSize() {
                return new Dimension(250, 0);
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        this.fMain.setBorder((Border)new DottedLine());
    }

    private static List<ProjectSectionDefinition> getFileSetSections(WritableConfiguration writableConfiguration) {
        ArrayList<ProjectSectionDefinition> arrayList = new ArrayList<ProjectSectionDefinition>();
        for (String string : writableConfiguration.getFileSetKeys()) {
            if (string.equals("fileset.package")) continue;
            ProjectSectionDefinition projectSectionDefinition = new ProjectSectionDefinition(string, null, null, string, null, null, null);
            arrayList.add(projectSectionDefinition);
            if (!string.equals("fileset.depfun")) continue;
            projectSectionDefinition.showLinks(false);
        }
        return arrayList;
    }

    private static boolean isMatlabNull(Object object) {
        return object instanceof double[] && ((double[])object).length == 0;
    }

    protected void setConfiguration(Project project) {
        this.fPanel = new SectionedProjectTab(project, FileManager.getFileSetSections(project.getConfiguration()), true);
        this.fMain.add((Component)this.fPanel.getComponent(), (Object)new GridBagConstraints(0, 1, 0, 0, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getFileSetEditor("fileset.main").getFileSet().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                final Configuration configuration = FileManager.this.fClient.getProject().getConfiguration();
                if (configuration.getFileSet("fileset.main").getFiles().isEmpty()) {
                    configuration.setParamAsString("param.guid", "");
                    new DepfunAction().doDepfun(configuration);
                } else {
                    final StringBuffer stringBuffer = new StringBuffer();
                    PrintWriter printWriter = new PrintWriter(new Writer(){

                        @Override
                        public void write(char[] cArray, int n, int n2) throws IOException {
                            stringBuffer.append(String.copyValueOf(cArray, n, n2));
                        }

                        @Override
                        public void flush() throws IOException {
                        }

                        @Override
                        public void close() throws IOException {
                        }
                    });
                    PrintWriter printWriter2 = new PrintWriter(new Writer(){

                        @Override
                        public void write(char[] cArray, int n, int n2) throws IOException {
                            stringBuffer.append(String.copyValueOf(cArray, n, n2));
                        }

                        @Override
                        public void flush() throws IOException {
                        }

                        @Override
                        public void close() throws IOException {
                        }
                    });
                    final Set<File> set = FileManager.this.getFileSetEditor("fileset.main").getFileSet().getFiles();
                    MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
                    MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("appcreate.internal.appbuilder.isValidMainFile", 2, (Writer)printWriter2, (Writer)printWriter, new Object[]{set.iterator().next().getAbsolutePath()});
                    FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
                    MvmSwingWorker<Object[]> mvmSwingWorker = new MvmSwingWorker<Object[]>((FutureResult)futureFevalResult){

                        protected void done() {
                            try {
                                Object[] objectArray = (Object[])this.get();
                                boolean bl = ((boolean[])objectArray[0])[0];
                                if (!bl) {
                                    String string = (String)objectArray[1];
                                    MJOptionPane.showMessageDialog((Component)((Object)FileManager.this.fClient), (Object)string, (String)BuiltInResources.getString("error.invalid.main.file.title"), (int)0);
                                    FileManager.this.getFileSetEditor("fileset.main").getFileSet().remove(new ArrayList<File>(set));
                                } else {
                                    new DepfunAction().doDepfun(configuration);
                                }
                            }
                            catch (ExecutionException executionException) {
                                StackTraceElement[] stackTraceElementArray = executionException.getStackTrace();
                                stringBuffer.append(executionException.getLocalizedMessage());
                                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                                    stringBuffer.append("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
                                    MJOptionPane.showMessageDialog((Component)((Object)FileManager.this.fClient), (Object)Utils.getHTMLStringForMessageDialog(stringBuffer.toString()), (String)BuiltInResources.getString("error.invalid.main.file.title"), (int)0);
                                    FileManager.this.getFileSetEditor("fileset.main").getFileSet().remove(new ArrayList<File>(set));
                                }
                            }
                        }
                    };
                    mvmSwingWorker.runWhenReady();
                }
            }
        });
        this.getFileSetEditor("fileset.resources").getFileSet().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File file2;
                Set set = (Set)propertyChangeEvent.getNewValue();
                Set set2 = (Set)propertyChangeEvent.getOldValue();
                set.removeAll(set2);
                if (set.isEmpty()) {
                    new DepfunAction().doDepfun(FileManager.this.fClient.getProject().getConfiguration());
                    return;
                }
                MatlabExecutor matlabExecutor = set.toArray(new File[0]);
                Object[] objectArray = new String[((File[])matlabExecutor).length];
                int n = 0;
                for (File file2 : matlabExecutor) {
                    objectArray[n++] = file2.getAbsolutePath();
                }
                MatlabExecutor matlabExecutor2 = MvmContext.get().getExecutor();
                MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("appcreate.internal.appbuilder.filesNotToPackage", 2, objectArray);
                FutureFevalResult futureFevalResult = matlabExecutor2.submit(matlabFevalRequest);
                file2 = new MvmSwingWorker<Object[]>((FutureResult)futureFevalResult, (File[])matlabExecutor){
                    final /* synthetic */ File[] val$resourceFiles;
                    {
                        this.val$resourceFiles = fileArray;
                        super(futureResult);
                    }

                    protected void done() {
                        try {
                            Object[] objectArray = (Object[])this.get();
                            if (!FileManager.isMatlabNull(objectArray[0])) {
                                String[] stringArray = (String[])objectArray[0];
                                String string = (String)objectArray[1];
                                for (String string2 : stringArray) {
                                    string = string + "\n    " + string2;
                                }
                                MJOptionPane.showMessageDialog((Component)((Object)FileManager.this.fClient), (Object)string, (String)BuiltInResources.getString("error.invalid.main.file.title"), (int)0);
                                FileManager.this.getFileSetEditor("fileset.resources").getFileSet().remove(Arrays.asList(this.val$resourceFiles));
                            } else {
                                new DepfunAction().doDepfun(FileManager.this.fClient.getProject().getConfiguration());
                            }
                        }
                        catch (ExecutionException executionException) {
                            StackTraceElement[] stackTraceElementArray = executionException.getStackTrace();
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(executionException.getLocalizedMessage());
                            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                                stringBuffer.append("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
                            }
                            MJOptionPane.showMessageDialog((Component)((Object)FileManager.this.fClient), (Object)Utils.getHTMLStringForMessageDialog(stringBuffer.toString()), (String)BuiltInResources.getString("error.invalid.main.file.title"), (int)0);
                            FileManager.this.getFileSetEditor("fileset.resources").getFileSet().remove(Arrays.asList(this.val$resourceFiles));
                        }
                    }
                };
                file2.runWhenReady();
            }
        });
    }

    public Component getComponent() {
        return this.fMain;
    }

    public void dispose() {
        this.fPanel.dispose();
    }

    public FileSetEditor getFileSetEditor(String string) {
        return this.fPanel.getFileSetEditor(string);
    }

    private static Component getFileManagerComponent(Project project) {
        Target target = project.getConfiguration().getTarget();
        List<ProjectTabDefinition> list = FileManager.getApplicableTabs(target);
        ProjectTabDefinition projectTabDefinition = list.get(0);
        ProjectComponent projectComponent = FileManager.instantiateTab(project, projectTabDefinition);
        return projectComponent.getComponent();
    }

    private static List<ProjectTabDefinition> getApplicableTabs(Target target) {
        ArrayList<ProjectTabDefinition> arrayList = new ArrayList<ProjectTabDefinition>();
        for (ProjectTabDefinition projectTabDefinition : target.getProjectTabs()) {
            if (projectTabDefinition.requiresPackageScript() && target.getPackageScript() == null) continue;
            arrayList.add(projectTabDefinition);
        }
        return arrayList;
    }

    private static ProjectComponent instantiateTab(Project project, ProjectTabDefinition projectTabDefinition) {
        try {
            Class<?> clazz = Class.forName(projectTabDefinition.getImplementationClassName());
            for (Constructor<?> constructor : clazz.getConstructors()) {
                List<Class<?>> list = Arrays.asList(constructor.getParameterTypes());
                if (((Object)list).equals(Arrays.asList(WritableConfiguration.class))) {
                    return (ProjectComponent)constructor.newInstance(project.getConfiguration());
                }
                if (!((Object)list).equals(Arrays.asList(Project.class, List.class))) continue;
                return (ProjectComponent)constructor.newInstance(project, projectTabDefinition.getSections());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        throw new IllegalArgumentException("No supported constructor in class: " + projectTabDefinition.getImplementationClassName());
    }

    public File getMainFile() {
        FileSetEditor fileSetEditor = this.getFileSetEditor("fileset.main");
        Set<File> set = fileSetEditor.getFileSet().getFiles();
        if (set.isEmpty()) {
            return null;
        }
        return (File)set.toArray()[0];
    }

    public void close() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FileManager.this.fPanel != null) {
                    FileManager.this.fPanel.dispose();
                }
                FileManager.this.fMain.removeAll();
                FileManager.this.fMain.invalidate();
            }
        });
    }
}

