/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.project.api.CustomFileSetAction;
import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.ReferenceOptionDialog;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;

public final class FileSetLinkUtils {
    private FileSetLinkUtils() {
    }

    static HyperlinkTextLabel createRootLevelAddLink(final FileSetEditor fileSetEditor) {
        final FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        String string = BuiltInResources.getString("link.addfiles");
        if (fileSetInstance.getDefinition().allowsDirectories()) {
            string = BuiltInResources.getString("link.addfiles.ordirs");
        }
        if (fileSetInstance.getDefinition().getHierarchyLevels() == 2) {
            if (!fileSetEditor.supportsEntityAddAndRemove()) {
                return null;
            }
            string = MessageFormat.format(BuiltInResources.getString("link.add"), FileSetLinkUtils.capitalizedLinkText(fileSetInstance));
        }
        if (fileSetInstance.getDefinition().getMaxCount() == 1) {
            string = MessageFormat.format(BuiltInResources.getString("link.add"), FileSetLinkUtils.capitalizedLinkText(fileSetInstance));
        }
        return FileSetLinkUtils.createLink(string, "link.add." + fileSetEditor.getFileSet().getDefinition().getKey(), new Runnable(){

            @Override
            public void run() {
                if (fileSetInstance.getDefinition().getHierarchyLevels() == 2) {
                    ((BasicProjectClient)ProjectGUI.getInstance().getCurrentClient()).addNewEntity();
                } else {
                    FileSetLinkUtils.showRootLevelAddDialog(fileSetEditor);
                }
            }
        });
    }

    private static String capitalizedLinkText(FileSetInstance fileSetInstance) {
        String string = fileSetInstance.getDefinition().getName().toLowerCase();
        return string.replace("matlab", "MATLAB");
    }

    static HyperlinkTextLabel createEntityLevelAddLink(final FileSetEditor fileSetEditor, final EntityInstance entityInstance) {
        FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        EntityInstance entityInstance2 = fileSetInstance.getRootEntities().iterator().next();
        int n = fileSetInstance.getChildren((ReadableEntityInstance)entityInstance2).indexOf(entityInstance);
        String string = BuiltInResources.getString("link.addfiles");
        return FileSetLinkUtils.createLink(string, "link.add.entity." + n, new Runnable(){

            @Override
            public void run() {
                FileSetLinkUtils.showEntityLevelAddDialog(fileSetEditor, entityInstance);
            }
        });
    }

    static void showRootLevelAddDialog(FileSetEditor fileSetEditor) {
        FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(fileArray, true);
            }
        } else {
            FileChooser fileChooser = FileSetLinkUtils.createFileChooser(fileSetEditor.getComponent(), fileSetInstance.getDefinition());
            File[] fileArray = fileChooser.showOpenDialog();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(fileArray, true);
            }
        }
    }

    static void showEntityLevelAddDialog(FileSetEditor fileSetEditor, EntityInstance entityInstance) {
        FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(entityInstance, fileArray, true);
            }
        } else {
            FileChooser fileChooser = FileSetLinkUtils.createFileChooser(fileSetEditor.getComponent(), fileSetInstance.getDefinition());
            File[] fileArray = fileChooser.showOpenDialog();
            if (fileArray != null) {
                fileSetEditor.addAndSelect(entityInstance, fileArray, true);
            }
        }
    }

    static FileChooser createFileChooser(Component component, FileSetDefinition fileSetDefinition) {
        return FileChooser.create(component, BuiltInResources.getString("dialog.title.addfiles"), new File(MatlabPath.getCWD()), fileSetDefinition.allowsDirectories(), fileSetDefinition.getFilters());
    }

    static HyperlinkTextLabel createRootLevelRemoveLink(FileSetEditor fileSetEditor) {
        final FileSetInstance fileSetInstance = fileSetEditor.getFileSet();
        assert (fileSetInstance.getDefinition().getMaxCount() == 1);
        String string = MessageFormat.format(BuiltInResources.getString("link.remove"), FileSetLinkUtils.capitalizedLinkText(fileSetInstance));
        return FileSetLinkUtils.createLink(string, "link.remove." + fileSetEditor.getFileSet().getDefinition().getKey(), new Runnable(){

            @Override
            public void run() {
                assert (fileSetInstance.getCurrentCount() == 1);
                fileSetInstance.remove(Arrays.asList(fileSetInstance.getFiles().iterator().next()));
            }
        });
    }

    static HyperlinkTextLabel createSpecialFileAddLink(final FileSetEditor fileSetEditor, final SpecialFile specialFile, final Configuration configuration) {
        String string = MessageFormat.format(BuiltInResources.getString("link.add"), specialFile.getName());
        HyperlinkTextLabel hyperlinkTextLabel = FileSetLinkUtils.createLink(string, "link.add." + specialFile.getKey(), new Runnable(){

            @Override
            public void run() {
                ReferenceOptionDialog.show(specialFile, configuration, fileSetEditor, specialFile.getLocationPreferencePanelName());
            }
        });
        hyperlinkTextLabel.getComponent().setToolTipText(specialFile.getDescription());
        return hyperlinkTextLabel;
    }

    static HyperlinkTextLabel createSpecialFileRemoveLink(final FileSetEditor fileSetEditor, SpecialFile specialFile, final File file) {
        String string = MessageFormat.format(BuiltInResources.getString("link.remove"), specialFile.getName());
        return FileSetLinkUtils.createLink(string, "link.remove." + specialFile.getKey(), new Runnable(){

            @Override
            public void run() {
                fileSetEditor.getFileSet().remove(Arrays.asList(file));
            }
        });
    }

    public static HyperlinkTextLabel createLink(String string, String string2, final Runnable runnable) {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<a href=\"\">" + string + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                runnable.run();
            }
        }, false, string2 + ".innerComponent", string){

            public Color getHyperlinkColor() {
                return new Color(2118279);
            }
        };
        if (!PlatformInfo.isMacintosh()) {
            hyperlinkTextLabel.setFont(FontUtils.getSystemUIFont());
        } else {
            hyperlinkTextLabel.setFont(FontUtils.getSystemUIFont());
        }
        hyperlinkTextLabel.addRule("body", "color", "black");
        hyperlinkTextLabel.addRule("a", "text-decoration", "none");
        hyperlinkTextLabel.addRule("a", "color", "black");
        hyperlinkTextLabel.getComponent().setBackground(FileSetEditor.BACKGROUND);
        hyperlinkTextLabel.getComponent().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        hyperlinkTextLabel.getComponent().setName(string2);
        return hyperlinkTextLabel;
    }

    public static HyperlinkTextLabel createLink(final CustomFileSetAction customFileSetAction, final Configuration configuration) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                customFileSetAction.run((WritableConfiguration)configuration);
            }
        };
        return FileSetLinkUtils.createLink(customFileSetAction.getLabel(), customFileSetAction.getQeName(), runnable);
    }
}

