/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.util.Combiner;
import com.mathworks.util.RequestAggregator;
import com.mathworks.widgets.desk.DTWindowCloser;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;

final class AutoSaveHandler {
    private final SaveRequestListener fListener;
    private final Project fProject;
    private final RequestAggregator<SaveRequest> fSaveRequestor;
    private final SaveFlusher fSaveFlusher;
    private static final ExitHook sExitHook = new ExitHook();
    private static final int MAX_SAVE_DELAY_MS = 500;

    AutoSaveHandler(Project project) {
        this.fProject = project;
        this.fSaveRequestor = new RequestAggregator((Combiner)new SaveRequestCombiner(), 500);
        this.fSaveRequestor.setName("DeployTool project save requestor");
        this.fListener = new SaveRequestListener();
        this.fSaveFlusher = new SaveFlusher();
        sExitHook.addFlusher(this.fSaveFlusher);
        this.fProject.addPropertyChangeListener(this.fListener);
    }

    void waitForIdle() {
        new SaveFlusher().run();
    }

    void requestSave() {
        this.fSaveRequestor.request((Runnable)new SaveRequest(new PropertyChangeEvent(this.fProject, "force", null, null)));
    }

    void destroy() {
        this.fProject.removePropertyChangeListener(this.fListener);
        sExitHook.removeFlusher(this.fSaveFlusher);
        this.fSaveFlusher.run();
    }

    static {
        MLDesktop.getInstance().addMatlabThreadCloser((DTWindowCloser)sExitHook);
    }

    private static class ExitHook
    implements DTWindowCloser {
        private List<Runnable> fFlushers = new ArrayList<Runnable>();

        private ExitHook() {
        }

        public synchronized void addFlusher(Runnable runnable) {
            this.fFlushers.add(runnable);
        }

        public synchronized void removeFlusher(Runnable runnable) {
            this.fFlushers.remove(runnable);
        }

        public synchronized boolean canClose() {
            try {
                for (Runnable runnable : this.fFlushers) {
                    runnable.run();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return true;
        }

        public void close() {
        }
    }

    private class SaveFlusher
    implements Runnable {
        private SaveFlusher() {
        }

        @Override
        public void run() {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            AutoSaveHandler.this.fSaveRequestor.runWhenIdle(new Runnable(){

                @Override
                public void run() {
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class SaveRequestCombiner
    implements Combiner<SaveRequest, Runnable> {
        private SaveRequestCombiner() {
        }

        public Runnable combine(final List<SaveRequest> list) {
            return new Runnable(){

                @Override
                public void run() {
                    SaveRequest saveRequest = null;
                    boolean bl = false;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        SaveRequest saveRequest2;
                        saveRequest = saveRequest2 = (SaveRequest)iterator.next();
                        bl = false;
                        if (!saveRequest.isRename()) continue;
                        saveRequest.run();
                        bl = true;
                        if (!saveRequest.isFailed()) continue;
                        break;
                    }
                    if (saveRequest != null && !bl) {
                        saveRequest.run();
                    }
                }
            };
        }
    }

    private class SaveRequest
    implements Runnable {
        private final PropertyChangeEvent fEvent;
        private boolean fFailed;

        SaveRequest(PropertyChangeEvent propertyChangeEvent) {
            this.fEvent = propertyChangeEvent;
        }

        @Override
        public void run() {
            try {
                ProjectManager.save(AutoSaveHandler.this.fProject);
            }
            catch (IOException iOException) {
                ProjectManager.getSaveErrorHandler().saveFailed(AutoSaveHandler.this.fProject, iOException);
                this.fFailed = true;
            }
            if (!this.fFailed && this.isRename()) {
                ((File)this.fEvent.getOldValue()).delete();
                ProjectManager.removeRecentProject((File)this.fEvent.getOldValue());
                ProjectManager.addRecentProject((File)this.fEvent.getNewValue());
            }
        }

        boolean isFailed() {
            return this.fFailed;
        }

        boolean isRename() {
            return this.fEvent.getPropertyName().equals("file");
        }
    }

    private class SaveRequestListener
    implements PropertyChangeListener {
        private SaveRequestListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AutoSaveHandler.this.fSaveRequestor.request((Runnable)new SaveRequest(propertyChangeEvent));
        }
    }
}

