/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.jmi.Matlab;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.plugin.LazyIcon;
import com.mathworks.util.RequestFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;

public final class Project {
    private Configuration fConfiguration;
    private XmlReader fXslInput;
    private final PropertyChangeSupport fPropertySupport;
    private final List<MatlabChangeCallback> fMatlabChangeCallbacks;
    private final Object fXslInputLock;
    private PropertyChangeListener fListener;
    private File fFile;
    private Icon fIcon;
    private int fXslInputStateId;
    private RequestFilter fMatlabChangeRequestFilter;
    private final String fUuid;
    public static final String FILE_PROPERTY = "file";
    public static final String FILE_EXTENSION = ".prj";

    Project(File file, Icon icon) {
        this.fFile = file;
        this.fUuid = UUID.randomUUID().toString();
        this.fMatlabChangeCallbacks = new LinkedList<MatlabChangeCallback>();
        this.fIcon = icon != null ? icon : LazyIcon.forFile(file);
        this.fXslInputLock = new Object();
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    public void setFile(File file) {
        File file2 = this.fFile;
        this.fFile = file;
        this.fIcon = LazyIcon.forFile(file);
        this.fConfiguration.setName(ProjectManager.getConfigurationName(this.fFile));
        this.fConfiguration.setFile(this.fFile);
        this.fPropertySupport.firePropertyChange(FILE_PROPERTY, file2, this.fFile);
    }

    public String getUuid() {
        return this.fUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlReader getXslInput() {
        int n;
        Object object = this.fXslInputLock;
        synchronized (object) {
            if (this.fXslInput == null) {
                if (this.fListener == null) {
                    this.fListener = new PropertyChangeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            Object object = Project.this.fXslInputLock;
                            synchronized (object) {
                                Project.this.fXslInput = null;
                            }
                        }
                    };
                    this.fConfiguration.addPropertyChangeListener(this.fListener);
                }
            } else {
                return this.fXslInput;
            }
            n = ++this.fXslInputStateId;
        }
        object = ProjectManager.configurationToXslInput(this);
        Object object2 = this.fXslInputLock;
        synchronized (object2) {
            if (n == this.fXslInputStateId) {
                this.fXslInput = object;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlReader getXslInputIfCached() {
        Object object = this.fXslInputLock;
        synchronized (object) {
            return this.fXslInput;
        }
    }

    public File getFile() {
        return this.fFile;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public void setConfiguration(Configuration configuration) {
        assert (this.fConfiguration == null);
        this.fConfiguration = configuration;
        this.fConfiguration.setFile(this.fFile);
    }

    public Configuration getConfiguration() {
        return this.fConfiguration;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
        this.fConfiguration.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
        this.fConfiguration.removePropertyChangeListener(propertyChangeListener);
    }

    public void addMatlabChangeCallback(String string, Object ... objectArray) {
        this.fMatlabChangeCallbacks.add(new MatlabChangeCallback(string, objectArray));
        if (this.fMatlabChangeRequestFilter == null) {
            this.fMatlabChangeRequestFilter = new RequestFilter(new Runnable(){

                @Override
                public void run() {
                    for (MatlabChangeCallback matlabChangeCallback : new ArrayList(Project.this.fMatlabChangeCallbacks)) {
                        new Matlab().fevalConsoleOutput(matlabChangeCallback.getFunction(), matlabChangeCallback.getArguments());
                    }
                }
            }, 400);
            this.fConfiguration.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Project.this.fMatlabChangeRequestFilter.request();
                }
            });
        }
    }

    private static class MatlabChangeCallback {
        private final String fFunction;
        private final Object[] fArguments;

        MatlabChangeCallback(String string, Object[] objectArray) {
            this.fFunction = string;
            this.fArguments = (Object[])objectArray.clone();
        }

        public String getFunction() {
            return this.fFunction;
        }

        public Object[] getArguments() {
            return (Object[])this.fArguments.clone();
        }
    }
}

