/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.GeneratedReferenceSet;
import com.mathworks.project.impl.model.XmlGenerationFlag;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class XmlGenerationContext {
    private Map<String, String> fXmlByBranchKey;
    private String fMatlabSection;
    private String fGenericBranchKey;
    private GeneratedReferenceSet fReferenceSet;
    private final Set<String> fExcludedParameterKeys;
    private final Set<XmlGenerationFlag> fFlags;

    XmlGenerationContext(GeneratedReferenceSet generatedReferenceSet) {
        this(new XmlGenerationFlag[0]);
        this.fReferenceSet = generatedReferenceSet;
    }

    XmlGenerationContext(XmlGenerationFlag ... xmlGenerationFlagArray) {
        this.fFlags = EnumSet.noneOf(XmlGenerationFlag.class);
        this.fFlags.addAll(Arrays.asList(xmlGenerationFlagArray));
        this.fXmlByBranchKey = new HashMap<String, String>();
        this.fExcludedParameterKeys = new HashSet<String>();
        this.fGenericBranchKey = this.generateGenericBranchKey();
    }

    XmlGenerationContext(XmlGenerationContext xmlGenerationContext, String string) {
        this(xmlGenerationContext);
        this.fExcludedParameterKeys.add(string);
        this.fGenericBranchKey = this.generateGenericBranchKey();
    }

    XmlGenerationContext withFlags(XmlGenerationFlag ... xmlGenerationFlagArray) {
        XmlGenerationContext xmlGenerationContext = new XmlGenerationContext(this);
        xmlGenerationContext.fFlags.addAll(Arrays.asList(xmlGenerationFlagArray));
        return xmlGenerationContext;
    }

    XmlGenerationContext withoutFlags(XmlGenerationFlag ... xmlGenerationFlagArray) {
        XmlGenerationContext xmlGenerationContext = new XmlGenerationContext(this);
        xmlGenerationContext.fFlags.removeAll(Arrays.asList(xmlGenerationFlagArray));
        return xmlGenerationContext;
    }

    private XmlGenerationContext(XmlGenerationContext xmlGenerationContext) {
        this.fReferenceSet = xmlGenerationContext.fReferenceSet;
        this.fExcludedParameterKeys = new HashSet<String>();
        if (xmlGenerationContext == null) {
            this.fXmlByBranchKey = new HashMap<String, String>();
            this.fFlags = EnumSet.noneOf(XmlGenerationFlag.class);
        } else {
            this.fFlags = EnumSet.noneOf(XmlGenerationFlag.class);
            this.fFlags.addAll(xmlGenerationContext.fFlags);
            this.fXmlByBranchKey = xmlGenerationContext.fXmlByBranchKey;
            this.fExcludedParameterKeys.addAll(xmlGenerationContext.fExcludedParameterKeys);
        }
        this.fGenericBranchKey = this.generateGenericBranchKey();
    }

    public boolean hasFlag(XmlGenerationFlag xmlGenerationFlag) {
        return this.fFlags.contains((Object)xmlGenerationFlag);
    }

    public boolean isParameterKeyExcluded(String string) {
        return this.fExcludedParameterKeys.contains(string);
    }

    public void setXML(String string, String string2) {
        this.fXmlByBranchKey.put(this.generateBranchKey(string), string2);
    }

    public String getXML(String string) {
        return this.fXmlByBranchKey.get(this.generateBranchKey(string));
    }

    public void setMatlabSection(String string) {
        this.fMatlabSection = string;
    }

    public String getMatlabSection() {
        return this.fMatlabSection;
    }

    String generateBranchKey(String string) {
        return string + ": " + this.fGenericBranchKey;
    }

    private String generateGenericBranchKey() {
        return Arrays.toString(new TreeSet<String>(this.fExcludedParameterKeys).toArray(new String[this.fExcludedParameterKeys.size()]));
    }

    public String[] getExcludedKeys() {
        return new TreeSet<String>(this.fExcludedParameterKeys).toArray(new String[this.fExcludedParameterKeys.size()]);
    }

    public File getReferenceFile(FileSetDefinition fileSetDefinition, File file) {
        return this.fReferenceSet == null ? file : this.fReferenceSet.getReferenceFile(fileSetDefinition, file);
    }
}

