/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.plugin.PluginReaderStack;
import com.mathworks.util.Log;
import com.mathworks.xml.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class XslBasedValidator
implements ConfigurationValidator {
    private final String fXsl;
    private final PluginReaderStack fReaderStack;

    XslBasedValidator(String string, PluginReaderStack pluginReaderStack) {
        this.fXsl = PluginManager.normalizeXsl(string, true);
        this.fReaderStack = pluginReaderStack;
    }

    public List<ValidationMessage> validate(final ReadableConfiguration readableConfiguration) {
        String string = readableConfiguration.getXML();
        try {
            XmlReader xmlReader = XmlApi.getInstance().read(XMLUtils.transform((String)string, (String)this.fXsl));
            final ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
            xmlReader.loop(new XmlLooper(){

                public void iterate(XmlReader xmlReader) {
                    String string = xmlReader.readAttribute("key");
                    String string2 = xmlReader.getCurrentElementName();
                    String string3 = xmlReader.readAttribute("param");
                    if (string == null) {
                        throw new IllegalStateException("XSL validation logic generated a problem with no message");
                    }
                    if (string2 == null) {
                        throw new IllegalStateException("XSL validation logic generated a problem with no severity");
                    }
                    Severity severity = Severity.valueOf((String)string2.toUpperCase(Locale.ENGLISH));
                    String string4 = XslBasedValidator.this.fReaderStack.getResource(string);
                    if (string4 == null) {
                        throw new IllegalStateException("XSL validation logic generated message key " + string + " with no corresponding text resource");
                    }
                    if (string3 != null) {
                        try {
                            readableConfiguration.getParamReader(string3);
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("XSL validation logic generated message against nonexistent param key " + string3);
                        }
                    }
                    arrayList.add(new ValidationMessage(severity, string4, string3));
                }
            }, new String[]{"warning", "error"});
            return arrayList;
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
            return null;
        }
    }
}

