/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.util.Holder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

final class DefaultSettingsPanelBuilder
implements SettingsPanelBuilder {
    private final MJPanel fComponent;
    private final GridBagConstraints fRootConstraints;
    private final boolean fInline;
    private GridBagConstraints fCurrentConstraints;
    private String fCategoryName;
    private MJPanel fCurrentPanel;
    private boolean fFinished;
    private Holder<Boolean> fSuppressRightPadding;
    private Holder<Boolean> fRootSuppressRightPadding;
    private static final String UNSPECIFIED_CATEGORY = "__unspecified_category";

    DefaultSettingsPanelBuilder(boolean bl) {
        this.fInline = bl;
        this.fComponent = new MJPanel((LayoutManager)new GridBagLayout());
        this.fComponent.setOpaque(false);
        this.fCurrentConstraints = this.fRootConstraints = this.createConstraints();
        this.fCurrentPanel = this.fComponent;
        this.fRootSuppressRightPadding = new Holder();
        this.fRootSuppressRightPadding.set((Object)false);
        this.fSuppressRightPadding = this.fRootSuppressRightPadding;
        if (!bl) {
            this.fComponent.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        }
    }

    @Override
    public void startCategory(String string) {
        if (this.fCategoryName != null) {
            this.endCategory();
        }
        this.fCategoryName = string;
        this.fRootSuppressRightPadding.set((Object)true);
        this.fSuppressRightPadding = new Holder();
        this.fSuppressRightPadding.set((Object)false);
        this.fCurrentPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.fCurrentConstraints.fill = 2;
        this.fCurrentConstraints.weightx = 1.0;
        this.fCurrentConstraints.gridwidth = 2;
        this.fComponent.add((Component)this.fCurrentPanel, (Object)this.fCurrentConstraints);
        this.fCurrentConstraints.weightx = 0.0;
        this.fCurrentConstraints.gridwidth = 1;
        this.fCurrentConstraints.fill = 0;
        ++this.fCurrentConstraints.gridy;
        this.fCurrentConstraints = this.createConstraints();
        this.fCurrentPanel.setOpaque(false);
        if (string != UNSPECIFIED_CATEGORY) {
            this.fCurrentPanel.setBorder((Border)BorderFactory.createTitledBorder(string));
        }
    }

    @Override
    public String getCurrentCategoryName() {
        return this.fCategoryName == UNSPECIFIED_CATEGORY ? null : this.fCategoryName;
    }

    @Override
    public void endCategory() {
        this.addRightPadding();
        this.fSuppressRightPadding = this.fRootSuppressRightPadding;
        this.fCurrentConstraints = this.fRootConstraints;
        this.fCurrentPanel = this.fComponent;
        this.fCategoryName = null;
    }

    @Override
    public void addComponent(SettingComponentDefinition settingComponentDefinition) {
        if (settingComponentDefinition.getLabel() == null) {
            this.addComponent(settingComponentDefinition.getComponent(), false);
            return;
        }
        if (this.fCategoryName == null) {
            this.startCategory(UNSPECIFIED_CATEGORY);
        }
        MJLabel mJLabel = new MJLabel(settingComponentDefinition.getLabel() + ":");
        mJLabel.setToolTipText(settingComponentDefinition.getTooltip());
        this.fCurrentPanel.add((Component)mJLabel, (Object)this.fCurrentConstraints);
        ++this.fCurrentConstraints.gridx;
        this.fCurrentConstraints.weightx = 0.0;
        this.fCurrentConstraints.fill = 0;
        if (this.fInline || TreeUtils.findComponent((Component)settingComponentDefinition.getComponent(), JTextField.class) != null && TreeUtils.findComponent((Component)settingComponentDefinition.getComponent(), JSpinner.class) == null) {
            this.fSuppressRightPadding.set((Object)true);
            this.fCurrentConstraints.weightx = 1.0;
            this.fCurrentConstraints.fill = 2;
        }
        this.fCurrentPanel.add(settingComponentDefinition.getComponent(), (Object)this.fCurrentConstraints);
        this.fCurrentConstraints.weightx = 0.0;
        this.fCurrentConstraints.weighty = 0.0;
        this.fCurrentConstraints.fill = 0;
        this.fCurrentConstraints.gridx = 0;
        ++this.fCurrentConstraints.gridy;
    }

    @Override
    public void addComponent(Component component, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = TreeUtils.findComponent((Component)component, JScrollPane.class) != null && TreeUtils.findComponent((Component)component, JTextArea.class) == null && TreeUtils.findComponents((Component)component, PropertyTable.NO_STRETCH_COMPONENT_PREDICATE).isEmpty();
        if (!bl2 && this.fCategoryName == null) {
            this.startCategory(UNSPECIFIED_CATEGORY);
        }
        if (component instanceof JTextField) {
            this.fCurrentConstraints.weightx = 1.0;
            this.fCurrentConstraints.fill = 2;
        }
        if (bl2) {
            this.fSuppressRightPadding.set((Object)true);
            this.fCurrentConstraints.weightx = 1.0;
            this.fCurrentConstraints.weighty = 1.0;
            this.fCurrentConstraints.fill = 1;
        }
        this.fCurrentConstraints.gridwidth = 2;
        this.fCurrentPanel.add(component, (Object)this.fCurrentConstraints);
        this.fCurrentConstraints.gridx = 0;
        ++this.fCurrentConstraints.gridy;
        this.fCurrentConstraints.gridwidth = 1;
        this.fCurrentConstraints.weightx = 0.0;
        this.fCurrentConstraints.fill = 0;
    }

    private GridBagConstraints createConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        if (this.fInline) {
            gridBagConstraints.insets.left = 3;
            if (PlatformInfo.isMacintosh()) {
                gridBagConstraints.insets.right = 3;
            }
        }
        return gridBagConstraints;
    }

    @Override
    public void addPadding() {
        if (this.fCategoryName == UNSPECIFIED_CATEGORY) {
            this.endCategory();
        }
        this.fCurrentConstraints.fill = 1;
        this.fCurrentConstraints.gridwidth = 2;
        this.fCurrentConstraints.weighty = 1.0;
        this.fCurrentConstraints.insets = new Insets(3, 0, 0, 0);
        MJPanel mJPanel = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        mJPanel.setOpaque(false);
        this.fCurrentPanel.add((Component)mJPanel, (Object)this.fCurrentConstraints);
        this.fCurrentConstraints.weighty = 0.0;
        this.fCurrentConstraints.gridwidth = 1;
        ++this.fCurrentConstraints.gridy;
    }

    private void addRightPadding() {
        if (((Boolean)this.fSuppressRightPadding.get()).booleanValue()) {
            return;
        }
        MJPanel mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        this.fCurrentConstraints.gridx = 2;
        this.fCurrentConstraints.weightx = 1.0;
        this.fCurrentConstraints.gridheight = this.fCurrentConstraints.gridy;
        this.fCurrentConstraints.gridy = 0;
        this.fCurrentPanel.add((Component)mJPanel, (Object)this.fCurrentConstraints);
        this.fCurrentConstraints.gridy = this.fCurrentConstraints.gridheight;
        this.fCurrentConstraints.gridheight = 1;
    }

    @Override
    public JComponent getComponent() {
        if (!this.fFinished) {
            this.fFinished = true;
            this.addRightPadding();
        }
        return this.fComponent;
    }
}

