/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.validation;

import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class NumericRule
implements ValidationRule {
    private final int fMin;
    private final int fMax;
    private final DecimalFormat fFormat;
    private final boolean fAllowFraction;

    public NumericRule(int n, int n2, DecimalFormat decimalFormat) {
        this(n, n2, false, decimalFormat);
    }

    public NumericRule(int n, int n2, boolean bl, DecimalFormat decimalFormat) {
        this.fMin = n;
        this.fMax = n2;
        this.fAllowFraction = bl;
        this.fFormat = decimalFormat;
    }

    @Override
    public String getErrorMessage(KeyEvent keyEvent) {
        if (!(keyEvent.getKeyChar() == '\uffff' || keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\b' || keyEvent.getKeyChar() == '\u007f' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '.' && this.fAllowFraction || keyEvent.isActionKey() || this.fFormat != null && keyEvent.getKeyChar() == this.fFormat.getDecimalFormatSymbols().getGroupingSeparator() || Character.isDigit(keyEvent.getKeyChar()) || keyEvent.getKeyChar() == '-' && this.isNegativeAllowed())) {
            return this.getDefaultMessage();
        }
        return null;
    }

    @Override
    public String getErrorMessage(String string) {
        if (this.fFormat != null) {
            string = string.replaceAll("\\Q" + this.fFormat.getDecimalFormatSymbols().getGroupingSeparator() + "\\E", "");
        }
        if (string.isEmpty()) {
            return null;
        }
        try {
            if (this.fMin < 0 && string.equals("-")) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal(string);
            if (bigDecimal.compareTo(new BigDecimal(this.fMin)) < 0 && this.fMin < 0 || bigDecimal.compareTo(new BigDecimal(this.fMax)) > 0) {
                return this.getOutOfBoundsMessage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            return this.getOutOfBoundsMessage();
        }
        return null;
    }

    private boolean isNegativeAllowed() {
        return this.fMin < 0;
    }

    private String getDefaultMessage() {
        return this.isNegativeAllowed() ? BuiltInResources.getString("spinner.popup.negative." + (this.fAllowFraction ? "double" : "int")) : BuiltInResources.getString("spinner.popup.positive." + (this.fAllowFraction ? "double" : "int"));
    }

    private String getOutOfBoundsMessage() {
        return MessageFormat.format(BuiltInResources.getString("spinner.popup.bounds"), this.fMin, this.fMax);
    }
}

