/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.selection.BrowseAction;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.dialog.SourceSelectionComboBox;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public final class SourceSelectionPickerButton
extends MJButton {
    private final SourceSelectionComboBox mAssociatedComboBox;
    private BrowseAction mCurrentBrowseAction;
    private boolean mFirstRegistration = true;

    public SourceSelectionPickerButton(SourceSelectionComboBox sourceSelectionComboBox) {
        this.mAssociatedComboBox = sourceSelectionComboBox;
    }

    public void register(SelectionDataType selectionDataType, String string, Icon icon, BrowseAction browseAction) {
        CheckNullArgument.check(selectionDataType, "aDataType");
        CheckNullArgument.check(string, "aLabel");
        CheckNullArgument.check(icon, "aIcon");
        Class<?> clazz = selectionDataType.getApplicableType();
        if (this.mFirstRegistration) {
            this.mFirstRegistration = false;
            this.setupBrowseAction(clazz, string, icon, browseAction);
        }
    }

    private void setupBrowseAction(Class<?> clazz, String string, Icon icon, BrowseAction browseAction) {
        this.mAssociatedComboBox.setCurrentStringConversionPolicyClass(clazz);
        this.setAction((Action)((Object)browseAction));
        this.setIcon(icon);
        this.setPreferredSize(new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8));
        this.mCurrentBrowseAction = browseAction;
        if (this.mCurrentBrowseAction != null) {
            this.setToolTipText(ResourceManager.format("selectiondialog.browse", string));
        } else {
            this.setToolTipText(ResourceManager.format("selectiondialog.browsedisabled", string));
        }
    }

    private class MenuAction
    extends AbstractAction {
        private Class<?> mType;
        private String mLabel;
        private Icon mIcon;
        private BrowseAction mBrowseAction;

        public MenuAction(Class<?> clazz, String string, Icon icon, BrowseAction browseAction) {
            this.mType = clazz;
            this.mLabel = string;
            this.mIcon = icon;
            this.mBrowseAction = browseAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceSelectionPickerButton.this.setupBrowseAction(this.mType, this.mLabel, this.mIcon, this.mBrowseAction);
        }
    }

    private class MainAction
    extends AbstractAction {
        private MainAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (SourceSelectionPickerButton.this.mCurrentBrowseAction != null) : "Main button should have been disabled if BrowseAction is null";
            SourceSelectionPickerButton.this.mCurrentBrowseAction.actionPerformed(actionEvent);
        }
    }
}

