/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.DirectoryResolver;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class FileCopier
implements FileProcessor {
    private final IO myIO;
    private final DirectoryResolver directoryResolver;
    private final FilenameFilter filenameFilter;
    private final AppLogger appLogger;

    FileCopier(IO iO, DirectoryResolver directoryResolver, AppLogger appLogger) {
        this(iO, directoryResolver, (FilenameFilter)FileFilterUtils.fileFileFilter(), appLogger);
    }

    FileCopier(IO iO, DirectoryResolver directoryResolver, FilenameFilter filenameFilter, AppLogger appLogger) {
        this.myIO = iO;
        this.directoryResolver = directoryResolver;
        this.filenameFilter = filenameFilter;
        this.appLogger = appLogger;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.copyFile(file, file2, installFlowControlHandler);
    }

    private void copyFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) {
        File file3 = new File(this.directoryResolver.resolveDirectory(file2), file.getName());
        this.appLogger.debugMsg("copyFile " + file.getAbsolutePath() + " to " + file3.getAbsolutePath());
        try {
            if (file.isDirectory()) {
                this.myIO.copyDirectory(file, file3);
            } else {
                this.myIO.copyFile(file, file3, new IOObserver[0]);
            }
        }
        catch (IOException iOException) {
            installFlowControlHandler.alert(iOException);
        }
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
        this.deleteFileIfCopiedToDestinationFolder(file, file2, installFlowControlHandler);
    }

    private void deleteFileIfCopiedToDestinationFolder(File file, File file2, InstallFlowControlHandler installFlowControlHandler) {
        File file3 = this.directoryResolver.resolveDirectory(file2);
        if (file3.equals(file2)) {
            File file4 = new File(file3, file.getName());
            this.appLogger.debugMsg("delete " + file.getAbsolutePath() + " from " + file2.getAbsolutePath());
            this.myIO.deleteFile(file4);
        }
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }
}

