/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocProductComparator;
import com.mathworks.install.command.doc.DocProductList;
import com.mathworks.install.command.doc.InstalledDocProduct;
import com.mathworks.install.command.doc.SharedDocUtils;
import com.mathworks.instutil.IO;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

class InstallerDocProductList
implements DocProductList {
    static FilenameFilter LOCALIZED_SEARCH_INDEX_FILTER = new LocalizedSearchIndexFilter();
    private final IO io;
    private final List<InstalledDocProduct> products = new ArrayList<InstalledDocProduct>();
    private final Collection<String> localeSuffixes = new LinkedHashSet<String>();

    InstallerDocProductList(IO iO) {
        this.io = iO;
    }

    @Override
    public synchronized void populate(File file, DocDestination docDestination) throws IOException {
        this.products.clear();
        LinkedList<InstalledDocProduct> linkedList = new LinkedList<InstalledDocProduct>();
        this.examineSubDirectories(file, "", linkedList, docDestination);
        this.products.addAll(linkedList);
        Collections.sort(this.products, new DocProductComparator());
    }

    @Override
    public synchronized List<InstalledDocProduct> getInstalledProducts() throws IOException {
        return Collections.unmodifiableList(this.products);
    }

    @Override
    public synchronized Collection<String> getLocaleSuffixes() {
        return Collections.unmodifiableCollection(this.localeSuffixes);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.products.isEmpty();
    }

    private void examineSubDirectories(File file, String string, List<InstalledDocProduct> list, DocDestination docDestination) throws IOException {
        File[] fileArray;
        for (File file2 : fileArray = this.io.listFiles(new File(file, string), null)) {
            if (!this.io.isDirectory(file2)) continue;
            String string2 = string;
            if (string.length() > 0) {
                string2 = string2 + "/";
            }
            string2 = string2 + file2.getName();
            this.findInstalledDocProducts(file, string2, list, docDestination);
        }
    }

    private void findInstalledDocProducts(File file, String string, List<InstalledDocProduct> list, DocDestination docDestination) throws IOException {
        File file2 = new File(new File(file, string), "doccenter.properties");
        if (this.io.isFile(file2)) {
            InstalledDocProduct installedDocProduct = SharedDocUtils.getProductPropertiesFromFile(this.io, file2, string);
            if (installedDocProduct.includeProduct(docDestination)) {
                this.localeSuffixes.addAll(this.findLocaleSuffixes(new File(file, string)));
                list.add(installedDocProduct);
            }
        } else {
            this.examineSubDirectories(file, string, list, docDestination);
        }
    }

    private static boolean includeProduct(String string, DocDestination docDestination) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(docDestination.toString() + "_only");
    }

    private List<String> findLocaleSuffixes(File file) {
        File[] fileArray = this.io.listFiles(file, LOCALIZED_SEARCH_INDEX_FILTER);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (File file2 : fileArray) {
            linkedList.add(file2.getName().substring("helpsearch_".length()));
        }
        return linkedList;
    }

    private static class LocalizedSearchIndexFilter
    implements FilenameFilter {
        private LocalizedSearchIndexFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("helpsearch_");
        }
    }
}

