/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.google.inject.Inject;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentDownloader;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install.input.ContentsXMLFile;
import com.mathworks.install.input.DWSInstallationInputFile;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.NoOpInstallationInputFile;
import com.mathworks.install.input.ProductArchiveFile;
import com.mathworks.install.input.ProductOrComponentXMLFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

final class InstallationInputFileFactoryImpl
implements InstallationInputFileFactory {
    private final ArchiveFactory archiveFactory;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceFactory componentSourceFactory;
    private final Downloader downloader;
    private final IO io;
    private final ProxyConfiguration proxyConfiguration;
    private final ContentOptimizer contentOptimizer;

    @Inject
    InstallationInputFileFactoryImpl(ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory, Downloader downloader, IO iO, ProxyConfiguration proxyConfiguration, ContentOptimizer contentOptimizer) {
        this.archiveFactory = archiveFactory;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceFactory = componentSourceFactory;
        this.downloader = downloader;
        this.io = iO;
        this.proxyConfiguration = proxyConfiguration;
        this.contentOptimizer = contentOptimizer;
    }

    @Override
    public InstallationInputFile createInstallationFile(File file, ComponentURLProvider componentURLProvider) {
        return new DWSInstallationInputFile(file, this.archiveFactory, this.xmlInstallationFileParser, new ComponentDownloader(componentURLProvider, this.downloader, this.io, this.proxyConfiguration, this.componentSourceFactory), this.contentOptimizer);
    }

    @Override
    public InstallationInputFile[] createInstallationFiles(File file) {
        ArrayList<InstallationInputFile> arrayList = new ArrayList<InstallationInputFile>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory() && this.contentOptimizer.accept(file2.getName())) {
                Collection collection = FileUtils.listFiles((File)file2, null, (boolean)true);
                for (File file3 : collection) {
                    arrayList.add(this.createInstallationFile(file3));
                }
                continue;
            }
            arrayList.add(this.createInstallationFile(file2));
        }
        return arrayList.toArray(new InstallationInputFile[arrayList.size()]);
    }

    private InstallationInputFile createInstallationFile(File file) {
        String string = file.getName();
        if (!InstallationInputFileFactoryImpl.isHiddenFile(string)) {
            if (InstallationInputFileFactoryImpl.isProductArchive(file)) {
                return new ProductArchiveFile(file, this.archiveFactory, this.xmlInstallationFileParser, this.componentSourceFactory);
            }
            if (InstallationInputFileFactoryImpl.isContentsFile(file)) {
                return new ContentsXMLFile(file, this.xmlInstallationFileParser, this.componentSourceFactory);
            }
            if (InstallationInputFileFactoryImpl.isXMLFile(string)) {
                return new ProductOrComponentXMLFile(file, this.xmlInstallationFileParser, this.componentSourceFactory);
            }
        }
        return new NoOpInstallationInputFile(file);
    }

    private static boolean isHiddenFile(String string) {
        return string.startsWith(".");
    }

    private static boolean isContentsFile(File file) {
        String string = file.getName();
        return string.startsWith("mwcontents") && InstallationInputFileFactoryImpl.isXMLFile(string);
    }

    private static boolean isXMLFile(String string) {
        return FilenameUtils.isExtension((String)string, (String)"xml");
    }

    private static boolean isProductArchive(File file) {
        return FilenameUtils.isExtension((String)file.getName(), (String)"zip");
    }
}

