/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.ComponentFileListParser;
import com.mathworks.install.FileListParser;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.OwningProductResponse;
import com.mathworks.install.OwningProductResponseImpl;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductFileListParser;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

final class InstalledProductDataImpl
implements InstalledProductData {
    private static final String APPDATA = "appdata";
    private static final String PRODUCT_CONTENTS_NAME = "prodcontents.bin";
    private static final String COMPONENT_CONTENTS_NAME = "compcontents.bin";
    private static final String PRODUCTS = "products";
    private static final String COMPONENTS = "components";
    private static final String FILES = "files";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Map<String, List<String>> installedProductContents = Collections.synchronizedMap(new HashMap());
    private Map<String, List<String>> installedComponentContents = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<String>> componentToFileListMap = Collections.synchronizedMap(new HashMap());
    private Map<File, String> filesToWrite = Collections.synchronizedMap(new HashMap());
    private List<File> filesToDelete = Collections.synchronizedList(new ArrayList());
    private final ProductContainer prodContainer;
    private final ComponentContainer compContainer;
    private final XMLParserFactory parserFactory;
    private final ExecutorService executor;
    private final Platform platform;
    private final InstalledProductDataVersion installedProductDataVersion;
    private final IO io;

    @Inject
    InstalledProductDataImpl(ProductContainer productContainer, ComponentContainer componentContainer, XMLParserFactory xMLParserFactory, ExecutorService executorService, Platform platform, InstalledProductDataVersion installedProductDataVersion, IO iO) {
        this.prodContainer = productContainer;
        this.compContainer = componentContainer;
        this.parserFactory = xMLParserFactory;
        this.executor = executorService;
        this.platform = platform;
        this.installedProductDataVersion = installedProductDataVersion;
        this.io = iO;
    }

    @Override
    public final void loadAllData(File file) throws IOException, XMLParseException, ExecutionException, InterruptedException {
        HashMap hashMap = new HashMap();
        File file2 = new File(file, APPDATA);
        this.startLoadingProductData(hashMap, file.getAbsolutePath());
        this.startLoadingComponentAndFileData(file, hashMap, file2);
        InstalledProductDataImpl.blockUntilLoadingIsComplete(hashMap);
    }

    @Override
    public final void writeContentsData(File file, Product[] productArray) throws IOException {
        for (File object : this.filesToDelete) {
            this.io.deleteFile(object);
        }
        this.filesToDelete.clear();
        File file2 = new File(file, APPDATA);
        this.writeContentsTo(file2, PRODUCT_CONTENTS_NAME, this.installedProductContents, file.getAbsolutePath());
        this.writeContentsTo(file2, COMPONENT_CONTENTS_NAME, this.installedComponentContents, file.getAbsolutePath());
        this.writeOutFiles();
        for (String string : this.componentToFileListMap.keySet()) {
            this.serializeData(InstalledProductDataImpl.getFileListFile(string, file.getAbsolutePath()), this.componentToFileListMap.get(string));
        }
        if (this.installedProductContents.isEmpty()) {
            this.io.deleteDirectory(file2);
        } else {
            this.installedProductDataVersion.write(file, productArray);
        }
    }

    private String getKeyForProductName(String string) {
        return string + ' ' + this.platform.getArchString();
    }

    private static void addToMappedList(String string, String string2, Map<String, List<String>> map) {
        List<String> list;
        List<String> list2 = map.get(string);
        if (list2 == null) {
            list = Collections.synchronizedList(new ArrayList());
            map.put(string, list);
        } else {
            list = list2;
        }
        for (String string3 : list) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            return;
        }
        list.add(string2);
    }

    @Override
    public final void installProductFileData(String string, String string2, String[] stringArray) throws IOException {
        String string3 = this.getKeyForProductName(string);
        File file = new File(new File(string2, APPDATA), PRODUCTS);
        for (String string4 : stringArray) {
            File file2 = new File(file, string3 + ' ' + InstalledProductDataImpl.getRandomNumber() + ".xml");
            String string5 = file2.getAbsolutePath();
            this.filesToWrite.put(file2, string4);
            InstalledProductDataImpl.addToMappedList(string3, string5, this.installedProductContents);
        }
    }

    @Override
    public final void installComponentFileData(String string, String string2, String string3) throws IOException {
        File file = new File(new File(string2, APPDATA), COMPONENTS);
        File file2 = new File(file, string + ' ' + InstalledProductDataImpl.getRandomNumber() + ".xml");
        this.filesToWrite.put(file2, string3);
        InstalledProductDataImpl.addToMappedList(string, file2.getAbsolutePath(), this.installedComponentContents);
    }

    @Override
    public final void installFileListData(Set<String> set, String string, String string2) throws IOException {
        this.componentToFileListMap.put(string, set);
    }

    @Override
    public final String[] getNonSharedFiles(String string, String string2) {
        String string3 = this.getComponentToFileListMapKey(string);
        if (this.componentToFileListMap.containsKey(string3)) {
            Set<String> set = this.componentToFileListMap.get(string3);
            for (String string4 : this.componentToFileListMap.keySet()) {
                if (string4.equalsIgnoreCase(string3)) continue;
                this.removeSharedFiles(set, string4);
            }
            return InstalledProductDataImpl.transformIntoAbsolutePaths(string2, set);
        }
        return EMPTY_STRING_ARRAY;
    }

    private String getComponentToFileListMapKey(String string) {
        if (this.componentToFileListMap.containsKey(InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string))) {
            return InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string);
        }
        return string;
    }

    @Override
    public final long getTotalFileCount(String[] stringArray, String string) {
        Set<String> set = this.getAllFilesInComponents(stringArray);
        this.removeFilesAlsoInComponentsNotBeingUninstalled(stringArray, set);
        return set.size();
    }

    @Override
    public OwningProductResponse getOwningFiles(File file, String[] stringArray) {
        InstallableProduct[] installableProductArray;
        HashSet<Product> hashSet = new HashSet<Product>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (String string : stringArray) {
            File file2 = new File(string);
            String string2 = FilenameUtils.normalize((String)file2.getAbsolutePath());
            hashSet3.add(string2);
            hashSet2.add(string2);
        }
        String string = this.platform.getArchString();
        for (InstallableProduct installableProduct : installableProductArray = this.prodContainer.getInstallableProducts(string)) {
            ComponentData[] componentDataArray;
            for (ComponentData componentData : componentDataArray = installableProduct.getRequiredComponents(string)) {
                Iterator<String> iterator = this.componentToFileListMap.get(componentData.getComponentNameAndVersion()).iterator();
                while (iterator.hasNext()) {
                    FileCollectionMatcher fileCollectionMatcher = new FileCollectionMatcher();
                    FileCollections<Boolean> fileCollections = new FileCollections<Boolean>(fileCollectionMatcher, hashSet3);
                    String string3 = iterator.next();
                    File file3 = new File(file, string3);
                    String string4 = file3.getAbsolutePath();
                    if (!fileCollections.findMatch(string4).booleanValue()) continue;
                    hashSet.add(installableProduct.getProductData());
                    Collections.addAll(hashSet, installableProduct.getRequiredProducts());
                    FileCollectionRemoveMatch fileCollectionRemoveMatch = new FileCollectionRemoveMatch(hashSet2);
                    FileCollections<Void> fileCollections2 = new FileCollections<Void>(fileCollectionRemoveMatch, hashSet2);
                    fileCollections2.findMatch(string4);
                }
            }
        }
        return new OwningProductResponseImpl(hashSet.toArray(new Product[hashSet.size()]), hashSet2.toArray(new String[hashSet2.size()]));
    }

    private void loadProductDataOnly(String string) throws IOException, ExecutionException, XMLParseException, InterruptedException {
        HashMap hashMap = new HashMap();
        this.startLoadingProductData(hashMap, string);
        InstalledProductDataImpl.blockUntilLoadingIsComplete(hashMap);
    }

    @Override
    public final InstallableProduct[] getInstallableProds(File file) {
        InstallableProduct[] installableProductArray = null;
        try {
            this.loadProductDataOnly(file.getAbsolutePath());
            installableProductArray = this.prodContainer.getInstallableProducts(this.platform.getArchString());
        }
        catch (IOException iOException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (XMLParseException xMLParseException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return installableProductArray;
    }

    private void removeFilesAlsoInComponentsNotBeingUninstalled(String[] stringArray, Set<String> set) {
        for (String string : this.installedComponentContents.keySet()) {
            if (InstalledProductDataImpl.beingUninstalled(string, stringArray)) continue;
            for (String string2 : this.componentToFileListMap.get(string)) {
                set.remove(string2);
            }
        }
    }

    private static boolean beingUninstalled(String string, String[] stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string) && !InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string2).equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    private static String extractNameFromComponentNameAndVersion(String string) {
        return string.split(" ")[0];
    }

    @Override
    public final void removeComponent(String string, String string2) throws IOException {
        String string3 = this.getComponentToFileListMapKey(string);
        this.filesToDelete.add(InstalledProductDataImpl.getFileListFile(string3, string2));
        this.componentToFileListMap.remove(string3);
        this.removeEntry(string2, string3, this.installedComponentContents);
    }

    @Override
    public final void removeProduct(String string, String string2) throws IOException {
        String string3 = this.getKeyForProductName(string);
        this.removeEntry(string2, string3, this.installedProductContents);
    }

    private void removeEntry(String string, String string2, Map<String, List<String>> map) throws IOException {
        if (map.containsKey(string2)) {
            this.deleteAll(map.get(string2), string);
            map.remove(string2);
        }
    }

    private void deleteAll(List<String> list, String string) throws IOException {
        for (String string2 : list) {
            File file = string2.startsWith(string) ? new File(string2) : new File(string, string2);
            this.filesToDelete.add(file);
        }
    }

    private static String[] transformIntoAbsolutePaths(String string, Set<String> set) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : set) {
            linkedHashSet.add(new File(string, string2).getAbsolutePath());
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private void writeOutFiles() throws IOException {
        for (File file : this.filesToWrite.keySet()) {
            this.io.createParentIfNecessary(file);
            try {
                this.io.writeStringToFile(this.filesToWrite.get(file), file, 0L, 420, new IOObserver[0]);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.filesToWrite.clear();
    }

    private static long getRandomNumber() {
        long l = new SecureRandom().nextLong();
        l = l == Long.MIN_VALUE ? 0L : Math.abs(l);
        return l;
    }

    private void writeContentsTo(File file, String string, Map<String, List<String>> map, String string2) throws IOException {
        File file2 = new File(file, string);
        if (!map.isEmpty()) {
            for (String string3 : map.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string4 : map.get(string3)) {
                    if (string4.startsWith(string2)) {
                        arrayList.add(string4.substring(string2.length(), string4.length()));
                        continue;
                    }
                    arrayList.add(string4);
                }
                map.put(string3, arrayList);
            }
            this.serializeData(file2, map);
        } else if (file2.isFile()) {
            this.io.deleteFile(file2);
        }
    }

    static File getFileListFile(String string, String string2) {
        return new File(new File(new File(string2, APPDATA), FILES), string + "_manifest.bin");
    }

    private void removeSharedFiles(Set<String> set, String string) {
        for (String string2 : this.componentToFileListMap.get(string)) {
            if (!set.contains(string2)) continue;
            set.remove(string2);
        }
    }

    private Set<String> getAllFilesInComponents(String[] stringArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : stringArray) {
            String string2 = this.getComponentToFileListMapKey(string);
            if (!this.componentToFileListMap.containsKey(string2)) continue;
            linkedHashSet.addAll((Collection<String>)this.componentToFileListMap.get(string2));
        }
        return linkedHashSet;
    }

    private void startLoadingProductData(Map<Future<?>, FileListParser> map, String string) throws IOException {
        File file = new File(new File(string, APPDATA), PRODUCT_CONTENTS_NAME);
        if (file.isFile()) {
            InstalledProductDataImpl.setUpContentsMap(new File(string), file, this.installedProductContents);
            for (String string2 : this.installedProductContents.keySet()) {
                ProductFileListParser productFileListParser = new ProductFileListParser(string2, this.parserFactory, this.prodContainer, this.compContainer, this.installedProductContents, InstalledProductDataImpl.getArchForName(string2));
                map.put(this.executor.submit(productFileListParser), productFileListParser);
            }
        }
    }

    private void startLoadingComponentAndFileData(File file, Map<Future<?>, FileListParser> map, File file2) throws IOException {
        File file3 = new File(file2, COMPONENT_CONTENTS_NAME);
        if (file3.isFile()) {
            InstalledProductDataImpl.setUpContentsMap(file, file3, this.installedComponentContents);
            for (String string : this.installedComponentContents.keySet()) {
                ComponentFileListParser componentFileListParser = new ComponentFileListParser(string, file.getAbsolutePath(), this.parserFactory, this.prodContainer, this.compContainer, this.installedComponentContents, this.componentToFileListMap, InstalledProductDataImpl.getArchForName(string));
                map.put(this.executor.submit(componentFileListParser), componentFileListParser);
            }
        }
    }

    private static String getArchForName(String string) {
        return string.substring(string.lastIndexOf(32) + 1);
    }

    private static void setUpContentsMap(File file, File file2, Map<String, List<String>> map) throws IOException {
        Map map2 = Collections.synchronizedMap((Map)InstalledProductDataImpl.deserializeData(file2));
        for (String string : map2.keySet()) {
            List list = (List)map2.get(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : list) {
                arrayList.add(file + string2);
            }
            map.put(string, arrayList);
        }
    }

    private static void blockUntilLoadingIsComplete(Map<Future<?>, FileListParser> map) throws InterruptedException, ExecutionException, IOException, XMLParseException {
        for (Future<?> future : map.keySet()) {
            future.get();
            FileListParser fileListParser = map.get(future);
            if (fileListParser.getIOException() != null) {
                throw fileListParser.getIOException();
            }
            if (fileListParser.getXMLParseException() == null) continue;
            throw fileListParser.getXMLParseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeData(File file, Object object) throws IOException {
        this.io.createParentIfNecessary(file);
        ObjectOutputStream objectOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(objectOutputStream);
            IOUtils.closeQuietly(bufferedOutputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)objectOutputStream);
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    static Object deserializeData(File file) throws IOException {
        Object object = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new IOException();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objectInputStream);
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly((InputStream)fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)objectInputStream);
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return object;
    }

    private static class FileCollectionRemoveMatch
    implements FileCollectionVisitor<Void> {
        private final Set<String> collectionToDeleteFrom;
        private final Set<String> fileNamesToDelete = new HashSet<String>();

        FileCollectionRemoveMatch(Set<String> set) {
            this.collectionToDeleteFrom = set;
        }

        @Override
        public void matchWhileVisiting(String string) {
            this.fileNamesToDelete.add(string);
        }

        @Override
        public Void afterVisit() {
            for (String string : this.fileNamesToDelete) {
                this.collectionToDeleteFrom.remove(string);
            }
            return null;
        }
    }

    private static class FileCollectionMatcher
    implements FileCollectionVisitor<Boolean> {
        private boolean matchFound = false;

        private FileCollectionMatcher() {
        }

        @Override
        public void matchWhileVisiting(String string) {
            this.matchFound = true;
        }

        @Override
        public Boolean afterVisit() {
            return this.matchFound;
        }
    }

    private static interface FileCollectionVisitor<V> {
        public void matchWhileVisiting(String var1);

        public V afterVisit();
    }

    private class FileCollections<V> {
        private final FileCollectionVisitor<V> fileVisitor;
        private final Set<String> collection;

        FileCollections(FileCollectionVisitor<V> fileCollectionVisitor, Set<String> set) {
            this.fileVisitor = fileCollectionVisitor;
            this.collection = Collections.unmodifiableSet(set);
        }

        V findMatch(String string) {
            for (String string2 : this.collection) {
                if (!FilenameUtils.equalsOnSystem((String)string2, (String)string)) continue;
                this.fileVisitor.matchWhileVisiting(string2);
            }
            return this.fileVisitor.afterVisit();
        }
    }
}

