/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.install.command.SystemDirectoryProvider;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

final class DllRegisterer
implements FileProcessor {
    static final long REGISTER_TIMEOUT = 60000L;
    static final long REGISTER_RETRY_INCREMENT = 5000L;
    private final ProcessExecutor processExecutor;
    private ExecutorService executorService;
    private final SystemDirectoryProvider systemDirectoryProvider;
    private static final String REGSVR32_EXE = "regsvr32.exe";
    private final AppLogger appLogger;

    DllRegisterer(ProcessExecutor processExecutor, ExecutorService executorService, SystemDirectoryProvider systemDirectoryProvider, AppLogger appLogger) {
        this.processExecutor = processExecutor;
        this.executorService = executorService;
        this.systemDirectoryProvider = systemDirectoryProvider;
        this.appLogger = appLogger;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Registering " + file.getName());
        this.registerDll(file, installFlowControlHandler, new String[0]);
    }

    private void registerDll(File file, InstallFlowControlHandler installFlowControlHandler, String ... stringArray) throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.buildRegisterDllCommand(arrayList);
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.add('\"' + file.getAbsolutePath() + '\"');
        this.executeRegisterDllCommand(arrayList, 60000L, installFlowControlHandler);
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.unregisterDll(file, installFlowControlHandler);
    }

    private void unregisterDll(File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("UnRegistering " + file.getName());
        this.registerDll(file, installFlowControlHandler, "/u");
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".ocx"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".dll"));
    }

    private void buildRegisterDllCommand(Collection<String> collection) {
        File file = new File(this.systemDirectoryProvider.getSystemDirectory(), REGSVR32_EXE);
        collection.add(file.getAbsolutePath());
        collection.add("/s");
    }

    private void executeRegisterDllCommand(Collection<String> collection, long l, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        try {
            String string = Arrays.toString(collection.toArray());
            this.appLogger.logMsg("Running " + string);
            int n = this.processExecutor.runtimeExecWithTimeout(collection.toArray(new String[collection.size()]), l, this.executorService);
            if (n != 0) {
                this.appLogger.logMsg("Error running " + string + "status = " + n);
            }
            this.appLogger.logMsg("Completed running " + string);
        }
        catch (TimeoutException timeoutException) {
            String string = InstallResourceKeys.DLL_REGISTRATION_TIMEOUT_TITLE.getString(new Object[0]);
            String string2 = InstallResourceKeys.DLL_REGISTRATION_TIMEOUT_MESSAGE.getString(timeoutException.getMessage());
            if (installFlowControlHandler.shouldRetry(string, string2, timeoutException)) {
                this.executeRegisterDllCommand(collection, l + 5000L, installFlowControlHandler);
            }
        }
        catch (ExecutionException executionException) {
            installFlowControlHandler.exception(executionException);
        }
        catch (InterruptedException interruptedException) {
            try {
                installFlowControlHandler.checkTaskState();
                installFlowControlHandler.exitImmediately(interruptedException);
            }
            catch (InterruptedException interruptedException2) {
                throw interruptedException;
            }
        }
    }
}

