/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocProductList;
import com.mathworks.install.command.doc.InstalledDocProduct;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.SharedDocUtils;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;

class DocLandingPageCommand
implements SharedDocSubCommand {
    static final FilenameFilter LANDING_PAGE_FILTER = new LandingPageFilter();
    private final IO io;
    private final DocDestination destination;

    DocLandingPageCommand(IO iO, DocDestination docDestination) {
        this.io = iO;
        this.destination = docDestination;
    }

    @Override
    public void handleProductsFound(File file, DocProductList docProductList) throws IOException, InterruptedException {
        this.buildLandingPage(file, docProductList.getInstalledProducts(), "");
        for (String string : docProductList.getLocaleSuffixes()) {
            this.buildLandingPage(file, docProductList.getInstalledProducts(), string);
        }
    }

    @Override
    public void handleNoProducts(File file) throws IOException, InterruptedException {
        File[] fileArray;
        for (File file2 : fileArray = this.io.listFiles(file, LANDING_PAGE_FILTER)) {
            this.io.deleteFile(file2);
        }
    }

    protected void buildLandingPage(File file, List<InstalledDocProduct> list, String string) throws IOException, InterruptedException {
        File file2 = new File(file, "templates/documentation-center.xsl");
        if (!this.io.isFile(file2)) {
            return;
        }
        Document document = SharedDocUtils.buildDocSetXmlDocument(list);
        try {
            Map<String, String> map = this.createXslParameters(string);
            String string2 = this.doXslTransform(file2, document, map);
            String string3 = DocLandingPageCommand.getLandingPageName(string);
            this.io.writeStringToFile(string2, new File(file, string3), System.currentTimeMillis(), 420, new IOObserver[0]);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            throw new IOException("Unable to create documentation-center.html page", exception);
        }
    }

    private static String getLandingPageName(String string) {
        return string == null || string.trim().length() == 0 ? "documentation-center.html" : "documentation-center_" + string + ".html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doXslTransform(File file, Document document, Map<String, String> map) throws Exception {
        InputStream inputStream = this.getInputStream(file);
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(inputStream));
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                transformer.setParameter(object2.getKey(), object2.getValue());
            }
            JDOMSource jDOMSource = new JDOMSource(document);
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform((Source)jDOMSource, streamResult);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            inputStream.close();
            stringWriter.close();
        }
    }

    private Map<String, String> createXslParameters(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null && string.trim().length() > 0) {
            linkedHashMap.put("locale", string);
        }
        linkedHashMap.put("destination", this.destination.toString().toLowerCase(Locale.ENGLISH));
        return linkedHashMap;
    }

    protected InputStream getInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static class LandingPageFilter
    implements FilenameFilter {
        private LandingPageFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.matches("^documentation-center(_\\w+)?.html$");
        }
    }
}

